/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class YawgmothsVileOfferingEffect
extends OneShotEffect {
    YawgmothsVileOfferingEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put up to one target creature or planeswalker card from a graveyard onto the battlefield under your control. Destroy up to one target creature or planeswalker";
    }

    private YawgmothsVileOfferingEffect(YawgmothsVileOfferingEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card returnCard = game.getCard(source.getTargets().getFirstTarget());
        if (returnCard != null) {
            controller.moveCards(returnCard, Zone.BATTLEFIELD, source, game);
        }
        if ((permanent = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget())) != null) {
            permanent.destroy(source, game, false);
        }
        return false;
    }

    public YawgmothsVileOfferingEffect copy() {
        return new YawgmothsVileOfferingEffect(this);
    }
}

