/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToBattlefieldUnderYourControlTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class YodaJediMasterEffect
extends OneShotEffect {
    YodaJediMasterEffect() {
        super(Outcome.Detriment);
        this.staticText = "Exile another target permanent you own. Return that card to the battlefield under your control at the beginning of your next end step";
    }

    private YodaJediMasterEffect(YodaJediMasterEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (permanent != null && sourcePermanent != null && permanent.moveToExile(source.getSourceId(), sourcePermanent.getName(), source, game)) {
            ReturnToBattlefieldUnderYourControlTargetEffect effect = new ReturnToBattlefieldUnderYourControlTargetEffect();
            effect.setText("Return that card to the battlefield under your control at the beginning of your next end step");
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent.getId(), game));
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect), source);
            return true;
        }
        return false;
    }

    public YodaJediMasterEffect copy() {
        return new YodaJediMasterEffect(this);
    }
}

