/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreatureOrPlaneswalker;

class YotiaDeclaresWarEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledArtifactPermanent("untapped artifacts you control");

    YotiaDeclaresWarEffect() {
        super(Outcome.Benefit);
        this.staticText = "tap any number of untapped artifacts you control. When you do, {this} deals that much damage to target creature or planeswalker";
    }

    private YotiaDeclaresWarEffect(YotiaDeclaresWarEffect effect) {
        super((OneShotEffect)effect);
    }

    public YotiaDeclaresWarEffect copy() {
        return new YotiaDeclaresWarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        List permanents = target.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (permanents.isEmpty()) {
            return false;
        }
        for (Permanent permanent : permanents) {
            permanent.tap(source, game);
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(permanents.size()), false);
        ability.addTarget((Target)new TargetCreatureOrPlaneswalker());
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }

    static {
        filter.add((Predicate)TappedPredicate.UNTAPPED);
    }
}

