/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.LoseLifeOpponentsEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class YurikoTheTigersShadowEffect
extends OneShotEffect {
    YurikoTheTigersShadowEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top card of your library and put that card into your hand. Each opponent loses life equal to that card's mana value";
    }

    private YurikoTheTigersShadowEffect(YurikoTheTigersShadowEffect effect) {
        super((OneShotEffect)effect);
    }

    public YurikoTheTigersShadowEffect copy() {
        return new YurikoTheTigersShadowEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        player.moveCards(card, Zone.HAND, source, game);
        return new LoseLifeOpponentsEffect(card.getManaValue()).apply(game, source);
    }
}

