/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.CastFromHandWithoutPayingManaCostEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class YusriFortunesFlameEffect
extends OneShotEffect {
    YusriFortunesFlameEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a number between 1 and 5. Flip that many coins. For each flip you win, draw a card. For each flip you lose, {this} deals 2 damage to you. If you won five flips this way, you may cast spells from your hand this turn without paying their mana costs";
    }

    private YusriFortunesFlameEffect(YusriFortunesFlameEffect effect) {
        super((OneShotEffect)effect);
    }

    public YusriFortunesFlameEffect copy() {
        return new YusriFortunesFlameEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int flips = player.getAmount(1, 5, "Choose a number between 1 and 5", source, game);
        int wins = player.flipCoins(source, game, flips, true).stream().mapToInt(x -> x != false ? 1 : 0).sum();
        int losses = flips - wins;
        player.drawCards(wins, source, game);
        player.damage(2 * losses, source.getSourceId(), source, game);
        if (wins >= 5) {
            game.addEffect((ContinuousEffect)new CastFromHandWithoutPayingManaCostEffect().setDuration(Duration.EndOfTurn), source);
        }
        return true;
    }
}

