/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.keyword.ModularAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.util.CardUtil;

class ZabazTheGlimmerwaspEffect
extends ReplacementEffectImpl {
    ZabazTheGlimmerwaspEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature, false);
        this.staticText = "if a modular triggered ability would put one or more +1/+1 counters on a creature you control, that many plus one +1/+1 counters are put on it instead";
    }

    private ZabazTheGlimmerwaspEffect(ZabazTheGlimmerwaspEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmountForCounters(CardUtil.overflowInc((int)event.getAmount(), (int)1), true);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ADD_COUNTERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!event.getData().equals(CounterType.P1P1.getName()) || event.getAmount() < 1) {
            return false;
        }
        StackObject stackAbility = game.getStack().getStackObject(event.getSourceId());
        if (stackAbility == null || !(stackAbility.getStackAbility() instanceof ModularAbility)) {
            return false;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent == null) {
            permanent = game.getPermanentEntering(event.getTargetId());
        }
        return permanent != null && permanent.isControlledBy(source.getControllerId()) && permanent.isCreature(game);
    }

    public ZabazTheGlimmerwaspEffect copy() {
        return new ZabazTheGlimmerwaspEffect(this);
    }
}

