/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.LandsYouControlCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.HeroToken;

class ZanarkandAncientMetropolisEffect
extends OneShotEffect {
    ZanarkandAncientMetropolisEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a 1/1 colorless Hero creature token. Put a +1/+1 counter on it for each land you control";
    }

    private ZanarkandAncientMetropolisEffect(ZanarkandAncientMetropolisEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZanarkandAncientMetropolisEffect copy() {
        return new ZanarkandAncientMetropolisEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HeroToken token = new HeroToken();
        token.putOntoBattlefield(1, game, source);
        int amount = LandsYouControlCount.instance.calculate(game, source, (Effect)this);
        if (amount < 1) {
            return true;
        }
        for (UUID tokenId : token.getLastAddedTokenIds()) {
            Permanent permanent = game.getPermanent(tokenId);
            if (permanent == null) continue;
            permanent.addCounters(CounterType.P1P1.createInstance(amount), source, game);
        }
        return true;
    }
}

