/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.GameEvent;
import mage.game.events.MilledBatchForOnePlayerEvent;
import mage.game.events.MilledCardEvent;
import mage.game.permanent.token.Horror2Token;
import mage.game.permanent.token.Token;

class ZellixSanityFlayerTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<MilledCardEvent> {
    ZellixSanityFlayerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new Horror2Token()));
        this.withFlavorWord("Hive Mind");
        this.setTriggerPhrase("Whenever a player mills one or more creature cards, you ");
    }

    private ZellixSanityFlayerTriggeredAbility(ZellixSanityFlayerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ZellixSanityFlayerTriggeredAbility copy() {
        return new ZellixSanityFlayerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.MILLED_CARDS_BATCH_FOR_ONE_PLAYER;
    }

    public boolean checkEvent(MilledCardEvent event, Game game) {
        Card card = event.getCard(game);
        return card != null && card.isCreature(game);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return !this.getFilteredEvents((BatchEvent)((MilledBatchForOnePlayerEvent)event), game).isEmpty();
    }
}

