/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;
import org.apache.log4j.Logger;

class ZethiArcaneBlademasterCastEffect
extends OneShotEffect {
    ZethiArcaneBlademasterCastEffect() {
        super(Outcome.Benefit);
        this.staticText = "copy each exiled card you own with a kick counter on it. You may cast the copies";
    }

    private ZethiArcaneBlademasterCastEffect(ZethiArcaneBlademasterCastEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZethiArcaneBlademasterCastEffect copy() {
        return new ZethiArcaneBlademasterCastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(game.getExile().getCardsOwned(game, source.getControllerId()));
        cards.removeIf(uuid -> !game.getCard(uuid).getCounters(game).containsKey(CounterType.KICK));
        if (cards.isEmpty()) {
            return false;
        }
        CardsImpl copies = new CardsImpl();
        for (Card card : cards.getCards(game)) {
            Card copiedCard = game.copyCard(card, source, source.getControllerId());
            copies.add(copiedCard);
        }
        boolean keepGoing = true;
        CardsImpl alreadyCast = new CardsImpl();
        while (keepGoing) {
            for (Card copiedCard : copies.getCards(game)) {
                if (alreadyCast.getCards(game).contains(copiedCard) || !controller.chooseUse(this.outcome, "Cast the copied card? " + copiedCard.getIdName(), source, game)) continue;
                alreadyCast.add(copiedCard);
                if (copiedCard.getSpellAbility() != null) {
                    game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), (Object)Boolean.TRUE);
                    controller.cast(controller.chooseAbilityForCast(copiedCard, game, false), game, false, new ApprovingObject(source, game));
                    game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), null);
                    continue;
                }
                Logger.getLogger(ZethiArcaneBlademasterCastEffect.class).error((Object)("Chun Li, Countless Kicks: spell ability == null " + copiedCard.getName()));
            }
            keepGoing = controller.chooseUse(Outcome.Detriment, "Do you wish to continue casting? ", source, game);
        }
        return true;
    }
}

