/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class ZethiArcaneBlademasterExileEffect
extends OneShotEffect {
    ZethiArcaneBlademasterExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to X target instant cards from your graveyard, where X is the number of times {this} was kicked. Put a kick counter on each of them";
    }

    private ZethiArcaneBlademasterExileEffect(ZethiArcaneBlademasterExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZethiArcaneBlademasterExileEffect copy() {
        return new ZethiArcaneBlademasterExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        CardsImpl cards = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
        if (player == null || cards.isEmpty()) {
            return false;
        }
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.getCards(game).forEach(card -> card.addCounters(CounterType.KICK.createInstance(), source, game));
        return true;
    }
}

