/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.z.ZevlorElturelExileEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.Target;

class ZevlorElturelExileTriggeredAbility
extends DelayedTriggeredAbility {
    ZevlorElturelExileTriggeredAbility() {
        super((Effect)new ZevlorElturelExileEffect(), Duration.EndOfTurn, true, false);
    }

    private ZevlorElturelExileTriggeredAbility(ZevlorElturelExileTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public ZevlorElturelExileTriggeredAbility copy() {
        return new ZevlorElturelExileTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        Spell spell = game.getSpell(event.getTargetId());
        if (spell == null || !spell.isInstantOrSorcery(game)) {
            return false;
        }
        Set targets = spell.getSpellAbility().getTargets().stream().map(Target::getTargets).flatMap(Collection::stream).collect(Collectors.toSet());
        targets.removeIf(uuid -> game.getPermanent(uuid) == null && game.getPlayer(uuid) == null);
        if (targets.size() != 1) {
            return false;
        }
        UUID targetId = (UUID)targets.iterator().next();
        Set opponents = game.getOpponents(this.getControllerId());
        if (opponents.contains(targetId)) {
            this.getEffects().setValue("targetId", (Object)targetId);
        } else if (opponents.contains(game.getControllerId(targetId))) {
            this.getEffects().setValue("targetId", (Object)game.getControllerId(targetId));
        } else {
            return false;
        }
        this.getEffects().setValue("savedSpell", (Object)spell);
        return true;
    }

    public String getRule() {
        return "When you next cast an instant or sorcery spell that targets only a single opponent or a single permanent an opponent controls this turn, for each other opponent, choose that player or a permanent they control, copy that spell, and the copy targets the chosen player or permanent.";
    }
}

