/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;
import mage.target.common.TargetSacrifice;

class ZiatoraTheIncineratorEffect
extends OneShotEffect {
    ZiatoraTheIncineratorEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may sacrifice another creature. When you do, {this} deals damage equal to that creature's power to any target and you create three Treasure tokens";
    }

    private ZiatoraTheIncineratorEffect(ZiatoraTheIncineratorEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZiatoraTheIncineratorEffect copy() {
        return new ZiatoraTheIncineratorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(0, 1, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_CREATURE);
        player.choose(Outcome.Sacrifice, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null || !permanent.sacrifice(source, game)) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(permanent.getPower().getValue()), false);
        ability.addEffect((Effect)new CreateTokenEffect((Token)new TreasureToken(), 3).concatBy("and"));
        ability.addTarget((Target)new TargetAnyTarget());
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

