/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.CanBeSacrificedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class ZodiarkUmbralGodEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("non-God creatures you control");
    private static final FilterPermanent filter2 = new FilterControlledCreaturePermanent("non-God creatures you control");
    private static final Predicate<MageObject> predicate = Predicates.not((Predicate)SubType.GOD.getPredicate());

    ZodiarkUmbralGodEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player sacrifices half the non-God creatures they control of their choice, rounded down";
    }

    private ZodiarkUmbralGodEffect(ZodiarkUmbralGodEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZodiarkUmbralGodEffect copy() {
        return new ZodiarkUmbralGodEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet permanents = new HashSet();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            int count;
            Player player = game.getPlayer(playerId);
            if (player == null || (count = Math.min(game.getBattlefield().count(filter, playerId, source, game) / 2, game.getBattlefield().count(filter2, playerId, source, game))) < 1) continue;
            TargetPermanent target = new TargetPermanent(count, count, filter2, true);
            target.withChooseHint("to sacrifice");
            player.choose(this.outcome, (Target)target, source, game);
            target.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).forEach(permanents::add);
        }
        if (permanents.isEmpty()) {
            return false;
        }
        for (Permanent permanent : permanents) {
            permanent.sacrifice(source, game);
        }
        return true;
    }

    static {
        filter.add(predicate);
        filter2.add(predicate);
        filter2.add((Predicate)CanBeSacrificedPredicate.instance);
    }
}

