/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.ObjectColor;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ZombieBoaTriggeredAbility
extends DelayedTriggeredAbility {
    private final ObjectColor color;

    ZombieBoaTriggeredAbility(ObjectColor color) {
        super((Effect)new DestroyTargetEffect(), Duration.EndOfTurn, false, false);
        this.color = color;
    }

    private ZombieBoaTriggeredAbility(ZombieBoaTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.color = ability.color;
    }

    public ZombieBoaTriggeredAbility copy() {
        return new ZombieBoaTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.BLOCKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getTargetId().equals(this.getSourceId())) {
            return false;
        }
        Permanent permanent = game.getPermanent(event.getSourceId());
        if (permanent == null || !permanent.isCreature(game) || !permanent.getColor(game).contains(this.color)) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getSourceId(), game));
        return true;
    }

    public String getRule() {
        return "Whenever {this} becomes blocked by a creature of that color this turn, destroy that creature";
    }
}

