/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class ZombieMobExileEffect
extends OneShotEffect {
    ZombieMobExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile all creature cards from your graveyard";
    }

    private ZombieMobExileEffect(ZombieMobExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZombieMobExileEffect copy() {
        return new ZombieMobExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
        controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        return true;
    }
}

