/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.DiscoverEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ZoyowasJusticeEffect
extends OneShotEffect {
    ZoyowasJusticeEffect() {
        super(Outcome.Neutral);
        this.staticText = "the owner of target artifact or creature with mana value 1 or greater shuffles it into their library. Then that player discovers X, where X is its mana value";
    }

    private ZoyowasJusticeEffect(ZoyowasJusticeEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZoyowasJusticeEffect copy() {
        return new ZoyowasJusticeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        int value = permanent.getManaValue();
        Player owner = game.getPlayer(permanent.getOwnerId());
        if (owner == null) {
            return false;
        }
        owner.shuffleCardsToLibrary((Card)permanent, game, source);
        DiscoverEffect.doDiscover((Player)owner, (int)value, (Game)game, (Ability)source);
        return true;
    }
}

