/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ZulaportDuelistEffect
extends OneShotEffect {
    ZulaportDuelistEffect() {
        super(Outcome.Benefit);
        this.staticText = "up to one target creature gets -2/-0 until end of turn. Its controller mills two cards";
    }

    private ZulaportDuelistEffect(ZulaportDuelistEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZulaportDuelistEffect copy() {
        return new ZulaportDuelistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        game.addEffect((ContinuousEffect)new BoostTargetEffect(-2, 0), source);
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        if (player == null) {
            return false;
        }
        player.millCards(2, source, game);
        return true;
    }
}

