/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.CompoundAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.HexproofAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.z.ZurEternalSchemerEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.common.FilterEnchantmentPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class ZurEternalSchemer
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("Enchantment creatures");
    private static final FilterEnchantmentPermanent filter2 = new FilterEnchantmentPermanent("non-Aura enchantment you control");

    public ZurEternalSchemer(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{W}{U}{B}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.HUMAN);
        this.subtype.add((Object)SubType.WIZARD);
        this.power = new MageInt(1);
        this.toughness = new MageInt(4);
        this.addAbility((Ability)FlyingAbility.getInstance());
        CompoundAbility compoundAbilities = new CompoundAbility(new Ability[]{DeathtouchAbility.getInstance(), LifelinkAbility.getInstance(), HexproofAbility.getInstance()});
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new GainAbilityControlledEffect(compoundAbilities, Duration.WhileOnBattlefield, (FilterPermanent)filter)));
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new ZurEternalSchemerEffect(), (Cost)new ManaCostsImpl("{1}{W}"));
        ability.addTarget((Target)new TargetPermanent((FilterPermanent)filter2));
        this.addAbility((Ability)ability);
    }

    private ZurEternalSchemer(ZurEternalSchemer card) {
        super((CardImpl)card);
    }

    public ZurEternalSchemer copy() {
        return new ZurEternalSchemer(this);
    }

    static {
        filter.add((Predicate)CardType.ENCHANTMENT.getPredicate());
        filter2.add(Predicates.not((Predicate)SubType.AURA.getPredicate()));
        filter2.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
    }
}

