/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.ArrayList;
import java.util.Collections;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ZzzyxassAbyssEffect
extends OneShotEffect {
    ZzzyxassAbyssEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "destroy all nonland permanents with the first name alphabetically among nonland permanents";
    }

    private ZzzyxassAbyssEffect(ZzzyxassAbyssEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZzzyxassAbyssEffect copy() {
        return new ZzzyxassAbyssEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ArrayList<String> permanentNames = new ArrayList<String>();
            FilterNonlandPermanent filter = new FilterNonlandPermanent();
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, controller.getId(), game)) {
                permanentNames.add(permanent.getName());
            }
            if (permanentNames.isEmpty()) {
                return true;
            }
            Collections.sort(permanentNames);
            filter.add((Predicate)new NamePredicate((String)permanentNames.get(0)));
            return new DestroyAllEffect((FilterPermanent)filter).apply(game, source);
        }
        return false;
    }
}

