/*
 * Decompiled with CFR 0.152.
 */
package mage.sets;

import java.util.ArrayList;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.keyword.PartnerWithAbility;
import mage.cards.Card;
import mage.cards.ExpansionSet;
import mage.cards.a.AimHigh;
import mage.cards.a.AngelOfRetribution;
import mage.cards.a.AngelicChorus;
import mage.cards.a.AngelicGift;
import mage.cards.a.ApocalypseHydra;
import mage.cards.a.ArcaneArtisan;
import mage.cards.a.ArchfiendOfDespair;
import mage.cards.a.ArchonOfValorsReach;
import mage.cards.a.ArenaRector;
import mage.cards.a.Assassinate;
import mage.cards.a.AssassinsStrike;
import mage.cards.a.AugerSpree;
import mage.cards.a.AuroraChampion;
import mage.cards.a.AzraBladeseeker;
import mage.cards.a.AzraOddsmaker;
import mage.cards.b.BatheInDragonfire;
import mage.cards.b.BattleMastery;
import mage.cards.b.BattleRampart;
import mage.cards.b.BattleRattleShaman;
import mage.cards.b.BeastWithin;
import mage.cards.b.BenthicGiant;
import mage.cards.b.BlaringCaptain;
import mage.cards.b.BlaringRecruiter;
import mage.cards.b.Blaze;
import mage.cards.b.BloodFeud;
import mage.cards.b.BloodbornScoundrels;
import mage.cards.b.BoldwyrIntimidator;
import mage.cards.b.BonusRound;
import mage.cards.b.BorderlandMarauder;
import mage.cards.b.BountifulPromenade;
import mage.cards.b.BrambleSovereign;
import mage.cards.b.Brightling;
import mage.cards.b.BringDown;
import mage.cards.b.BullRushBruiser;
import mage.cards.basiclands.Forest;
import mage.cards.basiclands.Island;
import mage.cards.basiclands.Mountain;
import mage.cards.basiclands.Plains;
import mage.cards.basiclands.Swamp;
import mage.cards.c.CallToHeel;
import mage.cards.c.CanopySpider;
import mage.cards.c.CentaurHealer;
import mage.cards.c.ChainLightning;
import mage.cards.c.ChakramRetriever;
import mage.cards.c.ChakramSlinger;
import mage.cards.c.ChampionOfArashin;
import mage.cards.c.ChargingBinox;
import mage.cards.c.ChargingRhino;
import mage.cards.c.CheeringFanatic;
import mage.cards.c.Claustrophobia;
import mage.cards.c.ComboAttack;
import mage.cards.c.ConsulateSkygate;
import mage.cards.c.CoralhelmGuide;
import mage.cards.c.CowlProwler;
import mage.cards.c.CullingDais;
import mage.cards.d.DaggerbackBasilisk;
import mage.cards.d.DaggerdromeImp;
import mage.cards.d.DecoratedChampion;
import mage.cards.d.DiabolicIntent;
import mage.cards.d.DinrovaHorror;
import mage.cards.d.DoomedDissenter;
import mage.cards.d.DoomedTraveler;
import mage.cards.d.DoublingSeason;
import mage.cards.d.DragonBreath;
import mage.cards.d.DragonHatchling;
import mage.cards.d.DwarvenLightsmith;
import mage.cards.e.EagerConstruct;
import mage.cards.e.EarthElemental;
import mage.cards.e.ElvishVisionary;
import mage.cards.e.EmberBeast;
import mage.cards.e.EnduringScalelord;
import mage.cards.e.EnthrallingVictor;
import mage.cards.e.EvilTwin;
import mage.cards.e.Expedite;
import mage.cards.e.ExpeditionRaptor;
import mage.cards.e.EyeblightAssassin;
import mage.cards.f.FanFavorite;
import mage.cards.f.FeralHydra;
import mage.cards.f.FertileGround;
import mage.cards.f.Fertilid;
import mage.cards.f.FillWithFright;
import mage.cards.f.FlamewaveInvoker;
import mage.cards.f.FogBank;
import mage.cards.f.FrostLynx;
import mage.cards.f.Fumble;
import mage.cards.g.GamePlan;
import mage.cards.g.GangUp;
import mage.cards.g.GenerousPatron;
import mage.cards.g.GenesisChamber;
import mage.cards.g.GiantGrowth;
import mage.cards.g.GoblinRazerunners;
import mage.cards.g.GoldForgedSentinel;
import mage.cards.g.GormTheGreat;
import mage.cards.g.GreaterGood;
import mage.cards.g.GrotesqueMutation;
import mage.cards.g.GrothamaAllDevouring;
import mage.cards.g.GwafaHazidProfiteer;
import mage.cards.h.HandOfSilumgar;
import mage.cards.h.HexplateGolem;
import mage.cards.h.HuddleUp;
import mage.cards.h.HuntedWumpus;
import mage.cards.i.ImpetuousProtege;
import mage.cards.i.Impulse;
import mage.cards.i.InnerDemon;
import mage.cards.j.JelennSphinx;
import mage.cards.j.JubilantMascot;
import mage.cards.j.Juggernaut;
import mage.cards.j.JungleWayfinder;
import mage.cards.k.KarametrasFavor;
import mage.cards.k.KhorvathBrightflame;
import mage.cards.k.KhorvathsFury;
import mage.cards.k.KissOfTheAmesha;
import mage.cards.k.KitesailCorsair;
import mage.cards.k.KorSpiritdancer;
import mage.cards.k.KrakenHatchling;
import mage.cards.k.KraulWarrior;
import mage.cards.k.KravTheUnredeemed;
import mage.cards.l.LandTax;
import mage.cards.l.LastGasp;
import mage.cards.l.LastOneStanding;
import mage.cards.l.LavaFieldOverlord;
import mage.cards.l.LeadByExample;
import mage.cards.l.LeyWeaver;
import mage.cards.l.LightningTalons;
import mage.cards.l.Lightwalker;
import mage.cards.l.LiturgyOfBlood;
import mage.cards.l.LongRoadHome;
import mage.cards.l.LoreWeaver;
import mage.cards.l.LoyalPegasus;
import mage.cards.l.LuxurySuite;
import mage.cards.m.MagmaHellion;
import mage.cards.m.MagmaticForce;
import mage.cards.m.MagusOfTheCandelabra;
import mage.cards.m.MangaraOfCorondor;
import mage.cards.m.MidnightGuard;
import mage.cards.m.MillennialGargoyle;
import mage.cards.m.MindbladeRender;
import mage.cards.m.MindsEye;
import mage.cards.m.MorbidCuriosity;
import mage.cards.m.MorphicPool;
import mage.cards.m.MycosynthLattice;
import mage.cards.m.MysticConfluence;
import mage.cards.n.NajeelaTheBladeBlossom;
import mage.cards.n.Negate;
import mage.cards.n.NightMarketGuard;
import mage.cards.n.NimbusChampion;
import mage.cards.n.NimbusOfTheIsles;
import mage.cards.n.NirkanaRevenant;
import mage.cards.n.NoosegrafMob;
import mage.cards.n.NoxiousDragon;
import mage.cards.n.Nyxathid;
import mage.cards.o.OkaunEyeOfChaos;
import mage.cards.o.Omenspeaker;
import mage.cards.o.Opportunity;
import mage.cards.o.OraclesInsight;
import mage.cards.o.OreskosExplorer;
import mage.cards.o.OutOfBounds;
import mage.cards.p.Pacifism;
import mage.cards.p.PainfulLesson;
import mage.cards.p.PathmakerInitiate;
import mage.cards.p.PeaceStrider;
import mage.cards.p.PeregrineDrake;
import mage.cards.p.PhantomWarrior;
import mage.cards.p.PierceStrider;
import mage.cards.p.PirImaginativeRascal;
import mage.cards.p.PirsWhim;
import mage.cards.p.PlatedCrusher;
import mage.cards.p.PlayOfTheGame;
import mage.cards.p.PrakhataClubSecurity;
import mage.cards.p.PrimalHuntbeast;
import mage.cards.p.ProudMentor;
import mage.cards.p.PulseOfMurasa;
import mage.cards.q.QuestForTheGravelord;
import mage.cards.r.RaptorCompanion;
import mage.cards.r.Rebuke;
import mage.cards.r.RecklessReveler;
import mage.cards.r.RecklessScholar;
import mage.cards.r.RegnaTheRedeemer;
import mage.cards.r.RegnasSanction;
import mage.cards.r.RelentlessHunter;
import mage.cards.r.ReturnToTheEarth;
import mage.cards.r.RhoxBrute;
import mage.cards.r.RiptideCrab;
import mage.cards.r.RotfeasterMaggot;
import mage.cards.r.RowanKenrith;
import mage.cards.r.RoyalTrooper;
import mage.cards.r.RushbladeCommander;
import mage.cards.repository.CardRepository;
import mage.cards.s.SaddlebackLagac;
import mage.cards.s.SaltwaterStalwart;
import mage.cards.s.SavageVentmaw;
import mage.cards.s.ScreechingBuzzard;
import mage.cards.s.SeaOfClouds;
import mage.cards.s.SeedbornMuse;
import mage.cards.s.SeersLantern;
import mage.cards.s.SentinelTower;
import mage.cards.s.ShamblingGhoul;
import mage.cards.s.Shock;
import mage.cards.s.ShoulderToShoulder;
import mage.cards.s.SickleDancer;
import mage.cards.s.SilverchaseFox;
import mage.cards.s.SkyshroudClaim;
import mage.cards.s.Skystreamer;
import mage.cards.s.SlumReaper;
import mage.cards.s.SoaringShowOff;
import mage.cards.s.SolemnOffering;
import mage.cards.s.SoulbladeCorrupter;
import mage.cards.s.SoulbladeRenewer;
import mage.cards.s.SowerOfTemptation;
import mage.cards.s.SparringMummy;
import mage.cards.s.SpectralSearchlight;
import mage.cards.s.SpellSnare;
import mage.cards.s.Spellseeker;
import mage.cards.s.SpellweaverDuo;
import mage.cards.s.SpireGarden;
import mage.cards.s.StadiumVendors;
import mage.cards.s.SteppeGlider;
import mage.cards.s.StolenStrategy;
import mage.cards.s.StoneGolem;
import mage.cards.s.StunningReversal;
import mage.cards.s.SwarmOfBloodflies;
import mage.cards.s.Switcheroo;
import mage.cards.s.SwordsToPlowshares;
import mage.cards.s.SylviaBrightspear;
import mage.cards.t.TakeUpArms;
import mage.cards.t.TandemTactics;
import mage.cards.t.TavernSwindler;
import mage.cards.t.TenaciousDead;
import mage.cards.t.TheCrowdGoesWild;
import mage.cards.t.ThrasherBrute;
import mage.cards.t.ThrillingEncore;
import mage.cards.t.ThunderStrike;
import mage.cards.t.TidespoutTyrant;
import mage.cards.t.TogetherForever;
import mage.cards.t.ToothyImaginaryFriend;
import mage.cards.t.TotallyLost;
import mage.cards.t.TrueNameNemesis;
import mage.cards.t.TrumpetBlast;
import mage.cards.t.TyrantsMachine;
import mage.cards.u.UnflinchingCourage;
import mage.cards.u.UrborgDrake;
import mage.cards.v.VampireCharmseeker;
import mage.cards.v.VeteranExplorer;
import mage.cards.v.VictoryChimes;
import mage.cards.v.Vigor;
import mage.cards.v.VirtusTheVeiled;
import mage.cards.v.VirtussManeuver;
import mage.cards.w.WanderingWolf;
import mage.cards.w.WarsToll;
import mage.cards.w.Watercourser;
import mage.cards.w.WillKenrith;
import mage.cards.w.WrapInFlames;
import mage.cards.y.YotianSoldier;
import mage.cards.z.ZndrspltEyeOfWisdom;
import mage.cards.z.ZndrspltsJudgment;
import mage.constants.Rarity;
import mage.constants.SetType;

public final class Battlebond
extends ExpansionSet {
    private static final Battlebond instance = new Battlebond();

    public static Battlebond getInstance() {
        return instance;
    }

    private Battlebond() {
        super("Battlebond", "BBD", ExpansionSet.buildDate((int)2018, (int)6, (int)8), SetType.SUPPLEMENTAL);
        this.blockName = "Battlebond";
        this.hasBasicLands = true;
        this.hasBoosters = true;
        this.numBoosterLands = 1;
        this.numBoosterCommon = 10;
        this.numBoosterUncommon = 3;
        this.numBoosterRare = 1;
        this.ratioBoosterMythic = 8.0;
        this.maxCardNumberInBooster = 254;
        this.cards.add(new ExpansionSet.SetCardInfo("Aim High", 189, Rarity.UNCOMMON, AimHigh.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Angel of Retribution", 86, Rarity.UNCOMMON, AngelOfRetribution.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Angelic Chorus", 87, Rarity.RARE, AngelicChorus.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Angelic Gift", 88, Rarity.COMMON, AngelicGift.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Apocalypse Hydra", 217, Rarity.RARE, ApocalypseHydra.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Arcane Artisan", 33, Rarity.MYTHIC, ArcaneArtisan.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Archfiend of Despair", 44, Rarity.MYTHIC, ArchfiendOfDespair.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Archon of Valor's Reach", 74, Rarity.RARE, ArchonOfValorsReach.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Arena Rector", 23, Rarity.MYTHIC, ArenaRector.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Assassin's Strike", 138, Rarity.UNCOMMON, AssassinsStrike.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Assassinate", 139, Rarity.COMMON, Assassinate.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Auger Spree", 218, Rarity.COMMON, AugerSpree.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Aurora Champion", 24, Rarity.COMMON, AuroraChampion.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Azra Bladeseeker", 55, Rarity.COMMON, AzraBladeseeker.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Azra Oddsmaker", 75, Rarity.UNCOMMON, AzraOddsmaker.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Bathe in Dragonfire", 164, Rarity.COMMON, BatheInDragonfire.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Battle Mastery", 89, Rarity.UNCOMMON, BattleMastery.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Battle Rampart", 165, Rarity.COMMON, BattleRampart.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Battle-Rattle Shaman", 166, Rarity.UNCOMMON, BattleRattleShaman.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Beast Within", 190, Rarity.UNCOMMON, BeastWithin.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Benthic Giant", 113, Rarity.COMMON, BenthicGiant.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Blaring Captain", 14, Rarity.UNCOMMON, BlaringCaptain.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Blaring Recruiter", 13, Rarity.UNCOMMON, BlaringRecruiter.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Blaze", 167, Rarity.UNCOMMON, Blaze.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Blood Feud", 168, Rarity.UNCOMMON, BloodFeud.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Bloodborn Scoundrels", 45, Rarity.COMMON, BloodbornScoundrels.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Boldwyr Intimidator", 169, Rarity.UNCOMMON, BoldwyrIntimidator.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Bonus Round", 56, Rarity.RARE, BonusRound.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Borderland Marauder", 170, Rarity.COMMON, BorderlandMarauder.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Bountiful Promenade", 81, Rarity.RARE, BountifulPromenade.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Bramble Sovereign", 65, Rarity.MYTHIC, BrambleSovereign.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Brightling", 25, Rarity.MYTHIC, Brightling.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Bring Down", 26, Rarity.UNCOMMON, BringDown.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Bull-Rush Bruiser", 57, Rarity.COMMON, BullRushBruiser.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Call to Heel", 114, Rarity.COMMON, CallToHeel.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Canopy Spider", 191, Rarity.COMMON, CanopySpider.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Centaur Healer", 219, Rarity.COMMON, CentaurHealer.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Chain Lightning", 171, Rarity.UNCOMMON, ChainLightning.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Chakram Retriever", 15, Rarity.UNCOMMON, ChakramRetriever.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Chakram Slinger", 16, Rarity.UNCOMMON, ChakramSlinger.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Champion of Arashin", 90, Rarity.COMMON, ChampionOfArashin.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Charging Binox", 66, Rarity.COMMON, ChargingBinox.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Charging Rhino", 192, Rarity.COMMON, ChargingRhino.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Cheering Fanatic", 58, Rarity.UNCOMMON, CheeringFanatic.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Claustrophobia", 115, Rarity.COMMON, Claustrophobia.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Combo Attack", 67, Rarity.COMMON, ComboAttack.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Consulate Skygate", 232, Rarity.COMMON, ConsulateSkygate.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Coralhelm Guide", 116, Rarity.COMMON, CoralhelmGuide.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Cowl Prowler", 193, Rarity.COMMON, CowlProwler.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Culling Dais", 233, Rarity.UNCOMMON, CullingDais.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Daggerback Basilisk", 194, Rarity.COMMON, DaggerbackBasilisk.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Daggerdrome Imp", 140, Rarity.COMMON, DaggerdromeImp.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Decorated Champion", 69, Rarity.UNCOMMON, DecoratedChampion.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Diabolic Intent", 141, Rarity.RARE, DiabolicIntent.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Dinrova Horror", 220, Rarity.UNCOMMON, DinrovaHorror.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Doomed Dissenter", 142, Rarity.COMMON, DoomedDissenter.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Doomed Traveler", 91, Rarity.COMMON, DoomedTraveler.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Doubling Season", 195, Rarity.MYTHIC, DoublingSeason.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Dragon Breath", 172, Rarity.UNCOMMON, DragonBreath.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Dragon Hatchling", 173, Rarity.COMMON, DragonHatchling.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Dwarven Lightsmith", 27, Rarity.COMMON, DwarvenLightsmith.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Eager Construct", 234, Rarity.COMMON, EagerConstruct.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Earth Elemental", 174, Rarity.COMMON, EarthElemental.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Elvish Visionary", 196, Rarity.COMMON, ElvishVisionary.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Ember Beast", 175, Rarity.COMMON, EmberBeast.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Enduring Scalelord", 221, Rarity.UNCOMMON, EnduringScalelord.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Enthralling Victor", 176, Rarity.UNCOMMON, EnthrallingVictor.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Evil Twin", 222, Rarity.RARE, EvilTwin.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Expedite", 177, Rarity.COMMON, Expedite.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Expedition Raptor", 92, Rarity.COMMON, ExpeditionRaptor.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Eyeblight Assassin", 143, Rarity.COMMON, EyeblightAssassin.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Fan Favorite", 46, Rarity.COMMON, FanFavorite.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Feral Hydra", 197, Rarity.UNCOMMON, FeralHydra.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Fertile Ground", 198, Rarity.COMMON, FertileGround.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Fertilid", 199, Rarity.UNCOMMON, Fertilid.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Fill with Fright", 144, Rarity.COMMON, FillWithFright.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Flamewave Invoker", 178, Rarity.UNCOMMON, FlamewaveInvoker.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Fog Bank", 117, Rarity.UNCOMMON, FogBank.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Forest", 254, Rarity.LAND, Forest.class, NON_FULL_USE_VARIOUS));
        this.cards.add(new ExpansionSet.SetCardInfo("Frost Lynx", 118, Rarity.COMMON, FrostLynx.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Fumble", 34, Rarity.UNCOMMON, Fumble.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Game Plan", 35, Rarity.RARE, GamePlan.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Gang Up", 47, Rarity.UNCOMMON, GangUp.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Generous Patron", 70, Rarity.RARE, GenerousPatron.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Genesis Chamber", 235, Rarity.UNCOMMON, GenesisChamber.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Giant Growth", 200, Rarity.COMMON, GiantGrowth.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Goblin Razerunners", 179, Rarity.RARE, GoblinRazerunners.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Gold-Forged Sentinel", 236, Rarity.UNCOMMON, GoldForgedSentinel.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Gorm the Great", 8, Rarity.RARE, GormTheGreat.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Greater Good", 201, Rarity.RARE, GreaterGood.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Grotesque Mutation", 145, Rarity.COMMON, GrotesqueMutation.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Grothama, All-Devouring", 71, Rarity.MYTHIC, GrothamaAllDevouring.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Gwafa Hazid, Profiteer", 223, Rarity.RARE, GwafaHazidProfiteer.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Hand of Silumgar", 146, Rarity.COMMON, HandOfSilumgar.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Hexplate Golem", 237, Rarity.COMMON, HexplateGolem.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Huddle Up", 36, Rarity.COMMON, HuddleUp.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Hunted Wumpus", 202, Rarity.UNCOMMON, HuntedWumpus.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Impetuous Protege", 19, Rarity.UNCOMMON, ImpetuousProtege.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Impulse", 119, Rarity.COMMON, Impulse.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Inner Demon", 48, Rarity.UNCOMMON, InnerDemon.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Island", 251, Rarity.LAND, Island.class, NON_FULL_USE_VARIOUS));
        this.cards.add(new ExpansionSet.SetCardInfo("Jelenn Sphinx", 224, Rarity.UNCOMMON, JelennSphinx.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Jubilant Mascot", 28, Rarity.UNCOMMON, JubilantMascot.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Juggernaut", 238, Rarity.UNCOMMON, Juggernaut.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Jungle Wayfinder", 72, Rarity.COMMON, JungleWayfinder.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Karametra's Favor", 203, Rarity.UNCOMMON, KarametrasFavor.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Khorvath Brightflame", 9, Rarity.RARE, KhorvathBrightflame.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Khorvath's Fury", 59, Rarity.RARE, KhorvathsFury.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Kiss of the Amesha", 225, Rarity.UNCOMMON, KissOfTheAmesha.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Kitesail Corsair", 120, Rarity.COMMON, KitesailCorsair.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Kor Spiritdancer", 93, Rarity.RARE, KorSpiritdancer.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Kraken Hatchling", 121, Rarity.COMMON, KrakenHatchling.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Kraul Warrior", 204, Rarity.COMMON, KraulWarrior.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Krav, the Unredeemed", 4, Rarity.RARE, KravTheUnredeemed.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Land Tax", 94, Rarity.MYTHIC, LandTax.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Last Gasp", 147, Rarity.COMMON, LastGasp.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Last One Standing", 76, Rarity.RARE, LastOneStanding.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Lava-Field Overlord", 60, Rarity.UNCOMMON, LavaFieldOverlord.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Lead by Example", 205, Rarity.COMMON, LeadByExample.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Ley Weaver", 21, Rarity.UNCOMMON, LeyWeaver.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Lightning Talons", 180, Rarity.COMMON, LightningTalons.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Lightwalker", 95, Rarity.COMMON, Lightwalker.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Liturgy of Blood", 148, Rarity.COMMON, LiturgyOfBlood.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Long Road Home", 96, Rarity.UNCOMMON, LongRoadHome.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Lore Weaver", 22, Rarity.UNCOMMON, LoreWeaver.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Loyal Pegasus", 97, Rarity.UNCOMMON, LoyalPegasus.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Luxury Suite", 82, Rarity.RARE, LuxurySuite.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Magma Hellion", 61, Rarity.COMMON, MagmaHellion.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Magmatic Force", 181, Rarity.RARE, MagmaticForce.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Magus of the Candelabra", 206, Rarity.RARE, MagusOfTheCandelabra.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Mangara of Corondor", 98, Rarity.RARE, MangaraOfCorondor.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Midnight Guard", 99, Rarity.COMMON, MidnightGuard.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Millennial Gargoyle", 239, Rarity.COMMON, MillennialGargoyle.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Mind's Eye", 240, Rarity.RARE, MindsEye.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Mindblade Render", 49, Rarity.RARE, MindbladeRender.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Morbid Curiosity", 149, Rarity.UNCOMMON, MorbidCuriosity.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Morphic Pool", 83, Rarity.RARE, MorphicPool.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Mountain", 253, Rarity.LAND, Mountain.class, NON_FULL_USE_VARIOUS));
        this.cards.add(new ExpansionSet.SetCardInfo("Mycosynth Lattice", 241, Rarity.MYTHIC, MycosynthLattice.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Mystic Confluence", 122, Rarity.RARE, MysticConfluence.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Najeela, the Blade-Blossom", 62, Rarity.MYTHIC, NajeelaTheBladeBlossom.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Negate", 123, Rarity.COMMON, Negate.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Night Market Guard", 242, Rarity.COMMON, NightMarketGuard.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Nimbus Champion", 37, Rarity.UNCOMMON, NimbusChampion.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Nimbus of the Isles", 124, Rarity.COMMON, NimbusOfTheIsles.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Nirkana Revenant", 150, Rarity.MYTHIC, NirkanaRevenant.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Noosegraf Mob", 151, Rarity.RARE, NoosegrafMob.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Noxious Dragon", 152, Rarity.UNCOMMON, NoxiousDragon.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Nyxathid", 153, Rarity.RARE, Nyxathid.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Okaun, Eye of Chaos", 6, Rarity.RARE, OkaunEyeOfChaos.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Omenspeaker", 125, Rarity.COMMON, Omenspeaker.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Opportunity", 126, Rarity.UNCOMMON, Opportunity.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Oracle's Insight", 127, Rarity.UNCOMMON, OraclesInsight.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Oreskos Explorer", 100, Rarity.UNCOMMON, OreskosExplorer.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Out of Bounds", 38, Rarity.UNCOMMON, OutOfBounds.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Pacifism", 101, Rarity.COMMON, Pacifism.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Painful Lesson", 154, Rarity.COMMON, PainfulLesson.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Pathmaker Initiate", 182, Rarity.COMMON, PathmakerInitiate.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Peace Strider", 243, Rarity.COMMON, PeaceStrider.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Peregrine Drake", 128, Rarity.UNCOMMON, PeregrineDrake.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Phantom Warrior", 129, Rarity.UNCOMMON, PhantomWarrior.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Pierce Strider", 244, Rarity.COMMON, PierceStrider.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Pir's Whim", 73, Rarity.RARE, PirsWhim.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Pir, Imaginative Rascal", 11, Rarity.RARE, PirImaginativeRascal.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Plains", 250, Rarity.LAND, Plains.class, NON_FULL_USE_VARIOUS));
        this.cards.add(new ExpansionSet.SetCardInfo("Plated Crusher", 207, Rarity.UNCOMMON, PlatedCrusher.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Play of the Game", 29, Rarity.RARE, PlayOfTheGame.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Prakhata Club Security", 155, Rarity.COMMON, PrakhataClubSecurity.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Primal Huntbeast", 208, Rarity.COMMON, PrimalHuntbeast.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Proud Mentor", 20, Rarity.UNCOMMON, ProudMentor.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Pulse of Murasa", 209, Rarity.UNCOMMON, PulseOfMurasa.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Quest for the Gravelord", 156, Rarity.UNCOMMON, QuestForTheGravelord.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Raptor Companion", 102, Rarity.COMMON, RaptorCompanion.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Rebuke", 103, Rarity.COMMON, Rebuke.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Reckless Reveler", 183, Rarity.COMMON, RecklessReveler.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Reckless Scholar", 130, Rarity.UNCOMMON, RecklessScholar.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Regna's Sanction", 30, Rarity.RARE, RegnasSanction.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Regna, the Redeemer", 3, Rarity.RARE, RegnaTheRedeemer.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Relentless Hunter", 226, Rarity.UNCOMMON, RelentlessHunter.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Return to the Earth", 210, Rarity.COMMON, ReturnToTheEarth.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Rhox Brute", 227, Rarity.COMMON, RhoxBrute.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Riptide Crab", 228, Rarity.COMMON, RiptideCrab.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Rotfeaster Maggot", 157, Rarity.COMMON, RotfeasterMaggot.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Rowan Kenrith", 2, Rarity.MYTHIC, RowanKenrith.class, NON_FULL_USE_VARIOUS));
        this.cards.add(new ExpansionSet.SetCardInfo("Rowan Kenrith", 256, Rarity.MYTHIC, RowanKenrith.class, NON_FULL_USE_VARIOUS));
        this.cards.add(new ExpansionSet.SetCardInfo("Royal Trooper", 104, Rarity.COMMON, RoyalTrooper.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Rushblade Commander", 77, Rarity.UNCOMMON, RushbladeCommander.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Saddleback Lagac", 211, Rarity.COMMON, SaddlebackLagac.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Saltwater Stalwart", 39, Rarity.COMMON, SaltwaterStalwart.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Savage Ventmaw", 229, Rarity.UNCOMMON, SavageVentmaw.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Screeching Buzzard", 158, Rarity.COMMON, ScreechingBuzzard.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Sea of Clouds", 84, Rarity.RARE, SeaOfClouds.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Seedborn Muse", 212, Rarity.RARE, SeedbornMuse.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Seer's Lantern", 245, Rarity.COMMON, SeersLantern.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Sentinel Tower", 79, Rarity.RARE, SentinelTower.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Shambling Ghoul", 159, Rarity.COMMON, ShamblingGhoul.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Shock", 184, Rarity.COMMON, Shock.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Shoulder to Shoulder", 105, Rarity.COMMON, ShoulderToShoulder.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Sickle Dancer", 50, Rarity.COMMON, SickleDancer.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Silverchase Fox", 106, Rarity.COMMON, SilverchaseFox.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Skyshroud Claim", 213, Rarity.COMMON, SkyshroudClaim.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Skystreamer", 31, Rarity.COMMON, Skystreamer.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Slum Reaper", 160, Rarity.UNCOMMON, SlumReaper.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Soaring Show-Off", 40, Rarity.COMMON, SoaringShowOff.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Solemn Offering", 107, Rarity.UNCOMMON, SolemnOffering.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Soulblade Corrupter", 17, Rarity.UNCOMMON, SoulbladeCorrupter.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Soulblade Renewer", 18, Rarity.UNCOMMON, SoulbladeRenewer.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Sower of Temptation", 131, Rarity.RARE, SowerOfTemptation.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Sparring Mummy", 108, Rarity.COMMON, SparringMummy.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Spectral Searchlight", 246, Rarity.UNCOMMON, SpectralSearchlight.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Spell Snare", 132, Rarity.UNCOMMON, SpellSnare.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Spellseeker", 41, Rarity.RARE, Spellseeker.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Spellweaver Duo", 42, Rarity.COMMON, SpellweaverDuo.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Spire Garden", 85, Rarity.RARE, SpireGarden.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Stadium Vendors", 63, Rarity.COMMON, StadiumVendors.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Steppe Glider", 109, Rarity.UNCOMMON, SteppeGlider.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Stolen Strategy", 64, Rarity.RARE, StolenStrategy.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Stone Golem", 247, Rarity.COMMON, StoneGolem.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Stunning Reversal", 51, Rarity.MYTHIC, StunningReversal.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Swamp", 252, Rarity.LAND, Swamp.class, NON_FULL_USE_VARIOUS));
        this.cards.add(new ExpansionSet.SetCardInfo("Swarm of Bloodflies", 161, Rarity.UNCOMMON, SwarmOfBloodflies.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Switcheroo", 133, Rarity.UNCOMMON, Switcheroo.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Swords to Plowshares", 110, Rarity.UNCOMMON, SwordsToPlowshares.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Sylvia Brightspear", 10, Rarity.RARE, SylviaBrightspear.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Take Up Arms", 111, Rarity.UNCOMMON, TakeUpArms.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Tandem Tactics", 112, Rarity.COMMON, TandemTactics.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Tavern Swindler", 162, Rarity.UNCOMMON, TavernSwindler.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Tenacious Dead", 163, Rarity.UNCOMMON, TenaciousDead.class));
        this.cards.add(new ExpansionSet.SetCardInfo("The Crowd Goes Wild", 68, Rarity.UNCOMMON, TheCrowdGoesWild.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Thrasher Brute", 52, Rarity.UNCOMMON, ThrasherBrute.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Thrilling Encore", 53, Rarity.RARE, ThrillingEncore.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Thunder Strike", 185, Rarity.COMMON, ThunderStrike.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Tidespout Tyrant", 134, Rarity.RARE, TidespoutTyrant.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Together Forever", 32, Rarity.RARE, TogetherForever.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Toothy, Imaginary Friend", 12, Rarity.RARE, ToothyImaginaryFriend.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Totally Lost", 135, Rarity.COMMON, TotallyLost.class));
        this.cards.add(new ExpansionSet.SetCardInfo("True-Name Nemesis", 136, Rarity.MYTHIC, TrueNameNemesis.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Trumpet Blast", 186, Rarity.UNCOMMON, TrumpetBlast.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Tyrant's Machine", 248, Rarity.COMMON, TyrantsMachine.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Unflinching Courage", 230, Rarity.UNCOMMON, UnflinchingCourage.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Urborg Drake", 231, Rarity.COMMON, UrborgDrake.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Vampire Charmseeker", 78, Rarity.UNCOMMON, VampireCharmseeker.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Veteran Explorer", 214, Rarity.UNCOMMON, VeteranExplorer.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Victory Chimes", 80, Rarity.RARE, VictoryChimes.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Vigor", 215, Rarity.RARE, Vigor.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Virtus the Veiled", 7, Rarity.RARE, VirtusTheVeiled.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Virtus's Maneuver", 54, Rarity.RARE, VirtussManeuver.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Wandering Wolf", 216, Rarity.COMMON, WanderingWolf.class));
        this.cards.add(new ExpansionSet.SetCardInfo("War's Toll", 187, Rarity.RARE, WarsToll.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Watercourser", 137, Rarity.COMMON, Watercourser.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Will Kenrith", 1, Rarity.MYTHIC, WillKenrith.class, NON_FULL_USE_VARIOUS));
        this.cards.add(new ExpansionSet.SetCardInfo("Will Kenrith", 255, Rarity.MYTHIC, WillKenrith.class, NON_FULL_USE_VARIOUS));
        this.cards.add(new ExpansionSet.SetCardInfo("Wrap in Flames", 188, Rarity.COMMON, WrapInFlames.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Yotian Soldier", 249, Rarity.COMMON, YotianSoldier.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Zndrsplt's Judgment", 43, Rarity.RARE, ZndrspltsJudgment.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Zndrsplt, Eye of Wisdom", 5, Rarity.RARE, ZndrspltEyeOfWisdom.class));
    }

    public List<Card> tryBooster() {
        ArrayList<Card> booster = new ArrayList<Card>();
        boolean partnerAllowed = true;
        List uncommons = this.getCardsByRarity(Rarity.UNCOMMON);
        block0: for (int i = 0; i < this.numBoosterUncommon; ++i) {
            int check;
            do {
                this.addToBooster(booster, uncommons);
                check = this.addMissingPartner(booster, partnerAllowed, this.numBoosterUncommon - 1, i);
                if (check == 1) continue block0;
            } while (check != 2);
            partnerAllowed = false;
            if (i == this.numBoosterUncommon - 1) continue;
            ++i;
        }
        List commons = this.getCardsByRarity(Rarity.COMMON);
        for (int i = 0; i < this.numBoosterCommon; ++i) {
            this.addToBooster(booster, commons);
        }
        List rares = this.getCardsByRarity(Rarity.RARE);
        List mythics = this.getCardsByRarity(Rarity.MYTHIC);
        block3: for (int i = 0; i < this.numBoosterRare; ++i) {
            int check;
            List cards = this.checkMythic() ? mythics : rares;
            do {
                this.addToBooster(booster, cards);
                check = this.addMissingPartner(booster, partnerAllowed, -1, 1);
                if (check == 1) continue block3;
            } while (check != 2);
            partnerAllowed = false;
        }
        List basicLands = this.getCardsByRarity(Rarity.LAND);
        for (int i = 0; i < this.numBoosterLands; ++i) {
            this.addToBooster(booster, basicLands);
        }
        return booster;
    }

    private int addMissingPartner(List<Card> booster, boolean partnerAllowed, int max, int i) {
        Card sourceCard = booster.get(booster.size() - 1);
        for (Ability ability : sourceCard.getAbilities()) {
            if (!(ability instanceof PartnerWithAbility)) continue;
            String partnerName = ((PartnerWithAbility)ability).getPartnerName();
            if (partnerAllowed) {
                Card card = CardRepository.instance.findCardWithPreferredSetAndNumber(partnerName, sourceCard.getExpansionSetCode(), null).createCard();
                if (i < max) {
                    booster.add(card);
                } else {
                    booster.set(0, card);
                }
                return 2;
            }
            booster.remove(booster.size() - 1);
            return 0;
        }
        return 1;
    }
}

