/*
 * Decompiled with CFR 0.152.
 */
package mage.sets;

import java.util.List;
import mage.cards.Card;
import mage.cards.ExpansionSet;
import mage.cards.a.AdventOfTheWurm;
import mage.cards.a.Aetherling;
import mage.cards.a.AliveWell;
import mage.cards.a.ArmedDangerous;
import mage.cards.a.ArmoredWolfRider;
import mage.cards.a.AscendedLawmage;
import mage.cards.a.AweForTheGuilds;
import mage.cards.a.AzoriusCluestone;
import mage.cards.a.AzoriusGuildgate;
import mage.cards.b.BaneAlleyBlackguard;
import mage.cards.b.BatteringKrasis;
import mage.cards.b.BeckCall;
import mage.cards.b.BeetleformMage;
import mage.cards.b.BlastOfGenius;
import mage.cards.b.BlazeCommando;
import mage.cards.b.BloodBaronOfVizkopa;
import mage.cards.b.BloodScrivener;
import mage.cards.b.BorosBattleshaper;
import mage.cards.b.BorosCluestone;
import mage.cards.b.BorosGuildgate;
import mage.cards.b.BorosMastiff;
import mage.cards.b.BreakingEntering;
import mage.cards.b.BredForTheHunt;
import mage.cards.b.BronzebeakMoa;
import mage.cards.c.CarnageGladiator;
import mage.cards.c.CatchRelease;
import mage.cards.c.ClearAPath;
import mage.cards.c.CouncilOfTheAbsolute;
import mage.cards.c.CryptIncursion;
import mage.cards.d.DeadbridgeChant;
import mage.cards.d.DebtToTheDeathless;
import mage.cards.d.DeputyOfAcquittals;
import mage.cards.d.DimirCluestone;
import mage.cards.d.DimirGuildgate;
import mage.cards.d.DownDirty;
import mage.cards.d.Dragonshift;
import mage.cards.d.DrownInFilth;
import mage.cards.e.EmmaraTandris;
import mage.cards.e.ExavaRakdosBloodWitch;
import mage.cards.f.FarAway;
import mage.cards.f.FatalFumes;
import mage.cards.f.FeralAnimist;
import mage.cards.f.FleshBlood;
import mage.cards.f.Fluxcharger;
import mage.cards.g.GazeOfGranite;
import mage.cards.g.GiveTake;
import mage.cards.g.GleamOfBattle;
import mage.cards.g.GoblinTestPilot;
import mage.cards.g.GolgariCluestone;
import mage.cards.g.GolgariGuildgate;
import mage.cards.g.GruulCluestone;
import mage.cards.g.GruulGuildgate;
import mage.cards.g.GruulWarChant;
import mage.cards.h.HaazdaSnareSquad;
import mage.cards.h.HaunterOfNightveil;
import mage.cards.h.HiddenStrings;
import mage.cards.h.HiredTorturer;
import mage.cards.i.IzzetCluestone;
import mage.cards.i.IzzetGuildgate;
import mage.cards.j.JelennSphinx;
import mage.cards.k.KorozdaGorgon;
import mage.cards.k.KrasisIncubation;
import mage.cards.k.KraulWarrior;
import mage.cards.l.LaviniaOfTheTenth;
import mage.cards.l.LegionsInitiative;
import mage.cards.l.LyevDecree;
import mage.cards.m.MasterOfCruelties;
import mage.cards.m.MawOfTheObzedat;
import mage.cards.m.MazeAbomination;
import mage.cards.m.MazeBehemoth;
import mage.cards.m.MazeGlider;
import mage.cards.m.MazeRusher;
import mage.cards.m.MazeSentinel;
import mage.cards.m.MazesEnd;
import mage.cards.m.MelekIzzetParagon;
import mage.cards.m.MendingTouch;
import mage.cards.m.Mindstatic;
import mage.cards.m.MirkoVoskMindDrinker;
import mage.cards.m.MorgueBurst;
import mage.cards.m.MurmuringPhantasm;
import mage.cards.m.MutantsPrey;
import mage.cards.n.NivixCyclops;
import mage.cards.n.NotionThief;
import mage.cards.o.ObzedatsAid;
import mage.cards.o.OpalLakeGatekeepers;
import mage.cards.o.OrzhovCluestone;
import mage.cards.o.OrzhovGuildgate;
import mage.cards.p.Phytoburst;
import mage.cards.p.PilferedPlans;
import mage.cards.p.PlasmCapture;
import mage.cards.p.PontiffOfBlight;
import mage.cards.p.PossibilityStorm;
import mage.cards.p.ProfitLoss;
import mage.cards.p.ProgenitorMimic;
import mage.cards.p.ProtectServe;
import mage.cards.p.PunishTheEnemy;
import mage.cards.p.Putrefy;
import mage.cards.p.PyrewildShaman;
import mage.cards.r.RakdosCluestone;
import mage.cards.r.RakdosDrake;
import mage.cards.r.RakdosGuildgate;
import mage.cards.r.RalZarek;
import mage.cards.r.ReadyWilling;
import mage.cards.r.ReapIntellect;
import mage.cards.r.RenderSilent;
import mage.cards.r.RenegadeKrasis;
import mage.cards.r.RenounceTheGuilds;
import mage.cards.r.RestoreThePeace;
import mage.cards.r.RiotControl;
import mage.cards.r.RiotPiker;
import mage.cards.r.RotFarmSkeleton;
import mage.cards.r.RubblebeltMaaka;
import mage.cards.r.RunnersBane;
import mage.cards.r.RuricTharTheUnbowed;
import mage.cards.repository.CardCriteria;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.cards.s.SaruliGatekeepers;
import mage.cards.s.SavagebornHydra;
import mage.cards.s.ScabClanGiant;
import mage.cards.s.ScionOfVituGhazi;
import mage.cards.s.SelesnyaCluestone;
import mage.cards.s.SelesnyaGuildgate;
import mage.cards.s.Showstopper;
import mage.cards.s.SimicCluestone;
import mage.cards.s.SimicGuildgate;
import mage.cards.s.SinCollector;
import mage.cards.s.SinisterPossession;
import mage.cards.s.SireOfInsanity;
import mage.cards.s.Skylasher;
import mage.cards.s.SmeltWardGatekeepers;
import mage.cards.s.SpeciesGorger;
import mage.cards.s.SpikeJester;
import mage.cards.s.SteepleRoc;
import mage.cards.s.SunspireGatekeepers;
import mage.cards.t.TajicBladeOfTheLegion;
import mage.cards.t.TeysaEnvoyOfGhosts;
import mage.cards.t.ThrashingMossdog;
import mage.cards.t.TitheDrinker;
import mage.cards.t.ToilTrouble;
import mage.cards.t.TrostanisSummoner;
import mage.cards.t.TurnBurn;
import mage.cards.u.UbulSarGatekeepers;
import mage.cards.u.UncoveredClues;
import mage.cards.u.UnflinchingCourage;
import mage.cards.v.VarolzTheScarStriped;
import mage.cards.v.ViashinoFirstblade;
import mage.cards.v.VoiceOfResurgence;
import mage.cards.v.VorelOfTheHullClade;
import mage.cards.w.WakeTheReflections;
import mage.cards.w.WarleadersHelix;
import mage.cards.w.WarpedPhysique;
import mage.cards.w.WeaponSurge;
import mage.cards.w.WearTear;
import mage.cards.w.WindDrake;
import mage.cards.w.WoodlotCrawler;
import mage.cards.z.ZhurTaaAncient;
import mage.cards.z.ZhurTaaDruid;
import mage.collation.BoosterCollator;
import mage.constants.CardType;
import mage.constants.Rarity;
import mage.constants.SetType;
import mage.sets.DragonsMazeCollator;
import mage.sets.ReturnToRavnica;
import mage.util.RandomUtil;

public final class DragonsMaze
extends ExpansionSet {
    private static final DragonsMaze instance = new DragonsMaze();

    public static DragonsMaze getInstance() {
        return instance;
    }

    private DragonsMaze() {
        super("Dragon's Maze", "DGM", ExpansionSet.buildDate((int)2013, (int)5, (int)3), SetType.EXPANSION);
        this.blockName = "Return to Ravnica";
        this.hasBoosters = true;
        this.numBoosterSpecial = 1;
        this.numBoosterLands = 0;
        this.numBoosterCommon = 10;
        this.numBoosterUncommon = 3;
        this.numBoosterRare = 1;
        this.ratioBoosterMythic = 8.0;
        this.parentSet = ReturnToRavnica.getInstance();
        this.hasBasicLands = false;
        this.cards.add(new ExpansionSet.SetCardInfo("Advent of the Wurm", 51, Rarity.RARE, AdventOfTheWurm.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Aetherling", 11, Rarity.RARE, Aetherling.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Alive // Well", 121, Rarity.UNCOMMON, AliveWell.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Armed // Dangerous", 122, Rarity.UNCOMMON, ArmedDangerous.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Armored Wolf-Rider", 52, Rarity.COMMON, ArmoredWolfRider.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Ascended Lawmage", 53, Rarity.UNCOMMON, AscendedLawmage.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Awe for the Guilds", 31, Rarity.COMMON, AweForTheGuilds.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Azorius Cluestone", 136, Rarity.COMMON, AzoriusCluestone.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Azorius Guildgate", 146, Rarity.COMMON, AzoriusGuildgate.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Bane Alley Blackguard", 21, Rarity.COMMON, BaneAlleyBlackguard.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Battering Krasis", 41, Rarity.COMMON, BatteringKrasis.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Beck // Call", 123, Rarity.RARE, BeckCall.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Beetleform Mage", 54, Rarity.COMMON, BeetleformMage.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Blast of Genius", 55, Rarity.UNCOMMON, BlastOfGenius.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Blaze Commando", 56, Rarity.UNCOMMON, BlazeCommando.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Blood Baron of Vizkopa", 57, Rarity.MYTHIC, BloodBaronOfVizkopa.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Blood Scrivener", 22, Rarity.RARE, BloodScrivener.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Boros Battleshaper", 58, Rarity.RARE, BorosBattleshaper.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Boros Cluestone", 137, Rarity.COMMON, BorosCluestone.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Boros Guildgate", 147, Rarity.COMMON, BorosGuildgate.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Boros Mastiff", 1, Rarity.COMMON, BorosMastiff.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Breaking // Entering", 124, Rarity.RARE, BreakingEntering.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Bred for the Hunt", 59, Rarity.UNCOMMON, BredForTheHunt.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Bronzebeak Moa", 60, Rarity.UNCOMMON, BronzebeakMoa.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Carnage Gladiator", 61, Rarity.UNCOMMON, CarnageGladiator.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Catch // Release", 125, Rarity.RARE, CatchRelease.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Clear a Path", 32, Rarity.COMMON, ClearAPath.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Council of the Absolute", 62, Rarity.MYTHIC, CouncilOfTheAbsolute.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Crypt Incursion", 23, Rarity.COMMON, CryptIncursion.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Deadbridge Chant", 63, Rarity.MYTHIC, DeadbridgeChant.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Debt to the Deathless", 64, Rarity.UNCOMMON, DebtToTheDeathless.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Deputy of Acquittals", 65, Rarity.COMMON, DeputyOfAcquittals.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Dimir Cluestone", 138, Rarity.COMMON, DimirCluestone.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Dimir Guildgate", 148, Rarity.COMMON, DimirGuildgate.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Down // Dirty", 126, Rarity.UNCOMMON, DownDirty.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Dragonshift", 66, Rarity.RARE, Dragonshift.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Drown in Filth", 67, Rarity.COMMON, DrownInFilth.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Emmara Tandris", 68, Rarity.RARE, EmmaraTandris.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Exava, Rakdos Blood Witch", 69, Rarity.RARE, ExavaRakdosBloodWitch.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Far // Away", 127, Rarity.UNCOMMON, FarAway.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Fatal Fumes", 24, Rarity.COMMON, FatalFumes.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Feral Animist", 70, Rarity.UNCOMMON, FeralAnimist.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Flesh // Blood", 128, Rarity.RARE, FleshBlood.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Fluxcharger", 71, Rarity.UNCOMMON, Fluxcharger.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Gaze of Granite", 72, Rarity.RARE, GazeOfGranite.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Give // Take", 129, Rarity.UNCOMMON, GiveTake.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Gleam of Battle", 73, Rarity.UNCOMMON, GleamOfBattle.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Goblin Test Pilot", 74, Rarity.UNCOMMON, GoblinTestPilot.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Golgari Cluestone", 139, Rarity.COMMON, GolgariCluestone.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Golgari Guildgate", 149, Rarity.COMMON, GolgariGuildgate.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Gruul Cluestone", 140, Rarity.COMMON, GruulCluestone.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Gruul Guildgate", 150, Rarity.COMMON, GruulGuildgate.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Gruul War Chant", 75, Rarity.UNCOMMON, GruulWarChant.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Haazda Snare Squad", 2, Rarity.COMMON, HaazdaSnareSquad.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Haunter of Nightveil", 76, Rarity.UNCOMMON, HaunterOfNightveil.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Hidden Strings", 12, Rarity.COMMON, HiddenStrings.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Hired Torturer", 25, Rarity.COMMON, HiredTorturer.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Izzet Cluestone", 141, Rarity.COMMON, IzzetCluestone.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Izzet Guildgate", 151, Rarity.COMMON, IzzetGuildgate.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Jelenn Sphinx", 77, Rarity.UNCOMMON, JelennSphinx.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Korozda Gorgon", 78, Rarity.UNCOMMON, KorozdaGorgon.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Krasis Incubation", 79, Rarity.UNCOMMON, KrasisIncubation.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Kraul Warrior", 42, Rarity.COMMON, KraulWarrior.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Lavinia of the Tenth", 80, Rarity.RARE, LaviniaOfTheTenth.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Legion's Initiative", 81, Rarity.MYTHIC, LegionsInitiative.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Lyev Decree", 3, Rarity.COMMON, LyevDecree.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Master of Cruelties", 82, Rarity.MYTHIC, MasterOfCruelties.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Maw of the Obzedat", 83, Rarity.UNCOMMON, MawOfTheObzedat.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Maze Abomination", 26, Rarity.COMMON, MazeAbomination.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Maze Behemoth", 43, Rarity.COMMON, MazeBehemoth.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Maze Glider", 13, Rarity.COMMON, MazeGlider.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Maze Rusher", 33, Rarity.COMMON, MazeRusher.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Maze's End", 152, Rarity.MYTHIC, MazesEnd.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Maze Sentinel", 4, Rarity.COMMON, MazeSentinel.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Melek, Izzet Paragon", 84, Rarity.RARE, MelekIzzetParagon.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Mending Touch", 44, Rarity.COMMON, MendingTouch.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Mindstatic", 14, Rarity.COMMON, Mindstatic.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Mirko Vosk, Mind Drinker", 85, Rarity.RARE, MirkoVoskMindDrinker.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Morgue Burst", 86, Rarity.COMMON, MorgueBurst.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Murmuring Phantasm", 15, Rarity.COMMON, MurmuringPhantasm.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Mutant's Prey", 45, Rarity.COMMON, MutantsPrey.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Nivix Cyclops", 87, Rarity.COMMON, NivixCyclops.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Notion Thief", 88, Rarity.RARE, NotionThief.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Obzedat's Aid", 89, Rarity.RARE, ObzedatsAid.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Opal Lake Gatekeepers", 16, Rarity.COMMON, OpalLakeGatekeepers.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Orzhov Cluestone", 142, Rarity.COMMON, OrzhovCluestone.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Orzhov Guildgate", 153, Rarity.COMMON, OrzhovGuildgate.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Phytoburst", 46, Rarity.COMMON, Phytoburst.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Pilfered Plans", 90, Rarity.COMMON, PilferedPlans.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Plasm Capture", 91, Rarity.RARE, PlasmCapture.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Pontiff of Blight", 27, Rarity.RARE, PontiffOfBlight.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Possibility Storm", 34, Rarity.RARE, PossibilityStorm.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Profit // Loss", 130, Rarity.UNCOMMON, ProfitLoss.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Progenitor Mimic", 92, Rarity.MYTHIC, ProgenitorMimic.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Protect // Serve", 131, Rarity.UNCOMMON, ProtectServe.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Punish the Enemy", 35, Rarity.COMMON, PunishTheEnemy.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Putrefy", 93, Rarity.UNCOMMON, Putrefy.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Pyrewild Shaman", 36, Rarity.RARE, PyrewildShaman.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Rakdos Cluestone", 143, Rarity.COMMON, RakdosCluestone.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Rakdos Drake", 28, Rarity.COMMON, RakdosDrake.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Rakdos Guildgate", 154, Rarity.COMMON, RakdosGuildgate.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Ral Zarek", 94, Rarity.MYTHIC, RalZarek.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Ready // Willing", 132, Rarity.RARE, ReadyWilling.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Reap Intellect", 95, Rarity.MYTHIC, ReapIntellect.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Render Silent", 96, Rarity.RARE, RenderSilent.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Renegade Krasis", 47, Rarity.RARE, RenegadeKrasis.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Renounce the Guilds", 5, Rarity.RARE, RenounceTheGuilds.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Restore the Peace", 97, Rarity.UNCOMMON, RestoreThePeace.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Riot Control", 6, Rarity.COMMON, RiotControl.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Riot Piker", 37, Rarity.COMMON, RiotPiker.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Rot Farm Skeleton", 98, Rarity.UNCOMMON, RotFarmSkeleton.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Rubblebelt Maaka", 38, Rarity.COMMON, RubblebeltMaaka.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Runner's Bane", 17, Rarity.COMMON, RunnersBane.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Ruric Thar, the Unbowed", 99, Rarity.RARE, RuricTharTheUnbowed.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Saruli Gatekeepers", 48, Rarity.COMMON, SaruliGatekeepers.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Savageborn Hydra", 100, Rarity.MYTHIC, SavagebornHydra.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Scab-Clan Giant", 101, Rarity.UNCOMMON, ScabClanGiant.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Scion of Vitu-Ghazi", 7, Rarity.RARE, ScionOfVituGhazi.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Selesnya Cluestone", 144, Rarity.COMMON, SelesnyaCluestone.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Selesnya Guildgate", 155, Rarity.COMMON, SelesnyaGuildgate.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Showstopper", 102, Rarity.UNCOMMON, Showstopper.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Simic Cluestone", 145, Rarity.COMMON, SimicCluestone.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Simic Guildgate", 156, Rarity.COMMON, SimicGuildgate.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Sin Collector", 103, Rarity.UNCOMMON, SinCollector.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Sinister Possession", 29, Rarity.COMMON, SinisterPossession.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Sire of Insanity", 104, Rarity.RARE, SireOfInsanity.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Skylasher", 49, Rarity.RARE, Skylasher.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Smelt-Ward Gatekeepers", 39, Rarity.COMMON, SmeltWardGatekeepers.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Species Gorger", 105, Rarity.UNCOMMON, SpeciesGorger.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Spike Jester", 106, Rarity.UNCOMMON, SpikeJester.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Steeple Roc", 8, Rarity.COMMON, SteepleRoc.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Sunspire Gatekeepers", 9, Rarity.COMMON, SunspireGatekeepers.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Tajic, Blade of the Legion", 107, Rarity.RARE, TajicBladeOfTheLegion.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Teysa, Envoy of Ghosts", 108, Rarity.RARE, TeysaEnvoyOfGhosts.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Thrashing Mossdog", 50, Rarity.COMMON, ThrashingMossdog.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Tithe Drinker", 109, Rarity.COMMON, TitheDrinker.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Toil // Trouble", 133, Rarity.UNCOMMON, ToilTrouble.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Trostani's Summoner", 110, Rarity.UNCOMMON, TrostanisSummoner.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Turn // Burn", 134, Rarity.UNCOMMON, TurnBurn.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Ubul Sar Gatekeepers", 30, Rarity.COMMON, UbulSarGatekeepers.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Uncovered Clues", 19, Rarity.COMMON, UncoveredClues.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Unflinching Courage", 111, Rarity.UNCOMMON, UnflinchingCourage.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Varolz, the Scar-Striped", 112, Rarity.RARE, VarolzTheScarStriped.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Viashino Firstblade", 113, Rarity.COMMON, ViashinoFirstblade.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Voice of Resurgence", 114, Rarity.MYTHIC, VoiceOfResurgence.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Vorel of the Hull Clade", 115, Rarity.RARE, VorelOfTheHullClade.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Wake the Reflections", 10, Rarity.COMMON, WakeTheReflections.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Warleader's Helix", 116, Rarity.UNCOMMON, WarleadersHelix.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Warped Physique", 117, Rarity.UNCOMMON, WarpedPhysique.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Weapon Surge", 40, Rarity.COMMON, WeaponSurge.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Wear // Tear", 135, Rarity.UNCOMMON, WearTear.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Wind Drake", 20, Rarity.COMMON, WindDrake.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Woodlot Crawler", 118, Rarity.UNCOMMON, WoodlotCrawler.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Zhur-Taa Ancient", 119, Rarity.RARE, ZhurTaaAncient.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Zhur-Taa Druid", 120, Rarity.COMMON, ZhurTaaDruid.class));
    }

    protected void addSpecialCards(List<Card> booster, int number) {
        int rarityKey = RandomUtil.nextInt((int)242);
        Rarity rarity = rarityKey < 230 ? Rarity.COMMON : (rarityKey < 240 ? Rarity.RARE : Rarity.MYTHIC);
        this.addToBooster(booster, this.getSpecialCardsByRarity(rarity));
    }

    protected List<CardInfo> findSpecialCardsByRarity(Rarity rarity) {
        CardCriteria criteria = new CardCriteria();
        criteria.rarities(new Rarity[]{rarity}).types(new CardType[]{CardType.LAND});
        if (rarity == Rarity.RARE) {
            criteria.setCodes(new String[]{"RTR", "GTC"});
        } else {
            criteria.setCodes(new String[]{this.code});
        }
        List cardInfos = CardRepository.instance.findCards(criteria);
        cardInfos.removeIf(cardInfo -> cardInfo.getName().equals("Grove of the Guardian") || cardInfo.getName().equals("Thespian's Stage"));
        return cardInfos;
    }

    protected void generateBoosterMap() {
        super.generateBoosterMap();
        CardRepository.instance.findCards(new CardCriteria().setCodes(new String[]{"RTR", "GTC"}).rarities(new Rarity[]{Rarity.RARE}).types(new CardType[]{CardType.LAND})).stream().forEach(cardInfo -> this.inBoosterMap.put(cardInfo.getSetCode() + "_" + cardInfo.getCardNumber(), cardInfo));
    }

    public BoosterCollator createCollator() {
        return new DragonsMazeCollator();
    }
}

