/*
 * Decompiled with CFR 0.152.
 */
package mage.player.ai;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.Mode;
import mage.abilities.Modes;
import mage.abilities.SpellAbility;
import mage.abilities.TriggeredAbility;
import mage.abilities.costs.mana.ManaCost;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.decks.Deck;
import mage.choices.Choice;
import mage.constants.ManaType;
import mage.constants.MultiAmountType;
import mage.constants.Outcome;
import mage.constants.RangeOfInfluence;
import mage.game.Game;
import mage.game.draft.Draft;
import mage.game.match.Match;
import mage.game.tournament.Tournament;
import mage.player.ai.ComputerPlayer7;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetAmount;
import mage.target.TargetCard;
import mage.util.MultiAmountMessage;
import org.apache.log4j.Logger;

public class ComputerPlayerControllableProxy
extends ComputerPlayer7 {
    private static final Logger logger = Logger.getLogger(ComputerPlayerControllableProxy.class);
    Player lastControllingPlayer = null;

    public ComputerPlayerControllableProxy(String name, RangeOfInfluence range, int skill) {
        super(name, range, skill);
    }

    public ComputerPlayerControllableProxy(ComputerPlayerControllableProxy player) {
        super(player);
        this.lastControllingPlayer = player;
    }

    @Override
    public ComputerPlayerControllableProxy copy() {
        return new ComputerPlayerControllableProxy(this);
    }

    private boolean isUnderMe(Game game) {
        return game.isSimulation() || this.isGameUnderControl();
    }

    private Player getControllingPlayer(Game game) {
        Player player = game.getPlayer(this.getTurnControlledBy());
        this.lastControllingPlayer = player.prepareControllableProxy((Player)this);
        return this.lastControllingPlayer;
    }

    public void setResponseString(String responseString) {
        if (this.lastControllingPlayer != null) {
            this.lastControllingPlayer.setResponseString(responseString);
        }
    }

    public void setResponseManaType(UUID manaTypePlayerId, ManaType responseManaType) {
        if (this.lastControllingPlayer != null) {
            this.lastControllingPlayer.setResponseManaType(manaTypePlayerId, responseManaType);
        }
    }

    public void setResponseUUID(UUID responseUUID) {
        if (this.lastControllingPlayer != null) {
            this.lastControllingPlayer.setResponseUUID(responseUUID);
        }
    }

    public void setResponseBoolean(Boolean responseBoolean) {
        if (this.lastControllingPlayer != null) {
            this.lastControllingPlayer.setResponseBoolean(responseBoolean);
        }
    }

    public void setResponseInteger(Integer responseInteger) {
        if (this.lastControllingPlayer != null) {
            this.lastControllingPlayer.setResponseInteger(responseInteger);
        }
    }

    public void signalPlayerCheat() {
        if (this.lastControllingPlayer != null) {
            this.lastControllingPlayer.signalPlayerCheat();
        }
    }

    public void signalPlayerConcede(boolean stopCurrentChooseDialog) {
        if (this.lastControllingPlayer != null) {
            this.lastControllingPlayer.signalPlayerConcede(stopCurrentChooseDialog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean priority(Game game) {
        if (this.isUnderMe(game)) {
            return super.priority(game);
        }
        Player player = this.getControllingPlayer(game);
        try {
            boolean bl = player.priority(game);
            return bl;
        }
        finally {
            this.passed = player.isPassed();
        }
    }

    public boolean chooseMulligan(Game game) {
        if (this.isUnderMe(game)) {
            return super.chooseMulligan(game);
        }
        return this.getControllingPlayer(game).chooseMulligan(game);
    }

    public boolean chooseUse(Outcome outcome, String message, Ability source, Game game) {
        if (this.isUnderMe(game)) {
            return super.chooseUse(outcome, message, source, game);
        }
        return this.getControllingPlayer(game).chooseUse(outcome, message, source, game);
    }

    public boolean chooseUse(Outcome outcome, String message, String secondMessage, String trueText, String falseText, Ability source, Game game) {
        if (this.isUnderMe(game)) {
            return super.chooseUse(outcome, message, secondMessage, trueText, falseText, source, game);
        }
        return this.getControllingPlayer(game).chooseUse(outcome, message, secondMessage, trueText, falseText, source, game);
    }

    public int chooseReplacementEffect(Map<String, String> effectsMap, Map<String, MageObject> objectsMap, Game game) {
        if (this.isUnderMe(game)) {
            return super.chooseReplacementEffect(effectsMap, objectsMap, game);
        }
        return this.getControllingPlayer(game).chooseReplacementEffect(effectsMap, objectsMap, game);
    }

    @Override
    public boolean choose(Outcome outcome, Choice choice, Game game) {
        if (this.isUnderMe(game)) {
            return super.choose(outcome, choice, game);
        }
        return this.getControllingPlayer(game).choose(outcome, choice, game);
    }

    public boolean choose(Outcome outcome, Target target, Ability source, Game game) {
        if (this.isUnderMe(game)) {
            return super.choose(outcome, target, source, game);
        }
        return this.getControllingPlayer(game).choose(outcome, target, source, game);
    }

    public boolean choose(Outcome outcome, Target target, Ability source, Game game, Map<String, Serializable> options) {
        if (this.isUnderMe(game)) {
            return super.choose(outcome, target, source, game, options);
        }
        return this.getControllingPlayer(game).choose(outcome, target, source, game, options);
    }

    public boolean chooseTarget(Outcome outcome, Target target, Ability source, Game game) {
        if (this.isUnderMe(game)) {
            return super.chooseTarget(outcome, target, source, game);
        }
        return this.getControllingPlayer(game).chooseTarget(outcome, target, source, game);
    }

    @Override
    public boolean choose(Outcome outcome, Cards cards, TargetCard target, Ability source, Game game) {
        if (this.isUnderMe(game)) {
            return super.choose(outcome, cards, target, source, game);
        }
        return this.getControllingPlayer(game).choose(outcome, cards, target, source, game);
    }

    @Override
    public boolean chooseTarget(Outcome outcome, Cards cards, TargetCard target, Ability source, Game game) {
        if (this.isUnderMe(game)) {
            return super.chooseTarget(outcome, cards, target, source, game);
        }
        return this.getControllingPlayer(game).chooseTarget(outcome, cards, target, source, game);
    }

    public boolean chooseTargetAmount(Outcome outcome, TargetAmount target, Ability source, Game game) {
        if (this.isUnderMe(game)) {
            return super.chooseTargetAmount(outcome, target, source, game);
        }
        return this.getControllingPlayer(game).chooseTargetAmount(outcome, target, source, game);
    }

    public TriggeredAbility chooseTriggeredAbility(List<TriggeredAbility> abilities, Game game) {
        if (this.isUnderMe(game)) {
            return super.chooseTriggeredAbility(abilities, game);
        }
        return this.getControllingPlayer(game).chooseTriggeredAbility(abilities, game);
    }

    public boolean playMana(Ability abilityToCast, ManaCost unpaid, String promptText, Game game) {
        if (this.isUnderMe(game)) {
            return super.playMana(abilityToCast, unpaid, promptText, game);
        }
        return this.getControllingPlayer(game).playMana(abilityToCast, unpaid, promptText, game);
    }

    public int announceX(int min, int max, String message, Game game, Ability source, boolean isManaPay) {
        if (this.isUnderMe(game)) {
            return super.announceX(min, max, message, game, source, isManaPay);
        }
        return this.getControllingPlayer(game).announceX(min, max, message, game, source, isManaPay);
    }

    @Override
    public void selectAttackers(Game game, UUID attackingPlayerId) {
        if (this.isUnderMe(game)) {
            super.selectAttackers(game, attackingPlayerId);
        } else {
            this.getControllingPlayer(game).selectAttackers(game, attackingPlayerId);
        }
    }

    @Override
    public void selectBlockers(Ability source, Game game, UUID defendingPlayerId) {
        if (this.isUnderMe(game)) {
            super.selectBlockers(source, game, defendingPlayerId);
        } else {
            this.getControllingPlayer(game).selectBlockers(source, game, defendingPlayerId);
        }
    }

    public int getAmount(int min, int max, String message, Ability source, Game game) {
        if (this.isUnderMe(game)) {
            return super.getAmount(min, max, message, source, game);
        }
        return this.getControllingPlayer(game).getAmount(min, max, message, source, game);
    }

    public List<Integer> getMultiAmountWithIndividualConstraints(Outcome outcome, List<MultiAmountMessage> messages, int totalMin, int totalMax, MultiAmountType type, Game game) {
        if (this.isUnderMe(game)) {
            return super.getMultiAmountWithIndividualConstraints(outcome, messages, totalMin, totalMax, type, game);
        }
        return this.getControllingPlayer(game).getMultiAmountWithIndividualConstraints(outcome, messages, totalMin, totalMax, type, game);
    }

    public void sideboard(Match match, Deck deck) {
        super.sideboard(match, deck);
    }

    public void construct(Tournament tournament, Deck deck) {
        super.construct(tournament, deck);
    }

    public void pickCard(List<Card> cards, Deck deck, Draft draft) {
        super.pickCard(cards, deck, draft);
    }

    public boolean activateAbility(ActivatedAbility ability, Game game) {
        return super.activateAbility(ability, game);
    }

    public SpellAbility chooseAbilityForCast(Card card, Game game, boolean noMana) {
        if (this.isUnderMe(game)) {
            return super.chooseAbilityForCast(card, game, noMana);
        }
        return this.getControllingPlayer(game).chooseAbilityForCast(card, game, noMana);
    }

    public ActivatedAbility chooseLandOrSpellAbility(Card card, Game game, boolean noMana) {
        if (this.isUnderMe(game)) {
            return super.chooseLandOrSpellAbility(card, game, noMana);
        }
        return this.getControllingPlayer(game).chooseLandOrSpellAbility(card, game, noMana);
    }

    public Mode chooseMode(Modes modes, Ability source, Game game) {
        if (this.isUnderMe(game)) {
            return super.chooseMode(modes, source, game);
        }
        return this.getControllingPlayer(game).chooseMode(modes, source, game);
    }

    public boolean choosePile(Outcome outcome, String message, List<? extends Card> pile1, List<? extends Card> pile2, Game game) {
        if (this.isUnderMe(game)) {
            return super.choosePile(outcome, message, pile1, pile2, game);
        }
        return this.getControllingPlayer(game).choosePile(outcome, message, pile1, pile2, game);
    }

    public void abort() {
        super.abort();
    }

    public void skip() {
        super.skip();
    }
}

