/*
 * Decompiled with CFR 0.152.
 */
package mage.player.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.TriggeredAbility;
import mage.abilities.common.PassAbility;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.costs.mana.VariableManaCost;
import mage.abilities.effects.Effect;
import mage.game.Game;
import mage.game.combat.Combat;
import mage.game.combat.CombatGroup;
import mage.game.events.GameEvent;
import mage.game.match.MatchPlayer;
import mage.game.permanent.Permanent;
import mage.game.stack.StackAbility;
import mage.game.stack.StackObject;
import mage.player.ai.ComputerPlayer;
import mage.player.ai.SimulationNode2;
import mage.players.Player;
import mage.players.net.UserData;
import mage.target.Target;
import org.apache.log4j.Logger;

public final class SimulatedPlayer2
extends ComputerPlayer {
    private static final Logger logger = Logger.getLogger(SimulatedPlayer2.class);
    private static final boolean AI_SIMULATE_ALL_BAD_AND_GOOD_TARGETS = false;
    private final boolean isSimulatedPlayer;
    private transient ConcurrentLinkedQueue<Ability> allActions;
    private final Player originalPlayer;

    public SimulatedPlayer2(Player originalPlayer, boolean isSimulatedPlayer) {
        super(originalPlayer.getId());
        this.originalPlayer = originalPlayer.copy();
        this.isSimulatedPlayer = isSimulatedPlayer;
        this.userData = UserData.getDefaultUserDataView();
        this.matchPlayer = new MatchPlayer(originalPlayer.getMatchPlayer(), (Player)this);
    }

    public SimulatedPlayer2(SimulatedPlayer2 player) {
        super((ComputerPlayer)player);
        this.isSimulatedPlayer = player.isSimulatedPlayer;
        this.originalPlayer = player.originalPlayer.copy();
    }

    public void restore(Player player) {
        if (!this.originalPlayer.getClass().equals(player.getClass())) {
            throw new IllegalArgumentException("Wrong code usage: simulated player must use same player class all the time. Need " + this.originalPlayer.getClass().getSimpleName() + ", but try to restore " + player.getClass().getSimpleName());
        }
        super.restore(player.getRealPlayer());
    }

    public SimulatedPlayer2 copy() {
        return new SimulatedPlayer2(this);
    }

    public List<Ability> simulatePriority(Game game) {
        this.allActions = new ConcurrentLinkedQueue();
        Game sim = game.createSimulationForAI();
        this.simulateOptions(sim);
        ArrayList<Ability> list = new ArrayList<Ability>(this.allActions);
        Collections.reverse(list);
        list.add((Ability)new PassAbility());
        if (logger.isTraceEnabled()) {
            for (Ability a : this.allActions) {
                logger.info((Object)("ability==" + a));
                if (a.getTargets().isEmpty()) continue;
                MageObject mageObject = game.getObject(a.getFirstTarget());
                if (mageObject != null) {
                    logger.info((Object)("   target=" + mageObject.getName()));
                    continue;
                }
                Player player = game.getPlayer(a.getFirstTarget());
                if (player == null) continue;
                logger.info((Object)("   target=" + player.getName()));
            }
        }
        return list;
    }

    private void simulateOptions(Game game) {
        List playables = game.getPlayer(this.playerId).getPlayable(game, this.isSimulatedPlayer);
        for (ActivatedAbility ability : playables) {
            if (ability.isManaAbility()) continue;
            List<Ability> options = game.getPlayer(this.playerId).getPlayableOptions((Ability)ability, game);
            if ((options = this.optimizeOptions(game, options, (Ability)ability)).isEmpty()) {
                this.allActions.add((Ability)ability);
                continue;
            }
            for (Ability option : options) {
                this.allActions.add(option);
            }
        }
    }

    protected void addVariableXOptions(List<Ability> options, Ability ability, int targetNum, Game game) {
        int numAvailable = this.getAvailableManaProducers(game).size() - ability.getManaCosts().manaValue();
        if (numAvailable > 0) {
            VariableManaCost variableManaCost = null;
            for (ManaCost cost : ability.getManaCostsToPay()) {
                if (!(cost instanceof VariableManaCost) || cost.isPaid()) continue;
                variableManaCost = (VariableManaCost)cost;
                break;
            }
            if (variableManaCost != null) {
                int xInstancesCount = variableManaCost.getXInstancesCount();
                for (int mana = variableManaCost.getMinX(); mana <= numAvailable; ++mana) {
                    if (mana % xInstancesCount != 0) continue;
                    int xAnnounceValue = mana / xInstancesCount;
                    Ability newAbility = ability.copy();
                    VariableManaCost varCost = null;
                    for (ManaCost cost : newAbility.getManaCostsToPay()) {
                        if (!(cost instanceof VariableManaCost) || cost.isPaid()) continue;
                        varCost = (VariableManaCost)cost;
                        break;
                    }
                    newAbility.addManaCostsToPay((ManaCost)new ManaCostsImpl("{" + xAnnounceValue + '}'));
                    newAbility.getManaCostsToPay().setX(xAnnounceValue, xAnnounceValue * xInstancesCount);
                    if (varCost != null) {
                        varCost.setPaid();
                    }
                    newAbility.adjustTargets(game);
                    if (newAbility.getTargets().getNextUnchosen(game) == null) continue;
                    this.addTargetOptions(options, newAbility, targetNum, game);
                }
            }
        }
    }

    protected List<Ability> optimizeOptions(Game game, List<Ability> options, Ability ability) {
        Permanent permanent;
        Ability ability1;
        if (options.isEmpty()) {
            return options;
        }
        options.removeIf(option -> !option.getTargets().isChosen(game));
        Iterator<Ability> iterator = options.iterator();
        boolean bad = true;
        boolean good = true;
        for (Effect effect : ability.getEffects()) {
            if (effect.getOutcome().isGood()) {
                bad = false;
                continue;
            }
            good = false;
        }
        if (bad) {
            while (iterator.hasNext()) {
                ability1 = iterator.next();
                if (ability1.getTargets().size() != 1 || ((Target)ability1.getTargets().get(0)).getTargets().size() != 1) continue;
                permanent = game.getPermanent(ability1.getFirstTarget());
                if (permanent != null && !game.getOpponents(this.playerId, true).contains(permanent.getControllerId())) {
                    iterator.remove();
                    continue;
                }
                if (!ability1.getFirstTarget().equals(this.playerId)) continue;
                iterator.remove();
            }
        }
        if (good) {
            while (iterator.hasNext()) {
                ability1 = iterator.next();
                if (ability1.getTargets().size() != 1 || ((Target)ability1.getTargets().get(0)).getTargets().size() != 1) continue;
                permanent = game.getPermanent(ability1.getFirstTarget());
                if (permanent != null && game.getOpponents(this.playerId, true).contains(permanent.getControllerId())) {
                    iterator.remove();
                    continue;
                }
                if (!game.getOpponents(this.playerId, true).contains(ability1.getFirstTarget())) continue;
                iterator.remove();
            }
        }
        return options;
    }

    public List<Combat> addAttackers(Game game) {
        HashMap<Integer, Combat> engagements = new HashMap<Integer, Combat>();
        UUID defenderId = (UUID)game.getOpponents(this.playerId, true).iterator().next();
        List attackersList = super.getAvailableAttackers(defenderId, game);
        int powerElements = (int)Math.pow(2.0, attackersList.size());
        StringBuilder binary = new StringBuilder();
        for (int i = powerElements - 1; i >= 0; --i) {
            Game sim = game.createSimulationForAI();
            binary.setLength(0);
            binary.append(Integer.toBinaryString(i));
            while (binary.length() < attackersList.size()) {
                binary.insert(0, '0');
            }
            for (int j = 0; j < attackersList.size(); ++j) {
                if (binary.charAt(j) != '1') continue;
                this.setStoredBookmark(sim.bookmarkState());
                if (sim.getCombat().declareAttacker(((Permanent)attackersList.get(j)).getId(), defenderId, this.playerId, sim)) continue;
                sim.undo(this.playerId);
            }
            if (engagements.put(sim.getCombat().getValue().hashCode(), sim.getCombat()) != null) {
                logger.debug((Object)"simulating -- found redundant attack combination");
                continue;
            }
            logger.debug((Object)("simulating -- attack:" + sim.getCombat().getGroups().size()));
        }
        ArrayList<Combat> list = new ArrayList<Combat>(engagements.values());
        Collections.sort(list, new Comparator<Combat>(){

            @Override
            public int compare(Combat o1, Combat o2) {
                return Integer.valueOf(o2.getGroups().size()).compareTo(o1.getGroups().size());
            }
        });
        return list;
    }

    public List<Combat> addBlockers(Game game) {
        HashMap<Integer, Combat> engagements = new HashMap<Integer, Combat>();
        int numGroups = game.getCombat().getGroups().size();
        if (numGroups == 0) {
            return Collections.emptyList();
        }
        Game sim = game.createSimulationForAI();
        engagements.put(sim.getCombat().getValue().hashCode(), sim.getCombat());
        sim.fireEvent(GameEvent.getEvent((GameEvent.EventType)GameEvent.EventType.DECLARED_BLOCKERS, (UUID)this.playerId, (UUID)this.playerId));
        List blockers = this.getAvailableBlockers(game);
        this.addBlocker(game, blockers, engagements);
        return new ArrayList<Combat>(engagements.values());
    }

    protected void addBlocker(Game game, List<Permanent> blockers, Map<Integer, Combat> engagements) {
        if (blockers.isEmpty()) {
            return;
        }
        int numGroups = game.getCombat().getGroups().size();
        Permanent blocker = blockers.get(0);
        logger.debug((Object)("simulating -- block:" + blocker));
        List remaining = this.remove(blockers, blocker);
        for (int i = 0; i < numGroups; ++i) {
            if (!((CombatGroup)game.getCombat().getGroups().get(i)).canBlock(blocker, game)) continue;
            Game sim = game.createSimulationForAI();
            ((CombatGroup)sim.getCombat().getGroups().get(i)).addBlocker(blocker.getId(), this.playerId, sim);
            if (engagements.put(sim.getCombat().getValue().hashCode(), sim.getCombat()) != null) {
                logger.debug((Object)"simulating -- found redundant block combination");
            }
            this.addBlocker(sim, remaining, engagements);
        }
        this.addBlocker(game, remaining, engagements);
    }

    public boolean triggerAbility(TriggeredAbility source, Game game) {
        TriggeredAbility ability = source.copy();
        List options = this.getPlayableOptions((Ability)ability, game);
        if (options.isEmpty()) {
            logger.debug((Object)("simulating -- triggered ability:" + ability));
            game.getStack().push(game, (StackObject)new StackAbility((Ability)ability, this.playerId));
            if (ability.activate(game, false) && ability.isUsesStack()) {
                game.fireEvent(new GameEvent(GameEvent.EventType.TRIGGERED_ABILITY, ability.getId(), (Ability)ability, ability.getControllerId()));
            }
            game.applyEffects();
            game.getPlayers().resetPassed();
        } else {
            SimulationNode2 parent = (SimulationNode2)game.getCustomData();
            int depth = parent.getDepth() - 1;
            if (depth == 0) {
                return true;
            }
            logger.debug((Object)("simulating -- triggered ability - adding children:" + options.size()));
            for (Ability option : options) {
                this.addAbilityNode(parent, option, depth, game);
            }
        }
        return true;
    }

    protected void addAbilityNode(SimulationNode2 parent, Ability ability, int depth, Game game) {
        Game sim = game.createSimulationForAI();
        sim.getStack().push(sim, (StackObject)new StackAbility(ability, this.playerId));
        if (ability.activate(sim, false) && ability.isUsesStack()) {
            sim.fireEvent(new GameEvent(GameEvent.EventType.TRIGGERED_ABILITY, ability.getId(), ability, ability.getControllerId()));
        }
        sim.applyEffects();
        SimulationNode2 newNode = new SimulationNode2(parent, sim, depth, this.playerId);
        logger.debug((Object)("simulating -- node #:" + SimulationNode2.getCount() + " triggered ability option"));
        for (Target target : ability.getTargets()) {
            for (UUID targetId : target.getTargets()) {
                newNode.getTargets().add(targetId);
            }
        }
        parent.children.add(newNode);
    }

    public boolean priority(Game game) {
        if (game.getStack().isEmpty()) {
            game.pause();
        }
        this.pass(game);
        return false;
    }

    public boolean flipCoinResult(Game game) {
        return this.originalPlayer.flipCoinResult(game);
    }

    public int rollDieResult(int sides, Game game) {
        return this.originalPlayer.rollDieResult(sides, game);
    }
}

