/*
 * Decompiled with CFR 0.152.
 */
package mage.player.ai.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.InfectAbility;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.combat.Combat;
import mage.game.combat.CombatGroup;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.turn.CombatDamageStep;
import mage.game.turn.EndOfCombatStep;
import mage.game.turn.Step;
import mage.player.ai.score.GameStateEvaluator2;
import mage.player.ai.util.CombatInfo;
import mage.player.ai.util.SurviveInfo;
import mage.players.Player;
import org.apache.log4j.Logger;

public final class CombatUtil {
    private static final List<Permanent> emptyList = Collections.unmodifiableList(new ArrayList());
    private static final Logger log = Logger.getLogger(CombatUtil.class);

    private CombatUtil() {
    }

    public static List<Permanent> canKillOpponent(Game game, List<Permanent> attackersList, List<Permanent> blockersList, Player defender) {
        ArrayList<Permanent> blockableAttackers = new ArrayList<Permanent>(attackersList);
        ArrayList<Permanent> unblockableAttackers = new ArrayList<Permanent>();
        for (Permanent attacker : attackersList) {
            if (CombatUtil.canBeBlocked(game, attacker, blockersList)) continue;
            unblockableAttackers.add(attacker);
            blockableAttackers.remove(attacker);
        }
        CombatUtil.sortByPower(blockableAttackers, false);
        ArrayList<Permanent> attackersThatWontBeBlocked = new ArrayList<Permanent>(blockableAttackers);
        for (int i = 0; i < blockersList.size() && i < blockableAttackers.size(); ++i) {
            attackersThatWontBeBlocked.remove(blockableAttackers.get(i));
        }
        attackersThatWontBeBlocked.addAll(unblockableAttackers);
        if (CombatUtil.sumDamage(attackersThatWontBeBlocked, defender) >= defender.getLife() && defender.isLifeTotalCanChange() && defender.canLose(game) && defender.getLife() > 0) {
            blockableAttackers.addAll(unblockableAttackers);
            return blockableAttackers;
        }
        if (CombatUtil.sumPoisonDamage(attackersThatWontBeBlocked, defender) >= 10 - defender.getCountersCount(CounterType.POISON)) {
            blockableAttackers.addAll(unblockableAttackers);
            return blockableAttackers;
        }
        return emptyList;
    }

    public static boolean canBeBlocked(Game game, Permanent attacker, List<Permanent> blockersList) {
        for (Permanent blocker : blockersList) {
            if (!blocker.canBlock(attacker.getId(), game)) continue;
            return true;
        }
        return false;
    }

    public static void sortByPower(List<Permanent> permanents, boolean ascending) {
        permanents.sort(Comparator.comparingInt(p -> p.getPower().getValue()));
        if (!ascending) {
            Collections.reverse(permanents);
        }
    }

    public static Permanent getWorstCreature(List<Permanent> ... lists) {
        for (List<Permanent> list : lists) {
            if (list.isEmpty()) continue;
            list.sort(Comparator.comparingInt(p -> p.getPower().getValue()));
            return list.get(0);
        }
        return null;
    }

    public static void removeWorstCreature(Permanent permanent, List<Permanent> ... lists) {
        for (List<Permanent> list : lists) {
            if (list.isEmpty()) continue;
            list.remove(permanent);
        }
    }

    private static int sumDamage(List<Permanent> attackersThatWontBeBlocked, Player defender) {
        int damage = 0;
        for (Permanent attacker : attackersThatWontBeBlocked) {
            if (attacker.getAbilities().contains((Ability)InfectAbility.getInstance())) continue;
            damage += attacker.getPower().getValue();
            if (!attacker.getAbilities().contains((Ability)DoubleStrikeAbility.getInstance())) continue;
            damage += attacker.getPower().getValue();
        }
        return damage;
    }

    private static int sumPoisonDamage(List<Permanent> attackersThatWontBeBlocked, Player defender) {
        int damage = 0;
        for (Permanent attacker : attackersThatWontBeBlocked) {
            if (!attacker.getAbilities().contains((Ability)InfectAbility.getInstance())) continue;
            damage += attacker.getPower().getValue();
            if (!attacker.getAbilities().contains((Ability)DoubleStrikeAbility.getInstance())) continue;
            damage += attacker.getPower().getValue();
        }
        return damage;
    }

    public static void handleExalted() {
    }

    public static List<Permanent> getPossibleBlockers(Game game, Permanent attacker, List<Permanent> blockersList) {
        ArrayList<Permanent> canBlock = new ArrayList<Permanent>();
        for (Permanent blocker : blockersList) {
            if (!blocker.canBlock(attacker.getId(), game)) continue;
            canBlock.add(blocker);
        }
        return canBlock;
    }

    public static CombatInfo blockWithGoodTrade2(Game game, List<Permanent> attackers, List<Permanent> blockers) {
        UUID attackerId = game.getCombat().getAttackingPlayerId();
        UUID defenderId = (UUID)game.getCombat().getDefenders().iterator().next();
        if (attackerId == null || defenderId == null) {
            return new CombatInfo();
        }
        CombatInfo combatInfo = new CombatInfo();
        for (Permanent attacker : attackers) {
            List<Permanent> allBlockers = CombatUtil.getPossibleBlockers(game, attacker, blockers);
            List<SurviveInfo> blockerStats = CombatUtil.getBlockersThatWillSurvive2(game, attackerId, defenderId, attacker, allBlockers);
            HashMap blockingDiffScore = new HashMap();
            HashMap nonBlockingDiffScore = new HashMap();
            blockerStats.forEach(s -> {
                blockingDiffScore.put(s.getBlocker(), s.getDiffBlockingScore());
                nonBlockingDiffScore.put(s.getBlocker(), s.getDiffNonblockingScore());
            });
            ArrayList survivedAndKillBlocker = new ArrayList();
            ArrayList survivedBlockers = new ArrayList();
            ArrayList diedBlockers = new ArrayList();
            blockerStats.forEach(stats -> {
                if (stats.isAttackerDied() && !stats.isBlockerDied()) {
                    survivedAndKillBlocker.add(stats.getBlocker());
                } else if (!stats.isBlockerDied()) {
                    survivedBlockers.add(stats.getBlocker());
                } else {
                    diedBlockers.add(stats.getBlocker());
                }
            });
            int blockedCount = 0;
            Permanent blocker = CombatUtil.getWorstCreature(survivedAndKillBlocker, survivedBlockers);
            if (blocker != null) {
                combatInfo.addPair(attacker, blocker);
                CombatUtil.removeWorstCreature(blocker, blockers, survivedAndKillBlocker, survivedBlockers);
                ++blockedCount;
            }
            if (blocker == null && (blocker = CombatUtil.getWorstCreature(diedBlockers)) != null) {
                int diffBlockingScore = blockingDiffScore.getOrDefault(blocker, 0);
                int diffNonBlockingScore = nonBlockingDiffScore.getOrDefault(blocker, 0);
                if (diffBlockingScore >= 0 || diffBlockingScore > diffNonBlockingScore) {
                    combatInfo.addPair(attacker, blocker);
                    CombatUtil.removeWorstCreature(blocker, blockers, diedBlockers);
                    ++blockedCount;
                }
            }
            while (!blockers.isEmpty() && blockedCount > 0 && attacker.getMinBlockedBy() > blockedCount && (blocker = CombatUtil.getWorstCreature(survivedBlockers, survivedAndKillBlocker, diedBlockers)) != null) {
                combatInfo.addPair(attacker, blocker);
                CombatUtil.removeWorstCreature(blocker, blockers, survivedBlockers, survivedAndKillBlocker, diedBlockers);
                ++blockedCount;
            }
            if (!blockers.isEmpty()) continue;
            break;
        }
        return combatInfo;
    }

    private static List<SurviveInfo> getBlockersThatWillSurvive2(Game game, UUID attackerId, UUID defenderId, Permanent attacker, List<Permanent> possibleBlockers) {
        ArrayList<SurviveInfo> res = new ArrayList<SurviveInfo>();
        for (Permanent blocker : possibleBlockers) {
            SurviveInfo info = CombatUtil.willItSurviveSimple(game, attackerId, defenderId, attacker, blocker);
            if (info == null) continue;
            info.setBlocker(blocker);
            res.add(info);
        }
        return res;
    }

    public static SurviveInfo willItSurviveSimulation(Game originalGame, UUID attackingPlayerId, UUID defendingPlayerId, Permanent attacker, Permanent blocker) {
        Game sim = originalGame.createSimulationForAI();
        if (blocker == null || attacker == null || sim.getPlayer(defendingPlayerId) == null) {
            return null;
        }
        Combat combat = sim.getCombat();
        combat.setAttacker(attackingPlayerId);
        combat.setDefenders(sim);
        int startScore = GameStateEvaluator2.evaluate((UUID)defendingPlayerId, (Game)sim).getTotalScore();
        sim.getPlayer(defendingPlayerId).declareBlocker(defendingPlayerId, blocker.getId(), attacker.getId(), sim);
        sim.fireEvent(GameEvent.getEvent((GameEvent.EventType)GameEvent.EventType.DECLARED_BLOCKERS, (UUID)defendingPlayerId, (UUID)defendingPlayerId));
        sim.checkStateAndTriggered();
        while (!sim.getStack().isEmpty()) {
            sim.getStack().resolve(sim);
            sim.applyEffects();
        }
        sim.fireEvent(GameEvent.getEvent((GameEvent.EventType)GameEvent.EventType.DECLARE_BLOCKERS_STEP_POST, (UUID)sim.getActivePlayerId(), (UUID)sim.getActivePlayerId()));
        CombatUtil.simulateStep(sim, (Step)new CombatDamageStep(true));
        CombatUtil.simulateStep(sim, (Step)new CombatDamageStep(false));
        CombatUtil.simulateStep(sim, (Step)new EndOfCombatStep());
        sim.checkStateAndTriggered();
        while (!sim.getStack().isEmpty()) {
            sim.getStack().resolve(sim);
            sim.applyEffects();
        }
        int endBlockingScore = GameStateEvaluator2.evaluate((UUID)defendingPlayerId, (Game)sim).getTotalScore();
        int endNonBlockingScore = startScore;
        return new SurviveInfo(!sim.getBattlefield().containsPermanent(attacker.getId()), !sim.getBattlefield().containsPermanent(blocker.getId()), endBlockingScore - startScore, endNonBlockingScore - startScore);
    }

    public static SurviveInfo willItSurviveSimple(Game originalGame, UUID attackingPlayerId, UUID defendingPlayerId, Permanent attacker, Permanent blocker) {
        Game sim = originalGame.createSimulationForAI();
        if (blocker == null || attacker == null || sim.getPlayer(defendingPlayerId) == null) {
            return null;
        }
        Combat combat = sim.getCombat();
        combat.setAttacker(attackingPlayerId);
        combat.setDefenders(sim);
        Game simNonBlocking = (Game)sim.copy();
        int startScore = GameStateEvaluator2.evaluate((UUID)defendingPlayerId, (Game)sim, (boolean)false).getTotalScore();
        Permanent simAttacker = sim.getPermanent(attacker.getId());
        Permanent simBlocker = sim.getPermanent(blocker.getId());
        if (simAttacker == null || simBlocker == null) {
            throw new IllegalArgumentException("Broken sim game, can't find attacker or blocker");
        }
        CombatUtil.simulateCombatDamage(sim, simBlocker, simAttacker, true);
        CombatUtil.simulateCombatDamage(sim, simAttacker, simBlocker, true);
        simAttacker.applyDamage(sim);
        simBlocker.applyDamage(sim);
        sim.checkStateAndTriggered();
        sim.processAction();
        if (sim.getPermanent(simBlocker.getId()) != null && sim.getPermanent(simAttacker.getId()) != null) {
            CombatUtil.simulateCombatDamage(sim, simBlocker, simAttacker, false);
            CombatUtil.simulateCombatDamage(sim, simAttacker, simBlocker, false);
            simAttacker.applyDamage(sim);
            simBlocker.applyDamage(sim);
            sim.checkStateAndTriggered();
            sim.processAction();
        }
        simNonBlocking.getPlayer(defendingPlayerId).damage(attacker.getPower().getValue(), attacker.getId(), null, simNonBlocking, true, true);
        simNonBlocking.checkStateAndTriggered();
        simNonBlocking.processAction();
        int endBlockingScore = GameStateEvaluator2.evaluate((UUID)defendingPlayerId, (Game)sim, (boolean)false).getTotalScore();
        int endNonBlockingScore = GameStateEvaluator2.evaluate((UUID)defendingPlayerId, (Game)simNonBlocking, (boolean)false).getTotalScore();
        return new SurviveInfo(!sim.getBattlefield().containsPermanent(attacker.getId()), !sim.getBattlefield().containsPermanent(blocker.getId()), endBlockingScore - startScore, endNonBlockingScore - startScore);
    }

    private static void simulateCombatDamage(Game sim, Permanent fromCreature, Permanent toCreature, boolean isFirstDamageStep) {
        SimpleStaticAbility fakeAbility = new SimpleStaticAbility(null);
        if (CombatGroup.dealsDamageThisStep((Permanent)fromCreature, (boolean)isFirstDamageStep, (Game)sim)) {
            fakeAbility.setSourceId(fromCreature.getId());
            fakeAbility.setControllerId(fromCreature.getControllerId());
            toCreature.damage(fromCreature.getPower().getValue(), fromCreature.getId(), (Ability)fakeAbility, sim, true, true);
        }
    }

    private static void simulateStep(Game sim, Step step) {
        sim.getPhase().setStep(step);
        if (!step.skipStep(sim, sim.getActivePlayerId())) {
            step.beginStep(sim, sim.getActivePlayerId());
            while (!sim.getStack().isEmpty()) {
                sim.getStack().resolve(sim);
                sim.applyEffects();
            }
            step.endStep(sim, sim.getActivePlayerId());
        }
    }
}

