/*
 * Decompiled with CFR 0.152.
 */
package mage.deck;

import java.util.ArrayList;
import java.util.Arrays;
import mage.cards.Card;
import mage.cards.decks.Deck;
import mage.cards.decks.DeckValidator;
import mage.cards.decks.DeckValidatorErrorType;

public class Momir
extends DeckValidator {
    public Momir() {
        super("Momir Basic", "Momir");
    }

    public int getDeckMinSize() {
        return 60;
    }

    public int getSideboardMinSize() {
        return 0;
    }

    public boolean validate(Deck deck) {
        boolean valid = true;
        this.errorsList.clear();
        if (deck.getMaindeckCards().size() != this.getDeckMinSize()) {
            this.addError(DeckValidatorErrorType.DECK_SIZE, "Deck", "Must contain " + this.getDeckMinSize() + " cards: has " + deck.getMaindeckCards().size() + " cards");
            valid = false;
        }
        ArrayList<String> basicLandNames = new ArrayList<String>(Arrays.asList("Forest", "Island", "Mountain", "Swamp", "Plains", "Wastes"));
        for (Card card : deck.getCards()) {
            if (basicLandNames.contains(card.getName())) continue;
            this.addError(DeckValidatorErrorType.OTHER, card.getName(), "Only basic lands are allowed", true);
            valid = false;
        }
        return valid;
    }
}

