/*
 * Decompiled with CFR 0.152.
 */
package mage.deck;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mage.abilities.Ability;
import mage.abilities.keyword.PartnerAbility;
import mage.abilities.keyword.PartnerWithAbility;
import mage.cards.Card;
import mage.cards.decks.Constructed;
import mage.cards.decks.Deck;
import mage.cards.decks.DeckValidatorErrorType;
import mage.constants.CardType;
import mage.filter.FilterMana;
import mage.util.ManaUtil;

public class Oathbreaker
extends Constructed {
    protected List<String> bannedCommander = new ArrayList<String>();
    private static final Map<String, Integer> pdAllowed = new HashMap<String, Integer>();

    public Oathbreaker() {
        super("Oathbreaker");
        this.banned.add("Ad Nauseam");
        this.banned.add("Ancestral Recall");
        this.banned.add("Balance");
        this.banned.add("Biorhythm");
        this.banned.add("Black Lotus");
        this.banned.add("Channel");
        this.banned.add("Dark Ritual");
        this.banned.add("Doomsday");
        this.banned.add("Emrakul, the Aeons Torn");
        this.banned.add("Expropriate");
        this.banned.add("Fastbond");
        this.banned.add("Gifts Ungiven");
        this.banned.add("Griselbrand");
        this.banned.add("High Tide");
        this.banned.add("Jeweled Lotus");
        this.banned.add("Library of Alexandria");
        this.banned.add("Limited Resources");
        this.banned.add("Lion's Eye Diamond");
        this.banned.add("Mana Crypt");
        this.banned.add("Mana Geyser");
        this.banned.add("Mana Vault");
        this.banned.add("Mox Emerald");
        this.banned.add("Mox Jet");
        this.banned.add("Mox Pearl");
        this.banned.add("Mox Ruby");
        this.banned.add("Mox Sapphire");
        this.banned.add("Natural Order");
        this.banned.add("Painter's Servant");
        this.banned.add("Panoptic Mirror");
        this.banned.add("Primal Surge");
        this.banned.add("Saheeli, the Gifted");
        this.banned.add("Sol Ring");
        this.banned.add("Sundering Titan");
        this.banned.add("Sylvan Primordial");
        this.banned.add("Time Vault");
        this.banned.add("Time Walk");
        this.banned.add("Tinker");
        this.banned.add("Tolarian Academy");
        this.banned.add("Tooth and Nail");
        this.banned.add("Trade Secrets");
        this.banned.add("Upheaval");
        this.banned.add("Yawgmoth's Bargain");
    }

    public int getDeckMinSize() {
        return 56;
    }

    public int getSideboardMinSize() {
        return 2;
    }

    public boolean validate(Deck deck) {
        boolean valid = true;
        this.errorsList.clear();
        if (deck.getMaindeckCards().size() + deck.getSideboard().size() != 60) {
            this.addError(DeckValidatorErrorType.DECK_SIZE, "Deck", "Must contain 60 cards: has " + (deck.getMaindeckCards().size() + deck.getSideboard().size()) + " cards");
            valid = false;
        }
        HashMap counts = new HashMap();
        this.countCards(counts, deck.getCards());
        this.countCards(counts, deck.getSideboard());
        for (String bannedCard : this.banned) {
            if (!counts.containsKey(bannedCard)) continue;
            this.addError(DeckValidatorErrorType.BANNED, bannedCard, "Banned", true);
            valid = false;
        }
        valid = this.checkCounts(1, counts) && valid;
        HashSet<String> commanderNames = new HashSet<String>();
        HashSet<String> signatureSpells = new HashSet<String>();
        FilterMana allCommandersColor = new FilterMana();
        if (deck.getSideboard().size() < 2 || deck.getSideboard().size() > 4) {
            this.addError(DeckValidatorErrorType.PRIMARY, "Oathbreaker", "Sideboard must contain only 2 or 4 cards (oathbreaker + signature spell)");
            valid = false;
        } else {
            for (Card commander : deck.getSideboard()) {
                if (commander.isInstantOrSorcery()) {
                    signatureSpells.add(commander.getName());
                    continue;
                }
                if (commander.hasCardTypeForDeckbuilding(CardType.PLANESWALKER)) {
                    commanderNames.add(commander.getName());
                    ManaUtil.collectColorIdentity((FilterMana)allCommandersColor, (FilterMana)commander.getColorIdentity());
                    continue;
                }
                this.addError(DeckValidatorErrorType.PRIMARY, commander.getName(), "Oathbreaker (only planeswalker can be Oathbreaker, not " + commander.getName(), true);
                valid = false;
            }
            if (commanderNames.isEmpty() || commanderNames.size() > 2) {
                this.addError(DeckValidatorErrorType.PRIMARY, "Oathbreaker", "Sideboard must contains 1 or 2 oathbreakers, but found: " + commanderNames.size());
                valid = false;
            }
            if (signatureSpells.isEmpty() || signatureSpells.size() > 2) {
                this.addError(DeckValidatorErrorType.PRIMARY, "Signature Spell", "Sideboard must contains 1 or 2 signature spells, but found: " + signatureSpells.size());
                valid = false;
            }
            if (signatureSpells.size() != commanderNames.size()) {
                this.addError(DeckValidatorErrorType.PRIMARY, "Oathbreaker", "Sideboard must contains 1 + 1 or 2 + 2 cards, but found: " + commanderNames.size() + " + " + signatureSpells.size());
                valid = false;
            }
            for (Card commander : deck.getSideboard()) {
                if (!commanderNames.contains(commander.getName()) || commanderNames.size() != 2 || commander.getAbilities().contains((Ability)PartnerAbility.getInstance())) continue;
                boolean partnersWith = false;
                for (Ability ability : commander.getAbilities()) {
                    if (!(ability instanceof PartnerWithAbility) || !commanderNames.contains(((PartnerWithAbility)ability).getPartnerName())) continue;
                    partnersWith = true;
                    break;
                }
                if (partnersWith) continue;
                this.addError(DeckValidatorErrorType.PRIMARY, commander.getName(), "Oathbreaker without Partner (" + commander.getName() + ')', true);
                valid = false;
            }
            for (Card spell : deck.getSideboard()) {
                if (!signatureSpells.contains(spell.getName())) continue;
                FilterMana spellColor = spell.getColorIdentity();
                boolean haveSameColor = false;
                for (Card commander : deck.getSideboard()) {
                    FilterMana commanderColor;
                    if (!commanderNames.contains(commander.getName()) || !ManaUtil.isColorIdentityCompatible((FilterMana)(commanderColor = commander.getColorIdentity()), (FilterMana)spellColor)) continue;
                    haveSameColor = true;
                }
                if (haveSameColor) continue;
                this.addError(DeckValidatorErrorType.PRIMARY, spell.getName(), "Signature Spell (can't find oathbreaker with compatible color identity: " + spell.getName() + " - " + spellColor + ")", true);
                valid = false;
            }
        }
        if (!valid) {
            return false;
        }
        for (Card card : deck.getCards()) {
            if (ManaUtil.isColorIdentityCompatible((FilterMana)allCommandersColor, (FilterMana)card.getColorIdentity())) continue;
            this.addError(DeckValidatorErrorType.OTHER, card.getName(), "Invalid color (need " + allCommandersColor + ", but get " + card.getColorIdentity() + ")", true);
            valid = false;
        }
        for (Card card : deck.getSideboard()) {
            if (this.isSetAllowed(card.getExpansionSetCode()) || this.legalSets(card)) continue;
            this.addError(DeckValidatorErrorType.WRONG_SET, card.getName(), "Not allowed Set: " + card.getExpansionSetCode(), true);
            valid = false;
        }
        return valid;
    }
}

