/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.bcodec;

import com.turn.ttorrent.bcodec.BEValue;
import com.turn.ttorrent.bcodec.InvalidBEncodingException;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.io.input.AutoCloseInputStream;

public class BDecoder {
    private final InputStream in;
    private int indicator = 0;

    public BDecoder(InputStream in) {
        this.in = in;
    }

    public static BEValue bdecode(InputStream in) throws IOException {
        return new BDecoder(in).bdecode();
    }

    public static BEValue bdecode(ByteBuffer data) throws IOException {
        return BDecoder.bdecode(new AutoCloseInputStream(new ByteArrayInputStream(data.array())));
    }

    private int getNextIndicator() throws IOException {
        if (this.indicator == 0) {
            this.indicator = this.in.read();
        }
        return this.indicator;
    }

    public BEValue bdecode() throws IOException {
        if (this.getNextIndicator() == -1) {
            return null;
        }
        if (this.indicator >= 48 && this.indicator <= 57) {
            return this.bdecodeBytes();
        }
        if (this.indicator == 105) {
            return this.bdecodeNumber();
        }
        if (this.indicator == 108) {
            return this.bdecodeList();
        }
        if (this.indicator == 100) {
            return this.bdecodeMap();
        }
        throw new InvalidBEncodingException("Unknown indicator '" + this.indicator + "'");
    }

    public BEValue bdecodeBytes() throws IOException {
        int c = this.getNextIndicator();
        int num = c - 48;
        if (num < 0 || num > 9) {
            throw new InvalidBEncodingException("Number expected, not '" + (char)c + "'");
        }
        this.indicator = 0;
        c = this.read();
        int i = c - 48;
        while (i >= 0 && i <= 9) {
            num = num * 10 + i;
            c = this.read();
            i = c - 48;
        }
        if (c != 58) {
            throw new InvalidBEncodingException("Colon expected, not '" + (char)c + "'");
        }
        return new BEValue(this.read(num));
    }

    public BEValue bdecodeNumber() throws IOException {
        int c = this.getNextIndicator();
        if (c != 105) {
            throw new InvalidBEncodingException("Expected 'i', not '" + (char)c + "'");
        }
        this.indicator = 0;
        c = this.read();
        if (c == 48) {
            c = this.read();
            if (c == 101) {
                return new BEValue(BigInteger.ZERO);
            }
            throw new InvalidBEncodingException("'e' expected after zero, not '" + (char)c + "'");
        }
        char[] chars = new char[256];
        int off = 0;
        if (c == 45) {
            c = this.read();
            if (c == 48) {
                throw new InvalidBEncodingException("Negative zero not allowed");
            }
            chars[off] = 45;
            ++off;
        }
        if (c < 49 || c > 57) {
            throw new InvalidBEncodingException("Invalid Integer start '" + (char)c + "'");
        }
        chars[off] = (char)c;
        ++off;
        c = this.read();
        int i = c - 48;
        while (i >= 0 && i <= 9) {
            chars[off] = (char)c;
            ++off;
            c = this.read();
            i = c - 48;
        }
        if (c != 101) {
            throw new InvalidBEncodingException("Integer should end with 'e'");
        }
        String s = new String(chars, 0, off);
        return new BEValue(new BigInteger(s));
    }

    public BEValue bdecodeList() throws IOException {
        int c = this.getNextIndicator();
        if (c != 108) {
            throw new InvalidBEncodingException("Expected 'l', not '" + (char)c + "'");
        }
        this.indicator = 0;
        ArrayList<BEValue> result = new ArrayList<BEValue>();
        c = this.getNextIndicator();
        while (c != 101) {
            result.add(this.bdecode());
            c = this.getNextIndicator();
        }
        this.indicator = 0;
        return new BEValue(result);
    }

    public BEValue bdecodeMap() throws IOException {
        int c = this.getNextIndicator();
        if (c != 100) {
            throw new InvalidBEncodingException("Expected 'd', not '" + (char)c + "'");
        }
        this.indicator = 0;
        HashMap<String, BEValue> result = new HashMap<String, BEValue>();
        c = this.getNextIndicator();
        while (c != 101) {
            String key = this.bdecode().getString();
            BEValue value = this.bdecode();
            result.put(key, value);
            c = this.getNextIndicator();
        }
        this.indicator = 0;
        return new BEValue(result);
    }

    private int read() throws IOException {
        int c = this.in.read();
        if (c == -1) {
            throw new EOFException();
        }
        return c;
    }

    private byte[] read(int length) throws IOException {
        int i;
        byte[] result = new byte[length];
        for (int read = 0; read < length; read += i) {
            i = this.in.read(result, read, length - read);
            if (i != -1) continue;
            throw new EOFException();
        }
        return result;
    }
}

