/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.common.protocol.udp;

import com.turn.ttorrent.common.protocol.TrackerMessage;
import com.turn.ttorrent.common.protocol.udp.UDPTrackerMessage;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class UDPTrackerErrorMessage
extends UDPTrackerMessage.UDPTrackerResponseMessage
implements TrackerMessage.ErrorMessage {
    private static final int UDP_TRACKER_ERROR_MIN_MESSAGE_SIZE = 8;
    private final int actionId = TrackerMessage.Type.ERROR.getId();
    private final int transactionId;
    private final String reason;

    private UDPTrackerErrorMessage(ByteBuffer data, int transactionId, String reason) {
        super(TrackerMessage.Type.ERROR, data);
        this.transactionId = transactionId;
        this.reason = reason;
    }

    @Override
    public int getActionId() {
        return this.actionId;
    }

    @Override
    public int getTransactionId() {
        return this.transactionId;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    public static UDPTrackerErrorMessage parse(ByteBuffer data) throws TrackerMessage.MessageValidationException {
        if (data.remaining() < 8) {
            throw new TrackerMessage.MessageValidationException("Invalid tracker error message size!");
        }
        if (data.getInt() != TrackerMessage.Type.ERROR.getId()) {
            throw new TrackerMessage.MessageValidationException("Invalid action code for tracker error!");
        }
        int transactionId = data.getInt();
        byte[] reasonBytes = new byte[data.remaining()];
        data.get(reasonBytes);
        try {
            return new UDPTrackerErrorMessage(data, transactionId, new String(reasonBytes, "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new TrackerMessage.MessageValidationException("Could not decode error message!", uee);
        }
    }

    public static UDPTrackerErrorMessage craft(int transactionId, String reason) throws UnsupportedEncodingException {
        byte[] reasonBytes = reason.getBytes("ISO-8859-1");
        ByteBuffer data = ByteBuffer.allocate(8 + reasonBytes.length);
        data.putInt(TrackerMessage.Type.ERROR.getId());
        data.putInt(transactionId);
        data.put(reasonBytes);
        return new UDPTrackerErrorMessage(data, transactionId, reason);
    }
}

