/*
 * Decompiled with CFR 0.152.
 */
package com.xmage.launcher;

import com.xmage.launcher.Config;
import com.xmage.launcher.XMageBranch;
import com.xmage.launcher.XMageLauncher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class SettingsDialog
extends JDialog {
    private final JTabbedPane tabbedPane;
    private final JPanel buttonPanel;
    private final JPanel panel1;
    private final JPanel panel2;
    private final JPanel panel3;
    private final JTextField txtClientJavaOpt;
    private final JTextField txtServerJavaOpt;
    private final JCheckBox chkUseTorrent;
    private final JTextField txtXMageHome;
    private final JCheckBox chkShowClientConsole;
    private final JCheckBox chkShowServerConsole;
    private final JSpinner spnGuiSize;
    private final JSpinner spnUpRate;
    private final JSpinner spnDownRate;
    private JComboBox<XMageBranch> cmbXMageBranch;

    public SettingsDialog() {
        ImageIcon icon = new ImageIcon(XMageLauncher.class.getResource("/icon-mage-flashed.png"));
        this.setIconImage(icon.getImage());
        Font defaultFont = new Font("SansSerif", 0, Config.getGuiSize());
        this.setTitle("XMage Launcher Settings");
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.pack();
        this.setSize(400 + Config.getGuiSize() * 20, 230 + Config.getGuiSize() * 12);
        this.setBackground(Color.gray);
        this.setLocationRelativeTo(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SettingsDialog.this.handleDone();
            }
        });
        this.setLayout(new BorderLayout());
        this.panel1 = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        layout.columnWeights = new double[]{0.0, 1.0};
        this.panel1.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(10, 10, 10, 10);
        JLabel label = new JLabel("Branch:");
        constraints.anchor = 13;
        this.panel1.add((Component)label, constraints);
        this.cmbXMageBranch = new JComboBox<XMageBranch>(Config.getXMageBranches());
        constraints.gridwidth = 0;
        constraints.fill = 1;
        this.panel1.add(this.cmbXMageBranch, constraints);
        this.cmbXMageBranch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String url = ((XMageBranch)((SettingsDialog)SettingsDialog.this).cmbXMageBranch.getSelectedItem()).url;
                if (url != null) {
                    SettingsDialog.this.txtXMageHome.setText(url);
                    SettingsDialog.this.txtXMageHome.setEnabled(false);
                } else {
                    SettingsDialog.this.txtXMageHome.setEnabled(true);
                }
            }
        });
        constraints = new GridBagConstraints();
        constraints.insets = new Insets(10, 10, 10, 10);
        label = new JLabel("XMage Home:");
        constraints.anchor = 13;
        this.panel1.add((Component)label, constraints);
        this.txtXMageHome = new JTextField();
        this.txtXMageHome.setText(Config.getXMageHome());
        constraints.gridwidth = 0;
        constraints.fill = 1;
        this.panel1.add((Component)this.txtXMageHome, constraints);
        this.txtXMageHome.setEnabled(false);
        this.handleHomeChange();
        label = new JLabel("Show Client Console:");
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        this.panel1.add((Component)label, constraints);
        this.chkShowClientConsole = new JCheckBox();
        this.chkShowClientConsole.setSelected(Config.isShowClientConsole());
        constraints.gridwidth = 0;
        constraints.fill = 1;
        this.panel1.add((Component)this.chkShowClientConsole, constraints);
        label = new JLabel("Show Server Console:");
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        this.panel1.add((Component)label, constraints);
        this.chkShowServerConsole = new JCheckBox();
        this.chkShowServerConsole.setFont(defaultFont);
        this.chkShowServerConsole.setSelected(Config.isShowServerConsole());
        constraints.gridwidth = 0;
        constraints.fill = 1;
        this.panel1.add((Component)this.chkShowServerConsole, constraints);
        label = new JLabel("GUI Size:");
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        this.panel1.add((Component)label, constraints);
        SpinnerNumberModel guiSizemodel = new SpinnerNumberModel(Config.getGuiSize(), 10, 50, 1);
        this.spnGuiSize = new JSpinner(guiSizemodel);
        this.spnGuiSize.setValue(Config.getGuiSize());
        this.spnGuiSize.setFont(defaultFont);
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        this.panel1.add((Component)this.spnGuiSize, constraints);
        constraints.gridwidth = 0;
        this.panel1.add((Component)Box.createHorizontalBox(), constraints);
        this.panel2 = new JPanel();
        layout = new GridBagLayout();
        layout.columnWeights = new double[]{0.0, 1.0};
        this.panel2.setLayout(layout);
        constraints = new GridBagConstraints();
        constraints.insets = new Insets(10, 10, 10, 10);
        label = new JLabel("Client java options:");
        constraints.anchor = 13;
        this.panel2.add((Component)label, constraints);
        this.txtClientJavaOpt = new JTextField();
        this.txtClientJavaOpt.setText(Config.getClientJavaOpts());
        constraints.gridwidth = 0;
        constraints.fill = 1;
        this.panel2.add((Component)this.txtClientJavaOpt, constraints);
        label = new JLabel("Server java options:");
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        this.panel2.add((Component)label, constraints);
        this.txtServerJavaOpt = new JTextField();
        this.txtServerJavaOpt.setText(Config.getServerJavaOpts());
        constraints.gridwidth = 0;
        constraints.fill = 1;
        this.panel2.add((Component)this.txtServerJavaOpt, constraints);
        this.panel3 = new JPanel();
        layout = new GridBagLayout();
        layout.columnWeights = new double[]{0.0, 1.0};
        this.panel3.setLayout(layout);
        constraints = new GridBagConstraints();
        constraints.insets = new Insets(10, 10, 10, 10);
        label = new JLabel("Always use torrent:");
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        this.panel3.add((Component)label, constraints);
        this.chkUseTorrent = new JCheckBox();
        this.chkUseTorrent.setSelected(Config.isUseTorrent());
        constraints.gridwidth = 0;
        constraints.fill = 1;
        this.panel3.add((Component)this.chkUseTorrent, constraints);
        label = new JLabel("Upload Rate (KB/s):");
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        this.panel3.add((Component)label, constraints);
        SpinnerNumberModel model = new SpinnerNumberModel(Config.getTorrentUpRate(), 0, 100, 1);
        this.spnUpRate = new JSpinner(model);
        this.spnUpRate.setFont(defaultFont);
        this.spnUpRate.setValue(Config.getTorrentUpRate());
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        this.panel3.add((Component)this.spnUpRate, constraints);
        constraints.gridwidth = 0;
        this.panel3.add((Component)Box.createHorizontalBox(), constraints);
        label = new JLabel("Download Rate (KB/s):");
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        this.panel3.add((Component)label, constraints);
        model = new SpinnerNumberModel(Config.getTorrentDownRate(), 0, 100, 1);
        this.spnDownRate = new JSpinner(model);
        this.spnDownRate.setFont(defaultFont);
        this.spnDownRate.setValue(Config.getTorrentDownRate());
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        this.panel3.add((Component)this.spnDownRate, constraints);
        constraints.gridwidth = 0;
        this.panel3.add((Component)Box.createHorizontalBox(), constraints);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("XMage", this.panel1);
        this.tabbedPane.addTab("Java", this.panel2);
        this.tabbedPane.addTab("Torrent", this.panel3);
        this.add((Component)this.tabbedPane, "Center");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 2));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.buttonPanel.add(Box.createHorizontalGlue());
        JButton btnDone = new JButton("Done");
        btnDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.handleDone();
            }
        });
        this.buttonPanel.add(btnDone);
        this.add((Component)this.buttonPanel, "Last");
    }

    private void handleDone() {
        Config.setClientJavaOpts(this.txtClientJavaOpt.getText());
        Config.setServerJavaOpts(this.txtServerJavaOpt.getText());
        Config.setXMageHome(this.txtXMageHome.getText());
        Config.setShowClientConsole(this.chkShowClientConsole.isSelected());
        Config.setShowServerConsole(this.chkShowServerConsole.isSelected());
        Config.setGuiSize((Integer)this.spnGuiSize.getValue());
        Config.setUseTorrent(this.chkUseTorrent.isSelected());
        Config.setTorrentUpRate((Integer)this.spnUpRate.getValue());
        Config.setTorrentDownRate((Integer)this.spnDownRate.getValue());
        Config.saveProperties();
        this.dispose();
    }

    private void handleHomeChange() {
        String url = this.txtXMageHome.getText();
        this.cmbXMageBranch.setSelectedItem(Config.getXMageBranchByUrl(url));
    }
}

