/*
 * Decompiled with CFR 0.152.
 */
package com.xmage.launcher;

import com.xmage.launcher.AboutDialog;
import com.xmage.launcher.Config;
import com.xmage.launcher.DownloadTask;
import com.xmage.launcher.SettingsDialog;
import com.xmage.launcher.Utilities;
import com.xmage.launcher.XMageConsole;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import java.util.Random;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.text.DefaultCaret;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMageLauncher
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(XMageLauncher.class);
    private final ResourceBundle messages;
    private final Locale locale;
    private final JFrame frame;
    private final JLabel mainPanel;
    private final JLabel labelProgress;
    private final JProgressBar progressBar;
    private final JTextArea textArea;
    private final JButton btnLaunchClient;
    private final JLabel xmageLogo;
    private final JButton btnLaunchServer;
    private final JButton btnLaunchClientServer;
    private final JScrollPane scrollPane;
    private final JButton btnCheck;
    private final JButton btnUpdate;
    private JSONObject config;
    private File path;
    private Point grabPoint;
    private Process serverProcess;
    private XMageConsole serverConsole;
    private XMageConsole clientConsole;
    private JToolBar toolBar;
    private boolean newJava = false;
    private boolean noJava = false;
    private boolean newXMage = false;
    private boolean noXMage = false;
    private boolean downgradeXMage = false;

    private XMageLauncher() {
        this.setDefaultFonts();
        this.locale = Locale.getDefault();
        this.messages = ResourceBundle.getBundle("MessagesBundle", this.locale);
        this.localize();
        this.serverConsole = new XMageConsole("XMage Server console");
        this.clientConsole = new XMageConsole("XMage Client console");
        this.frame = new JFrame(this.messages.getString("frameTitle") + " " + Config.getVersion());
        this.frame.setDefaultCloseOperation(3);
        int width = 700 + Config.getGuiSize() * 20;
        int height = 430 + Config.getGuiSize() * 12;
        this.frame.setPreferredSize(new Dimension(width, height));
        this.frame.setResizable(false);
        this.createToolbar();
        ImageIcon icon = new ImageIcon(XMageLauncher.class.getResource("/icon-mage-flashed.png"));
        this.frame.setIconImage(icon.getImage());
        Random r = new Random();
        int imageNum = 1 + r.nextInt(17);
        ImageIcon background = new ImageIcon(new ImageIcon(XMageLauncher.class.getResource("/backgrounds/" + Integer.toString(imageNum) + ".jpg")).getImage().getScaledInstance(width, height, 4));
        this.mainPanel = new JLabel(background){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                Dimension lmPrefSize = this.getLayout().preferredLayoutSize(this);
                size.width = Math.max(size.width, lmPrefSize.width);
                size.height = Math.max(size.height, lmPrefSize.height);
                return size;
            }
        };
        this.mainPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                XMageLauncher.this.grabPoint = e.getPoint();
                XMageLauncher.this.mainPanel.getComponentAt(XMageLauncher.this.grabPoint);
            }
        });
        this.mainPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int thisX = ((XMageLauncher)XMageLauncher.this).frame.getLocation().x;
                int thisY = ((XMageLauncher)XMageLauncher.this).frame.getLocation().y;
                int xMoved = thisX + e.getX() - (thisX + ((XMageLauncher)XMageLauncher.this).grabPoint.x);
                int yMoved = thisY + e.getY() - (thisY + ((XMageLauncher)XMageLauncher.this).grabPoint.y);
                int X = thisX + xMoved;
                int Y = thisY + yMoved;
                XMageLauncher.this.frame.setLocation(X, Y);
            }
        });
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(10, 10, 10, 10);
        Font fontBig = new Font("SansSerif", 1, Config.getGuiSize() + 2);
        Font fontSmall = new Font("SansSerif", 0, Config.getGuiSize() - 2);
        Font fontSmallBold = new Font("SansSerif", 1, Config.getGuiSize() - 2);
        this.mainPanel.add(Box.createRigidArea(new Dimension(250, 50)));
        ImageIcon logo = new ImageIcon(new ImageIcon(XMageLauncher.class.getResource("/label-xmage.png")).getImage().getScaledInstance(150, 75, 4));
        this.xmageLogo = new JLabel(logo);
        constraints.gridx = 3;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 0;
        constraints.anchor = 13;
        this.mainPanel.add((Component)this.xmageLogo, constraints);
        this.textArea = new JTextArea(5, 40);
        this.textArea.setEditable(false);
        this.textArea.setForeground(Color.WHITE);
        this.textArea.setBackground(Color.BLACK);
        DefaultCaret caret = (DefaultCaret)this.textArea.getCaret();
        caret.setUpdatePolicy(2);
        this.scrollPane = new JScrollPane(this.textArea);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.mainPanel.add((Component)this.scrollPane, constraints);
        this.labelProgress = new JLabel(this.messages.getString("progress"));
        this.labelProgress.setFont(fontSmall);
        this.labelProgress.setForeground(Color.WHITE);
        constraints.gridy = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        this.mainPanel.add((Component)this.labelProgress, constraints);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setPreferredSize(new Dimension((int)this.progressBar.getPreferredSize().getWidth(), Config.getGuiSize()));
        constraints.gridx = 3;
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        this.mainPanel.add((Component)this.progressBar, constraints);
        JPanel pnlButtons = new JPanel();
        pnlButtons.setLayout(new GridBagLayout());
        pnlButtons.setOpaque(false);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridheight = 0;
        constraints.fill = 1;
        this.mainPanel.add((Component)pnlButtons, constraints);
        this.btnLaunchClient = new JButton(this.messages.getString("launchClient"));
        this.btnLaunchClient.setToolTipText(this.messages.getString("launchClient.tooltip"));
        this.btnLaunchClient.setFont(fontBig);
        this.btnLaunchClient.setForeground(Color.GRAY);
        this.btnLaunchClient.setEnabled(false);
        this.btnLaunchClient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMageLauncher.this.handleClient();
            }
        });
        constraints.gridx = -1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 1;
        pnlButtons.add((Component)this.btnLaunchClient, constraints);
        this.btnLaunchClientServer = new JButton(this.messages.getString("launchClientServer"));
        this.btnLaunchClientServer.setToolTipText(this.messages.getString("launchClientServer.tooltip"));
        this.btnLaunchClientServer.setFont(fontSmallBold);
        this.btnLaunchClientServer.setEnabled(false);
        this.btnLaunchClientServer.setForeground(Color.GRAY);
        this.btnLaunchClientServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMageLauncher.this.handleServer();
                XMageLauncher.this.handleClient();
            }
        });
        constraints.fill = 2;
        pnlButtons.add((Component)this.btnLaunchClientServer, constraints);
        this.btnLaunchServer = new JButton(this.messages.getString("launchServer"));
        this.btnLaunchServer.setToolTipText(this.messages.getString("launchServer.tooltip"));
        this.btnLaunchServer.setFont(fontSmallBold);
        this.btnLaunchServer.setEnabled(false);
        this.btnLaunchServer.setForeground(Color.GRAY);
        this.btnLaunchServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMageLauncher.this.handleServer();
            }
        });
        pnlButtons.add((Component)this.btnLaunchServer, constraints);
        this.btnUpdate = new JButton(this.messages.getString("update.xmage"));
        this.btnUpdate.setToolTipText(this.messages.getString("update.xmage.tooltip"));
        this.btnUpdate.setFont(fontSmallBold);
        this.btnUpdate.setForeground(Color.BLACK);
        this.btnUpdate.setEnabled(true);
        this.btnUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMageLauncher.this.handleUpdate();
            }
        });
        pnlButtons.add((Component)this.btnUpdate, constraints);
        this.btnCheck = new JButton(this.messages.getString("check.xmage"));
        this.btnCheck.setToolTipText(this.messages.getString("check.xmage.tooltip"));
        this.btnCheck.setFont(fontSmallBold);
        this.btnCheck.setForeground(Color.BLACK);
        this.btnCheck.setEnabled(true);
        this.btnCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMageLauncher.this.handleCheckUpdates();
            }
        });
        pnlButtons.add((Component)this.btnCheck, constraints);
        this.frame.add(this.mainPanel);
        this.frame.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setLocation(dim.width / 2 - this.frame.getSize().width / 2, dim.height / 2 - this.frame.getSize().height / 2);
        this.removeOldLauncherFiles();
    }

    private void setDefaultFonts() {
        Font defaultFont = new Font("SansSerif", 0, Config.getGuiSize());
        UIManager.put("Button.font", defaultFont);
        UIManager.put("ToggleButton.font", defaultFont);
        UIManager.put("RadioButton.font", defaultFont);
        UIManager.put("CheckBox.font", defaultFont);
        UIManager.put("ColorChooser.font", defaultFont);
        UIManager.put("ComboBox.font", defaultFont);
        UIManager.put("Label.font", defaultFont);
        UIManager.put("List.font", defaultFont);
        UIManager.put("MenuBar.font", defaultFont);
        UIManager.put("MenuItem.font", defaultFont);
        UIManager.put("RadioButtonMenuItem.font", defaultFont);
        UIManager.put("CheckBoxMenuItem.font", defaultFont);
        UIManager.put("Menu.font", defaultFont);
        UIManager.put("PopupMenu.font", defaultFont);
        UIManager.put("OptionPane.font", defaultFont);
        UIManager.put("Panel.font", defaultFont);
        UIManager.put("ProgressBar.font", defaultFont);
        UIManager.put("ScrollPane.font", defaultFont);
        UIManager.put("Viewport.font", defaultFont);
        UIManager.put("TabbedPane.font", defaultFont);
        UIManager.put("Table.font", defaultFont);
        UIManager.put("TableHeader.font", defaultFont);
        UIManager.put("TextField.font", defaultFont);
        UIManager.put("PasswordField.font", defaultFont);
        UIManager.put("TextArea.font", defaultFont);
        UIManager.put("TextPane.font", defaultFont);
        UIManager.put("EditorPane.font", defaultFont);
        UIManager.put("TitledBorder.font", defaultFont);
        UIManager.put("ToolBar.font", defaultFont);
        UIManager.put("ToolTip.font", defaultFont);
        UIManager.put("Tree.font", defaultFont);
    }

    private void createToolbar() {
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        Border emptyBorder = BorderFactory.createEmptyBorder();
        JButton toolbarButton = new JButton("Settings");
        toolbarButton.setBorder(emptyBorder);
        toolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog settings = new SettingsDialog();
                settings.setVisible(true);
            }
        });
        this.toolBar.add(toolbarButton);
        this.toolBar.addSeparator();
        toolbarButton = new JButton("About");
        toolbarButton.setBorder(emptyBorder);
        toolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog about = new AboutDialog();
                about.setVisible(true);
            }
        });
        this.toolBar.add(toolbarButton);
        this.toolBar.addSeparator();
        toolbarButton = new JButton("Forum");
        toolbarButton.setBorder(emptyBorder);
        toolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMageLauncher.openWebpage("http://www.slightlymagic.net/forum/viewforum.php?f=70");
            }
        });
        this.toolBar.add(toolbarButton);
        this.toolBar.addSeparator();
        toolbarButton = new JButton("Website");
        toolbarButton.setBorder(emptyBorder);
        toolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMageLauncher.openWebpage("http://xmage.de");
            }
        });
        this.toolBar.add(toolbarButton);
        this.frame.add((Component)this.toolBar, "First");
    }

    private static void openWebpage(String uri) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(new URI(uri));
            }
            catch (URISyntaxException ex) {
                logger.error("Error: ", ex);
            }
            catch (IOException ex) {
                logger.error("Error: ", ex);
            }
        }
    }

    private void handleClient() {
        Process p = Utilities.launchClientProcess();
        this.clientConsole.setVisible(Config.isShowClientConsole());
        this.clientConsole.start(p);
    }

    private void handleServer() {
        if (this.serverProcess == null) {
            this.serverProcess = Utilities.launchServerProcess();
            try {
                int exitValue = this.serverProcess.exitValue();
                logger.error("Problem during launch of server process. exit value = " + exitValue);
            }
            catch (IllegalThreadStateException e) {
                this.serverConsole.setVisible(Config.isShowServerConsole());
                this.serverConsole.start(this.serverProcess);
                this.btnLaunchServer.setText(this.messages.getString("stopServer"));
                this.btnLaunchClientServer.setEnabled(false);
            }
        } else {
            Utilities.stopProcess(this.serverProcess);
            this.serverProcess = null;
            this.btnLaunchServer.setText(this.messages.getString("launchServer"));
            this.btnLaunchClientServer.setEnabled(true);
        }
    }

    private void handleUpdate() {
        this.disableButtons();
        if (!this.getConfig()) {
            return;
        }
        this.checkXMage(true);
        if (!this.newJava && !this.newXMage) {
            int response = JOptionPane.showConfirmDialog(this.frame, this.messages.getString("force.update.message"), this.messages.getString("force.update.title"), 0);
            if (response == 0) {
                UpdateTask update = new UpdateTask(this.progressBar, true);
                update.execute();
            } else {
                this.enableButtons();
            }
        } else {
            UpdateTask update = new UpdateTask(this.progressBar, false);
            update.execute();
        }
    }

    private void handleCheckUpdates() {
        if (this.getConfig()) {
            this.checkUpdates();
            if (!this.newJava && !this.newXMage) {
                JOptionPane.showMessageDialog(this.frame, this.messages.getString("xmage.latest.message"), this.messages.getString("xmage.latest.title"), 1);
            }
        }
    }

    private void checkUpdates() {
        this.checkJava();
        this.checkXMage(false);
        this.enableButtons();
    }

    private void localize() {
        UIManager.put("OptionPane.yesButtonText", this.messages.getString("yes"));
        UIManager.put("OptionPane.noButtonText", this.messages.getString("no"));
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            XMageLauncher gui = new XMageLauncher();
            SwingUtilities.invokeLater(gui);
        }
        catch (ClassNotFoundException ex) {
            logger.error("Error: ", ex);
        }
        catch (InstantiationException ex) {
            logger.error("Error: ", ex);
        }
        catch (IllegalAccessException ex) {
            logger.error("Error: ", ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            logger.error("Error: ", ex);
        }
    }

    @Override
    public void run() {
        this.frame.setVisible(true);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                int response;
                if (XMageLauncher.this.serverProcess != null && (response = JOptionPane.showConfirmDialog(XMageLauncher.this.frame, XMageLauncher.this.messages.getString("serverRunning.message"), XMageLauncher.this.messages.getString("serverRunning.title"), 0)) == 0) {
                    Utilities.stopProcess(XMageLauncher.this.serverProcess);
                }
                Config.saveProperties();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (XMageLauncher.this.getConfig()) {
                    XMageLauncher.this.path = Utilities.getInstallPath();
                    XMageLauncher.this.textArea.append(XMageLauncher.this.messages.getString("folder") + XMageLauncher.this.path.getAbsolutePath() + "\n");
                    DownloadLauncherTask launcher = new DownloadLauncherTask(XMageLauncher.this.progressBar);
                    launcher.execute();
                }
            }
        });
    }

    private boolean getConfig() {
        String xmageConfig = Config.getXMageHome() + "/config.json";
        try {
            URL xmageUrl = new URL(xmageConfig);
            this.textArea.append(this.messages.getString("readingConfig") + xmageUrl.toString() + "\n");
            this.config = Utilities.readJsonFromUrl(xmageUrl);
            return true;
        }
        catch (IOException ex) {
            logger.error("Error reading config from " + xmageConfig, ex);
            this.textArea.append(this.messages.getString("readingConfig.error") + xmageConfig + "\n" + this.messages.getString("readingConfig.error.causes") + "\n");
        }
        catch (JSONException ex) {
            logger.error("Invalid config from " + xmageConfig, ex);
            this.textArea.append(this.messages.getString("invalidConfig") + xmageConfig + "\n");
        }
        this.enableButtons();
        return false;
    }

    private void checkJava() {
        try {
            String javaAvailableVersion = (String)this.config.getJSONObject("java").get("version");
            String javaInstalledVersion = Config.getInstalledJavaVersion();
            this.textArea.append(this.messages.getString("java.installed") + javaInstalledVersion + "\n");
            this.textArea.append(this.messages.getString("java.available") + javaAvailableVersion + "\n");
            this.noJava = false;
            this.newJava = false;
            if (this.compareVersions(javaAvailableVersion, javaInstalledVersion) > 0) {
                this.newJava = true;
                String javaMessage = "";
                String javaTitle = "";
                if (javaInstalledVersion.isEmpty()) {
                    this.noJava = true;
                    this.textArea.append(this.messages.getString("java.none") + "\n");
                    javaMessage = this.messages.getString("java.none.message");
                    javaTitle = this.messages.getString("java.none");
                } else {
                    this.textArea.append(this.messages.getString("java.new") + "\n");
                    javaMessage = this.messages.getString("java.new.message");
                    javaTitle = this.messages.getString("java.new");
                }
                JOptionPane.showMessageDialog(this.frame, javaMessage, javaTitle, 1);
            }
        }
        catch (JSONException ex) {
            logger.error("Error: ", ex);
        }
    }

    private void checkXMage(boolean silent) {
        try {
            String xmageAvailableVersion = (String)this.config.getJSONObject("XMage").get("version");
            String xmageInstalledVersion = Config.getInstalledXMageVersion();
            this.textArea.append(this.messages.getString("xmage.installed") + xmageInstalledVersion + "\n");
            this.textArea.append(this.messages.getString("xmage.available") + xmageAvailableVersion + "\n");
            this.noXMage = false;
            this.newXMage = false;
            this.downgradeXMage = false;
            int compared = this.compareVersions(xmageAvailableVersion, xmageInstalledVersion);
            if (compared > 0) {
                this.newXMage = true;
                String xmageMessage = "";
                String xmageTitle = "";
                if (xmageInstalledVersion.isEmpty()) {
                    this.noXMage = true;
                    this.textArea.append(this.messages.getString("xmage.none") + "\n");
                    xmageMessage = this.messages.getString("xmage.none.message");
                    xmageTitle = this.messages.getString("xmage.none");
                } else {
                    this.textArea.append(this.messages.getString("xmage.new") + "\n");
                    xmageMessage = this.messages.getString("xmage.new.message");
                    xmageTitle = this.messages.getString("xmage.new");
                }
                if (!(silent || this.noJava || this.noXMage)) {
                    JOptionPane.showMessageDialog(this.frame, xmageMessage, xmageTitle, 1);
                }
            }
            if (compared < 0) {
                this.downgradeXMage = true;
            }
        }
        catch (JSONException ex) {
            logger.error("Error: ", ex);
        }
    }

    private void enableButtons() {
        if (!this.noJava && !this.noXMage) {
            this.btnLaunchClient.setEnabled(true);
            this.btnLaunchClient.setForeground(Color.BLACK);
            this.btnLaunchClientServer.setEnabled(true);
            this.btnLaunchClientServer.setForeground(Color.BLACK);
            this.btnLaunchServer.setEnabled(true);
            this.btnLaunchServer.setForeground(Color.BLACK);
        }
        this.btnUpdate.setEnabled(true);
        this.btnUpdate.setForeground(Color.BLACK);
        this.btnCheck.setEnabled(true);
        this.btnCheck.setForeground(Color.BLACK);
    }

    private void disableButtons() {
        this.btnLaunchClient.setEnabled(false);
        this.btnLaunchClient.setForeground(Color.GRAY);
        this.btnLaunchClientServer.setEnabled(false);
        this.btnLaunchClientServer.setForeground(Color.GRAY);
        this.btnLaunchServer.setEnabled(false);
        this.btnLaunchServer.setForeground(Color.GRAY);
        this.btnUpdate.setEnabled(false);
        this.btnUpdate.setForeground(Color.GRAY);
        this.btnCheck.setEnabled(false);
        this.btnCheck.setForeground(Color.GRAY);
    }

    private int compareVersions(String ver1, String ver2) {
        DefaultArtifactVersion version1 = new DefaultArtifactVersion(ver1);
        DefaultArtifactVersion version2 = new DefaultArtifactVersion(ver2);
        return version1.compareTo(version2);
    }

    private void removeOldLauncherFiles() {
        String launcherInstalledVersion;
        File launcherFolder = new File(Utilities.getInstallPath().getAbsolutePath());
        File[] files = launcherFolder.listFiles(new FilenameFilter(launcherInstalledVersion = Config.getVersion()){
            final /* synthetic */ String val$launcherInstalledVersion;
            {
                this.val$launcherInstalledVersion = string;
            }

            @Override
            public boolean accept(File dir, String name) {
                if (name.matches("XMageLauncher.*\\.jar")) {
                    return !name.equals("XMageLauncher-" + this.val$launcherInstalledVersion + ".jar");
                }
                return false;
            }
        });
        if (files.length > 0) {
            this.textArea.append(this.messages.getString("removing") + "\n");
            for (File file : files) {
                if (file.isDirectory() || file.delete()) continue;
                logger.error("Can't remove " + file.getAbsolutePath());
            }
        }
    }

    private class TorrentXMageTask
    extends DownloadTask {
        public TorrentXMageTask(JProgressBar progressBar) {
            super(progressBar, XMageLauncher.this.textArea);
        }

        @Override
        protected Void doInBackground() {
            try {
                File xmageFolder = new File(XMageLauncher.this.path.getAbsolutePath() + File.separator + "xmage");
                String xmageAvailableVersion = (String)XMageLauncher.this.config.getJSONObject("XMage").get("version");
                String xmageRemoteLocation = (String)XMageLauncher.this.config.getJSONObject("XMage").get("torrent");
                URL xmage = new URL(xmageRemoteLocation);
                this.publish(XMageLauncher.this.messages.getString("xmage.downloading") + xmage.toString() + "\n");
                boolean result = this.download(xmage, XMageLauncher.this.path.getAbsolutePath(), "");
                if (result) {
                    if (xmageFolder.isDirectory()) {
                        this.publish(XMageLauncher.this.messages.getString("removing") + "\n");
                        this.removeXMageFiles(xmageFolder);
                    }
                    xmageFolder.mkdirs();
                    File from = new File(XMageLauncher.this.path.getAbsolutePath() + File.separator + "xmage.dl");
                    this.torrent(from, xmageFolder);
                    this.publish(XMageLauncher.this.messages.getString("xmage.installing"));
                    this.unzip(from, xmageFolder);
                    this.publish(XMageLauncher.this.messages.getString("done") + "\n");
                    this.publish(0);
                    if (!from.delete()) {
                        this.publish(XMageLauncher.this.messages.getString("error.cleanup") + "\n");
                        logger.error("Error: could not cleanup temporary files");
                    }
                    Config.setInstalledXMageVersion(xmageAvailableVersion);
                    Config.saveProperties();
                }
            }
            catch (IOException ex) {
                this.publish(0);
                this.cancel(true);
                logger.error("Error: ", ex);
            }
            catch (JSONException ex) {
                this.publish(0);
                this.cancel(true);
                logger.error("Error: ", ex);
            }
            return null;
        }

        private void removeXMageFiles(File xmageFolder) {
            File[] files;
            for (File file : files = xmageFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return !name.matches("images|gameLogs|backgrounds|mageclient\\.log|mageserver\\.log|.*\\.dck");
                }
            })) {
                if (file.isDirectory()) {
                    this.removeXMageFiles(file);
                    continue;
                }
                if (file.delete()) continue;
                logger.error("Can't remove " + file.getAbsolutePath());
            }
        }

        @Override
        public void done() {
            XMageLauncher.this.enableButtons();
        }
    }

    private class UpdateTask
    extends DownloadTask {
        private final boolean force;

        public UpdateTask(JProgressBar progressBar, boolean force) {
            super(progressBar, XMageLauncher.this.textArea);
            this.force = force;
        }

        @Override
        protected Void doInBackground() {
            if (!XMageLauncher.this.downgradeXMage && (this.force || XMageLauncher.this.noJava || XMageLauncher.this.newJava)) {
                this.updateJava();
            }
            if (this.force || XMageLauncher.this.noXMage || XMageLauncher.this.newXMage) {
                this.updateXMage();
            }
            return null;
        }

        private boolean updateJava() {
            try {
                XMageLauncher.this.disableButtons();
                File javaFolder = new File(XMageLauncher.this.path.getAbsolutePath() + File.separator + "java");
                String javaAvailableVersion = (String)XMageLauncher.this.config.getJSONObject("java").get("version");
                if (javaFolder.isDirectory()) {
                    this.publish(XMageLauncher.this.messages.getString("removing") + "\n");
                    this.removeJavaFiles(javaFolder);
                }
                javaFolder.mkdirs();
                String javaRemoteLocation = (String)XMageLauncher.this.config.getJSONObject("java").get("location");
                URL java = new URL(javaRemoteLocation + Utilities.getOSandArch() + ".tar.gz");
                this.publish(XMageLauncher.this.messages.getString("java.downloading") + java.toString() + "\n");
                this.download(java, XMageLauncher.this.path.getAbsolutePath(), "oraclelicense=accept-securebackup-cookie");
                File from = new File(XMageLauncher.this.path.getAbsolutePath() + File.separator + "xmage.dl");
                this.publish(XMageLauncher.this.messages.getString("java.installing"));
                this.extract(from, javaFolder);
                this.publish(XMageLauncher.this.messages.getString("done") + "\n");
                this.publish(0);
                if (!from.delete()) {
                    this.publish(XMageLauncher.this.messages.getString("error.cleanup") + "\n");
                    logger.error("Error: could not cleanup temporary files");
                }
                Config.setInstalledJavaVersion(javaAvailableVersion);
                Config.saveProperties();
                return true;
            }
            catch (IOException ex) {
                this.publish(0);
                this.cancel(true);
                logger.error("Error: ", ex);
            }
            catch (JSONException ex) {
                this.publish(0);
                this.cancel(true);
                logger.error("Error: ", ex);
            }
            return false;
        }

        private boolean updateXMage() {
            try {
                XMageLauncher.this.disableButtons();
                File xmageFolder = new File(XMageLauncher.this.path.getAbsolutePath() + File.separator + "xmage");
                String xmageAvailableVersion = (String)XMageLauncher.this.config.getJSONObject("XMage").get("version");
                String[] otherLocations = new String[]{};
                String xmageRemoteLocation = (String)XMageLauncher.this.config.getJSONObject("XMage").get("location");
                JSONArray arr = (JSONArray)XMageLauncher.this.config.getJSONObject("XMage").get("locations");
                otherLocations = new String[arr.length()];
                for (int i = 0; i < arr.length(); ++i) {
                    otherLocations[i] = (String)arr.get(i);
                }
                URL xmage = new URL(xmageRemoteLocation);
                this.publish(XMageLauncher.this.messages.getString("xmage.downloading") + xmage.toString() + "\n");
                boolean result = this.download(xmage, XMageLauncher.this.path.getAbsolutePath(), "");
                for (int altCount = 0; !result && altCount <= otherLocations.length; ++altCount) {
                    this.publish(XMageLauncher.this.messages.getString("xmage.downloading.failed") + xmage.toString() + "\n");
                    xmage = new URL(otherLocations[altCount]);
                    this.publish(XMageLauncher.this.messages.getString("xmage.downloading") + xmage.toString() + "\n");
                    result = this.download(xmage, XMageLauncher.this.path.getAbsolutePath(), "");
                }
                if (result) {
                    if (xmageFolder.isDirectory()) {
                        this.publish(XMageLauncher.this.messages.getString("removing") + "\n");
                        this.removeXMageFiles(xmageFolder);
                    }
                    xmageFolder.mkdirs();
                    File from = new File(XMageLauncher.this.path.getAbsolutePath() + File.separator + "xmage.dl");
                    this.publish(XMageLauncher.this.messages.getString("xmage.installing"));
                    this.unzip(from, xmageFolder);
                    this.publish(XMageLauncher.this.messages.getString("done") + "\n");
                    this.publish(0);
                    if (!from.delete()) {
                        this.publish(XMageLauncher.this.messages.getString("error.cleanup") + "\n");
                        logger.error("Error: could not cleanup temporary files");
                    }
                    Config.setInstalledXMageVersion(xmageAvailableVersion);
                    Config.saveProperties();
                    return true;
                }
            }
            catch (IOException ex) {
                this.publish(0);
                this.cancel(true);
                logger.error("Error: ", ex);
            }
            catch (JSONException ex) {
                this.publish(0);
                this.cancel(true);
                logger.error("Error: ", ex);
            }
            return false;
        }

        private void removeJavaFiles(File javaFolder) {
            File[] files;
            for (File file : files = javaFolder.listFiles()) {
                if (file.isDirectory()) {
                    this.removeJavaFiles(file);
                }
                if (file.delete()) continue;
                logger.error("Can't remove " + file.getAbsolutePath());
            }
        }

        private void removeXMageFiles(File xmageFolder) {
            File[] files;
            for (File file : files = xmageFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return !name.matches("images|gameLogs|backgrounds|mageclient\\.log|mageserver\\.log|.*\\.dck");
                }
            })) {
                if (file.isDirectory()) {
                    this.removeXMageFiles(file);
                    continue;
                }
                if (file.delete()) continue;
                logger.error("Can't remove " + file.getAbsolutePath());
            }
        }

        @Override
        public void done() {
            XMageLauncher.this.checkUpdates();
        }
    }

    private class DownloadLauncherTask
    extends DownloadTask {
        public DownloadLauncherTask(JProgressBar progressBar) {
            super(progressBar, XMageLauncher.this.textArea);
        }

        @Override
        protected Void doInBackground() {
            try {
                File launcherFolder = new File(XMageLauncher.this.path.getAbsolutePath());
                String launcherAvailableVersion = (String)XMageLauncher.this.config.getJSONObject("XMage").getJSONObject("Launcher").get("version");
                String launcherInstalledVersion = Config.getVersion();
                this.publish(XMageLauncher.this.messages.getString("xmage.launcher.installed") + launcherInstalledVersion + "\n");
                this.publish(XMageLauncher.this.messages.getString("xmage.launcher.available") + launcherAvailableVersion + "\n");
                if (XMageLauncher.this.compareVersions(launcherAvailableVersion, launcherInstalledVersion) > 0) {
                    String launcherMessage = "";
                    String launcherTitle = "";
                    this.publish(XMageLauncher.this.messages.getString("xmage.launcher.new") + "\n");
                    launcherMessage = XMageLauncher.this.messages.getString("xmage.launcher.new.message");
                    launcherTitle = XMageLauncher.this.messages.getString("xmage.launcher.new");
                    int response = JOptionPane.showConfirmDialog(XMageLauncher.this.frame, "<html>" + launcherMessage + "  " + XMageLauncher.this.messages.getString("installNow") + "</html>", launcherTitle, 0);
                    if (response == 0) {
                        String launcherRemoteLocation = (String)XMageLauncher.this.config.getJSONObject("XMage").getJSONObject("Launcher").get("location");
                        URL launcher = new URL(launcherRemoteLocation);
                        this.publish(XMageLauncher.this.messages.getString("xmage.launcher.downloading") + launcher.toString() + "\n");
                        this.download(launcher, XMageLauncher.this.path.getAbsolutePath(), "");
                        File from = new File(XMageLauncher.this.path.getAbsolutePath() + File.separator + "xmage.dl");
                        this.publish(XMageLauncher.this.messages.getString("xmage.launcher.installing"));
                        File to = new File(launcherFolder, "XMageLauncher-" + launcherAvailableVersion + ".jar");
                        from.renameTo(to);
                        this.publish(XMageLauncher.this.messages.getString("done") + "\n");
                        this.publish(0);
                        JOptionPane.showMessageDialog(XMageLauncher.this.frame, "<html>" + XMageLauncher.this.messages.getString("restartMessage") + "</html>", XMageLauncher.this.messages.getString("restartTitle"), 2);
                        Utilities.restart(to);
                    }
                }
            }
            catch (IOException ex) {
                this.publish(0);
                this.cancel(true);
                logger.error("Error: ", ex);
            }
            catch (JSONException ex) {
                this.publish(0);
                this.cancel(true);
                logger.error("Error: ", ex);
            }
            return null;
        }

        @Override
        public void done() {
            XMageLauncher.this.checkUpdates();
            if (XMageLauncher.this.noJava && XMageLauncher.this.noXMage) {
                UpdateTask update = new UpdateTask(XMageLauncher.this.progressBar, false);
                update.execute();
            }
        }
    }
}

