/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.sslbisocket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.socketfactory.SocketFactoryWrapper;
import org.jboss.remoting.transport.bisocket.BisocketServerInvoker;
import org.jboss.remoting.transport.sslsocket.SSLSocketServerInvokerMBean;

public class SSLBisocketServerInvoker
extends BisocketServerInvoker
implements SSLSocketServerInvokerMBean {
    private static final Logger log = Logger.getLogger((Class)SSLBisocketServerInvoker.class);
    protected String[] enabledCipherSuites;
    protected String[] enabledProtocols;
    protected boolean enableSessionCreation = true;

    public SSLBisocketServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public SSLBisocketServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    protected ServerSocketFactory getDefaultServerSocketFactory() {
        return SSLServerSocketFactory.getDefault();
    }

    public void setOOBInline(boolean inline) {
        log.warn((Object)"Ignored: sending urgent data is not supported by SSLSockets");
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public boolean isEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public void setEnableSessionCreation(boolean enableSessionCreation) {
        this.enableSessionCreation = enableSessionCreation;
    }

    protected ServerSocketFactory createServerSocketFactory() throws IOException {
        if (this.isCallbackServer) {
            return null;
        }
        return super.createServerSocketFactory();
    }

    protected void setup() throws Exception {
        super.setup();
        Object o = this.configuration.get("enabledCipherSuites");
        if (o instanceof String[]) {
            this.setEnabledCipherSuites((String[])o);
        }
        if ((o = this.configuration.get("enabledProtocols")) instanceof String[]) {
            this.setEnabledProtocols((String[])o);
        }
    }

    protected SocketFactory createSocketFactory(Map configuration) {
        SocketFactory sf = super.createSocketFactory(configuration);
        if (SSLBisocketServerInvoker.isCompleteSocketFactory(sf)) {
            return sf;
        }
        SocketFactory wrapper = sf;
        try {
            SSLSocketBuilder server = new SSLSocketBuilder(configuration);
            sf = server.createSSLSocketFactory();
        }
        catch (Exception e) {
            log.error((Object)("Error creating SSL Socket Factory for client invoker: " + e.getMessage()));
            log.debug((Object)"Error creating SSL Socket Factory for client invoker.", (Throwable)e);
        }
        if (wrapper != null) {
            ((SocketFactoryWrapper)((Object)wrapper)).setSocketFactory(sf);
            return wrapper;
        }
        return sf;
    }

    protected void configureServerSocket(ServerSocket ss) throws SocketException {
        super.configureServerSocket(ss);
        if (ss instanceof SSLServerSocket) {
            SSLServerSocket sss = (SSLServerSocket)ss;
            if (this.enabledCipherSuites != null) {
                sss.setEnabledCipherSuites(this.enabledCipherSuites);
            }
            if (this.enabledProtocols != null) {
                sss.setEnabledProtocols(this.enabledProtocols);
            }
            sss.setEnableSessionCreation(this.enableSessionCreation);
        }
    }
}

