/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.counter;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import mage.interfaces.PluginException;
import mage.interfaces.plugin.CounterPlugin;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import net.xeoh.plugins.base.annotations.events.Init;
import net.xeoh.plugins.base.annotations.events.PluginLoaded;
import net.xeoh.plugins.base.annotations.meta.Author;
import org.apache.log4j.Logger;
import org.mage.plugins.counter.CounterBean;

@PluginImplementation
@Author(name="nantuko")
public class CounterPluginImpl
implements CounterPlugin {
    private static final String PLUGIN_DATA_FOLDER_PATH = "plugins" + File.separator + "plugin.data" + File.separator + "counters";
    private static final String DATA_STORAGE_FILE = "counters";
    private static final Logger log = Logger.getLogger(CounterPluginImpl.class);
    private boolean isLoaded = false;

    @Init
    public void init() {
        File data;
        File dataFolder = new File(PLUGIN_DATA_FOLDER_PATH);
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
            if (!dataFolder.exists()) {
                throw new RuntimeException("CounterPluginImpl: Couldn't create folders: " + PLUGIN_DATA_FOLDER_PATH);
            }
        }
        if (!(data = new File(PLUGIN_DATA_FOLDER_PATH + File.separator + DATA_STORAGE_FILE)).exists()) {
            try {
                data.getParentFile().mkdirs();
                data.createNewFile();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new RuntimeException("Couldn't create data file for counter plugin: " + e.getMessage());
            }
        }
        this.isLoaded = true;
    }

    @PluginLoaded
    public void newPlugin(CounterPlugin plugin) {
        log.info((Object)(plugin.toString() + " has been loaded."));
    }

    public String toString() {
        return "[Game counter plugin, version 0.1]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGamePlayed() throws PluginException {
        block37: {
            if (!this.isLoaded) {
                return;
            }
            File data = new File(PLUGIN_DATA_FOLDER_PATH + File.separator + DATA_STORAGE_FILE);
            if (data.exists()) {
                CounterBean c;
                Throwable throwable;
                int prev = 0;
                try {
                    throwable = null;
                    try (ObjectInputStream ois = new ObjectInputStream(Files.newInputStream(data.toPath(), new OpenOption[0]));){
                        Object o = ois.readObject();
                        if (o instanceof CounterBean) {
                            c = (CounterBean)o;
                            prev = c.getGamesPlayed();
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (EOFException ois) {
                }
                catch (IOException e) {
                    throw new PluginException((Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    throw new PluginException((Throwable)e);
                }
                try {
                    throwable = null;
                    try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(data));){
                        CounterPluginImpl counterPluginImpl = this;
                        synchronized (counterPluginImpl) {
                            c = new CounterBean();
                            c.setGamesPlayed(prev + 1);
                            oos.writeObject(c);
                            oos.close();
                            break block37;
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (IOException e) {
                    throw new PluginException((Throwable)e);
                }
            }
            log.error((Object)"Counter plugin: data file doesn't exist, please restart plugin.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public int getGamePlayed() throws PluginException {
        if (!this.isLoaded) {
            return -1;
        }
        File data = new File(PLUGIN_DATA_FOLDER_PATH + File.separator + DATA_STORAGE_FILE);
        if (!data.exists()) {
            return 0;
        }
        if (data.exists()) {
            try {
                Throwable throwable = null;
                try (ObjectInputStream ois = new ObjectInputStream(Files.newInputStream(data.toPath(), new OpenOption[0]));){
                    CounterPluginImpl counterPluginImpl = this;
                    synchronized (counterPluginImpl) {
                        try {
                            Object o = ois.readObject();
                            CounterBean c = null;
                            if (o instanceof CounterBean) {
                                c = (CounterBean)o;
                            }
                            ois.close();
                            int n = c == null ? 0 : c.getGamesPlayed();
                            return n;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throw throwable2;
                            }
                            catch (Throwable throwable22) {
                                throwable = throwable22;
                                throw throwable22;
                            }
                        }
                    }
                }
            }
            catch (EOFException e) {
                return 0;
            }
            catch (IOException e) {
                throw new PluginException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new PluginException((Throwable)e);
            }
        }
        log.error((Object)"Counter plugin: data file doesn't exist, please restart plugin.");
        return 0;
    }
}

