/*
 * Decompiled with CFR 0.152.
 */
package mage.game;

import mage.game.Game;
import mage.game.GameException;
import mage.game.TwoPlayerDuel;
import mage.game.match.MatchImpl;
import mage.game.match.MatchOptions;
import mage.game.mulligan.Mulligan;

public class TwoPlayerMatch
extends MatchImpl {
    public TwoPlayerMatch(MatchOptions options) {
        super(options);
    }

    public void startGame() throws GameException {
        Mulligan mulligan = this.options.getMulliganType().getMulligan(this.options.getFreeMulligans());
        boolean isLimitedDeck = this.options.isLimited() || "Limited".equals(this.options.getDeckType());
        int startLife = this.options.isCustomStartLifeEnabled() ? this.options.getCustomStartLife() : 20;
        int startHandSize = this.options.isCustomStartHandSizeEnabled() ? this.options.getCustomStartHandSize() : 7;
        TwoPlayerDuel game = new TwoPlayerDuel(this.options.getAttackOption(), this.options.getRange(), mulligan, isLimitedDeck ? 40 : 60, startLife, startHandSize);
        game.setStartMessage(this.createGameStartMessage());
        this.initGame((Game)game);
        this.games.add(game);
    }
}

