/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.InputSocket;
import net.java.truecommons.cio.OutputSocket;
import net.java.truecommons.shed.BitField;
import net.java.truecommons.shed.FilteringIterator;
import net.java.truevfs.access.TConfig;
import net.java.truevfs.access.TFileSystemProvider;
import net.java.truevfs.access.TPath;
import net.java.truevfs.access.TVFS;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsCompositeDriver;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsMountPoint;
import net.java.truevfs.kernel.spec.FsNode;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsSyncException;
import net.java.truevfs.kernel.spec.FsSyncOption;
import net.java.truevfs.kernel.spec.FsSyncOptions;
import net.java.truevfs.kernel.spec.FsSyncWarningException;

@ThreadSafe
public final class TFileSystem
extends FileSystem {
    private final FsController controller;
    private final TFileSystemProvider provider;

    TFileSystem(TPath path) {
        assert (null != path);
        this.controller = TConfig.current().getManager().controller((FsCompositeDriver)path.getArchiveDetector(), path.getMountPoint());
        this.provider = TFileSystemProvider.get(path.getName());
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (null != this.getController());
        assert (null != this.provider());
        return true;
    }

    private FsController getController() {
        return this.controller;
    }

    FsMountPoint getMountPoint() {
        return this.getController().getModel().getMountPoint();
    }

    @Override
    public TFileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() throws FsSyncWarningException, FsSyncException {
        this.sync((BitField<FsSyncOption>)FsSyncOptions.UMOUNT);
    }

    public void sync(BitField<FsSyncOption> options) throws FsSyncWarningException, FsSyncException {
        TVFS.sync(this.getMountPoint(), options);
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return File.separator;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Collections.singleton(new TPath(this.getMountPoint().toHierarchicalUri().resolve("/")));
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return Collections.singleton("basic");
    }

    @Override
    public TPath getPath(String first, String ... more) {
        return new TPath(this, first, more);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    SeekableByteChannel newByteChannel(TPath path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        FsNodeName name = path.getNodeName();
        FsController controller = this.getController();
        if (options.isEmpty() || options.contains(StandardOpenOption.READ)) {
            BitField o = path.inputOptions(options).set((Enum)FsAccessOption.CACHE);
            return controller.input(o, name).channel(null);
        }
        BitField o = path.outputOptions(options).set((Enum)FsAccessOption.CACHE);
        try {
            return controller.output(o, name, null).channel(null);
        }
        catch (IOException ex) {
            if (o.get((Enum)FsAccessOption.EXCLUSIVE) && null != controller.node(o, name)) {
                throw (IOException)new FileAlreadyExistsException(path.toString()).initCause(ex);
            }
            throw ex;
        }
    }

    InputStream newInputStream(TPath path, OpenOption ... options) throws IOException {
        return this.getController().input(path.inputOptions(options), path.getNodeName()).stream(null);
    }

    OutputStream newOutputStream(TPath path, OpenOption ... options) throws IOException {
        return this.getController().output(path.outputOptions(options), path.getNodeName(), null).stream(null);
    }

    DirectoryStream<Path> newDirectoryStream(final TPath path, final DirectoryStream.Filter<? super Path> filter) throws IOException {
        Set set;
        FsNode entry = this.stat(path);
        if (null == entry || null == (set = entry.getMembers())) {
            throw new NotDirectoryException(path.toString());
        }
        @NotThreadSafe
        class FilterIterator
        extends FilteringIterator<Path> {
            FilterIterator() {
                @NotThreadSafe
                class Adapter
                implements Iterator<Path> {
                    final Iterator<String> it;
                    final /* synthetic */ Set val$set;
                    final /* synthetic */ TPath val$path;

                    Adapter() {
                        this.val$set = set;
                        this.val$path = tPath;
                        this.it = this.val$set.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Path next() {
                        return this.val$path.resolve(this.it.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                }
                super((Iterator)new Adapter(TFileSystem.this, set2, tPath));
            }

            protected boolean accept(Path element) {
                try {
                    return filter.accept(element);
                }
                catch (IOException ex) {
                    throw new DirectoryIteratorException(ex);
                }
            }
        }
        return new Stream((Iterator<Path>)((Object)new FilterIterator()));
    }

    void createDirectory(TPath path, FileAttribute<?> ... attrs) throws IOException {
        if (0 < attrs.length) {
            throw new UnsupportedOperationException();
        }
        FsController controller = this.getController();
        FsNodeName name = path.getNodeName();
        BitField<FsAccessOption> options = path.getAccessPreferences();
        try {
            controller.make(options, name, Entry.Type.DIRECTORY, null);
        }
        catch (IOException ex) {
            if (null != controller.node(options, name)) {
                throw (IOException)new FileAlreadyExistsException(path.toString()).initCause(ex);
            }
            throw ex;
        }
    }

    void delete(TPath path) throws IOException {
        this.getController().unlink(path.getAccessPreferences(), path.getNodeName());
    }

    FsNode stat(TPath path) throws IOException {
        return this.getController().node(path.getAccessPreferences(), path.getNodeName());
    }

    InputSocket<?> input(TPath path, BitField<FsAccessOption> options) {
        return this.getController().input(options, path.getNodeName());
    }

    OutputSocket<?> output(TPath path, BitField<FsAccessOption> options, @CheckForNull Entry template) {
        return this.getController().output(options, path.getNodeName(), template);
    }

    void checkAccess(TPath path, AccessMode ... modes) throws IOException {
        FsNodeName name = path.getNodeName();
        BitField<FsAccessOption> options = path.getAccessPreferences();
        BitField<Entry.Access> types = TFileSystem.types(modes);
        this.getController().checkAccess(options, name, types);
    }

    private static BitField<Entry.Access> types(AccessMode ... modes) {
        EnumSet<Entry.Access> access = EnumSet.noneOf(Entry.Access.class);
        block5: for (AccessMode mode : modes) {
            switch (mode) {
                case READ: {
                    access.add(Entry.Access.READ);
                    continue block5;
                }
                case WRITE: {
                    access.add(Entry.Access.WRITE);
                    continue block5;
                }
                case EXECUTE: {
                    access.add(Entry.Access.EXECUTE);
                }
            }
        }
        return BitField.copyOf(access);
    }

    @Nullable
    <V extends FileAttributeView> V getFileAttributeView(TPath path, Class<V> type, LinkOption ... options) {
        if (type.isAssignableFrom(BasicFileAttributeView.class)) {
            return (V)((FileAttributeView)type.cast(new FsNodeAttributeView(path)));
        }
        return null;
    }

    <A extends BasicFileAttributes> A readAttributes(TPath path, Class<A> type, LinkOption ... options) throws IOException {
        if (type.isAssignableFrom(BasicFileAttributes.class)) {
            return (A)((BasicFileAttributes)type.cast(new FsNodeAttributes(path)));
        }
        throw new UnsupportedOperationException();
    }

    private final class FsNodeAttributes
    implements BasicFileAttributes {
        private final FsNode entry;

        FsNodeAttributes(TPath path) throws IOException {
            this.entry = TFileSystem.this.getController().node(path.getAccessPreferences(), path.getNodeName());
            if (null == this.entry) {
                throw new NoSuchFileException(path.toString());
            }
        }

        @Override
        public FileTime lastModifiedTime() {
            return FileTime.fromMillis(this.entry.getTime(Entry.Access.WRITE));
        }

        @Override
        public FileTime lastAccessTime() {
            return FileTime.fromMillis(this.entry.getTime(Entry.Access.READ));
        }

        @Override
        public FileTime creationTime() {
            return FileTime.fromMillis(this.entry.getTime(Entry.Access.CREATE));
        }

        @Override
        public boolean isRegularFile() {
            return this.entry.isType(Entry.Type.FILE);
        }

        @Override
        public boolean isDirectory() {
            return this.entry.isType(Entry.Type.DIRECTORY);
        }

        @Override
        public boolean isSymbolicLink() {
            return this.entry.isType(Entry.Type.SYMLINK);
        }

        @Override
        public boolean isOther() {
            return this.entry.isType(Entry.Type.SPECIAL);
        }

        @Override
        public long size() {
            long size = this.entry.getSize(Entry.Size.DATA);
            return -1L == size ? 0L : size;
        }

        @Override
        public Object fileKey() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private final class FsNodeAttributeView
    implements BasicFileAttributeView {
        private final TPath path;

        FsNodeAttributeView(TPath path) {
            this.path = path;
        }

        @Override
        public String name() {
            return "basic";
        }

        @Override
        public BasicFileAttributes readAttributes() throws IOException {
            return new FsNodeAttributes(this.path);
        }

        @Override
        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
            FsController controller = TFileSystem.this.getController();
            EnumMap<Entry.Access, Long> times = new EnumMap<Entry.Access, Long>(Entry.Access.class);
            if (null != lastModifiedTime) {
                times.put(Entry.Access.WRITE, lastModifiedTime.toMillis());
            }
            if (null != lastAccessTime) {
                times.put(Entry.Access.READ, lastAccessTime.toMillis());
            }
            if (null != createTime) {
                times.put(Entry.Access.CREATE, createTime.toMillis());
            }
            controller.setTime(this.path.getAccessPreferences(), this.path.getNodeName(), times);
        }
    }

    @NotThreadSafe
    private static final class Stream
    implements DirectoryStream<Path> {
        final Iterator<Path> it;
        boolean consumed;

        Stream(Iterator<Path> it) {
            this.it = it;
        }

        @Override
        public Iterator<Path> iterator() {
            if (this.consumed) {
                throw new IllegalStateException();
            }
            this.consumed = true;
            return this.it;
        }

        @Override
        public void close() {
            this.consumed = true;
        }
    }
}

