/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zipdriver;

import java.net.URI;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.key.spec.KeyManager;
import net.java.truecommons.key.spec.KeyProvider;
import net.java.truecommons.key.spec.KeyStrength;
import net.java.truecommons.key.spec.UnknownKeyException;
import net.java.truecommons.key.spec.common.AesKeyStrength;
import net.java.truecommons.key.spec.common.AesPbeParameters;
import net.java.truevfs.comp.zip.WinZipAesParameters;
import net.java.truevfs.comp.zip.ZipCryptoParameters;
import net.java.truevfs.comp.zip.ZipKeyException;
import net.java.truevfs.comp.zip.ZipParameters;
import net.java.truevfs.comp.zip.ZipParametersProvider;
import net.java.truevfs.comp.zipdriver.AbstractZipDriver;
import net.java.truevfs.kernel.spec.FsModel;
import org.bouncycastle.crypto.PBEParametersGenerator;

@ThreadSafe
public class KeyManagerZipCryptoParameters
implements ZipParametersProvider,
ZipCryptoParameters {
    private final AbstractZipDriver<?> driver;
    private final FsModel model;
    protected final Charset charset;

    public KeyManagerZipCryptoParameters(AbstractZipDriver<?> driver, FsModel model, Charset charset) {
        this.driver = Objects.requireNonNull(driver);
        this.model = Objects.requireNonNull(model);
        this.charset = Objects.requireNonNull(charset);
    }

    public <P extends ZipParameters> P get(Class<P> type) {
        if (type.isAssignableFrom(WinZipAesParameters.class)) {
            return (P)((ZipParameters)type.cast(new WinZipAes()));
        }
        return null;
    }

    protected byte[] password(char[] characters, String name) {
        return PBEParametersGenerator.PKCS5PasswordToBytes((char[])characters);
    }

    private <K> KeyManager<K> keyManager(Class<K> type) {
        return this.driver.getKeyManagerMap().manager(type);
    }

    private URI resourceUri(String name) {
        return this.driver.fileSystemUri(this.model, name);
    }

    private class WinZipAes
    implements WinZipAesParameters {
        final KeyManager<AesPbeParameters> manager;

        private WinZipAes() {
            this.manager = KeyManagerZipCryptoParameters.this.keyManager(AesPbeParameters.class);
        }

        public byte[] getWritePassword(String name) throws ZipKeyException {
            KeyProvider provider = this.manager.provider(KeyManagerZipCryptoParameters.this.resourceUri(name));
            try {
                return KeyManagerZipCryptoParameters.this.password(((AesPbeParameters)provider.getKeyForWriting()).getPassword(), name);
            }
            catch (UnknownKeyException ex) {
                throw new ZipKeyException((Throwable)ex);
            }
        }

        public byte[] getReadPassword(String name, boolean invalid) throws ZipKeyException {
            KeyProvider provider = this.manager.provider(KeyManagerZipCryptoParameters.this.resourceUri(name));
            try {
                return KeyManagerZipCryptoParameters.this.password(((AesPbeParameters)provider.getKeyForReading(invalid)).getPassword(), name);
            }
            catch (UnknownKeyException ex) {
                throw new ZipKeyException((Throwable)ex);
            }
        }

        public AesKeyStrength getKeyStrength(String name) throws ZipKeyException {
            KeyProvider provider = this.manager.provider(KeyManagerZipCryptoParameters.this.resourceUri(name));
            try {
                return (AesKeyStrength)((AesPbeParameters)provider.getKeyForWriting()).getKeyStrength();
            }
            catch (UnknownKeyException ex) {
                throw new ZipKeyException((Throwable)ex);
            }
        }

        public void setKeyStrength(String name, AesKeyStrength keyStrength) throws ZipKeyException {
            AesPbeParameters param;
            KeyProvider provider = this.manager.provider(KeyManagerZipCryptoParameters.this.resourceUri(name));
            try {
                param = (AesPbeParameters)provider.getKeyForReading(false);
            }
            catch (UnknownKeyException ex) {
                throw new ZipKeyException((Throwable)ex);
            }
            param.setKeyStrength((KeyStrength)keyStrength);
            provider.setKey((Object)param);
        }
    }
}

