/*
 * Decompiled with CFR 0.152.
 */
package mage;

import java.io.Serializable;
import java.util.Objects;
import mage.util.CardUtil;
import mage.util.Copyable;

public class MageInt
implements Serializable,
Copyable<MageInt> {
    public static final MageInt EmptyMageInt = new MageInt(Integer.MIN_VALUE, ""){
        private static final String exceptionMessage = "MageInt.EmptyMageInt can't be modified.";

        @Override
        public void increaseBoostedValue(int amount) {
            throw new RuntimeException(exceptionMessage);
        }

        @Override
        public void setBoostedValue(int value) {
            throw new RuntimeException(exceptionMessage);
        }
    };
    protected final int baseValue;
    protected int modifiedBaseValue;
    protected int boostedValue;
    protected String cardValue;

    public MageInt(int value) {
        this(value, Integer.toString(value));
    }

    public MageInt(int baseValue, String cardValue) {
        this.modifiedBaseValue = this.baseValue = baseValue;
        this.boostedValue = this.baseValue;
        this.cardValue = cardValue;
    }

    public MageInt(int baseValue, int baseValueModified, int boostedValue, String cardValue) {
        this.baseValue = baseValue;
        this.modifiedBaseValue = baseValueModified;
        this.boostedValue = boostedValue;
        this.cardValue = cardValue;
    }

    @Override
    public MageInt copy() {
        if (Objects.equals(this, EmptyMageInt)) {
            return this;
        }
        return new MageInt(this.baseValue, this.modifiedBaseValue, this.boostedValue, this.cardValue);
    }

    public int getBaseValue() {
        return this.baseValue;
    }

    public int getModifiedBaseValue() {
        return this.modifiedBaseValue;
    }

    public int getValue() {
        return this.boostedValue;
    }

    public void setModifiedBaseValue(int value) {
        this.modifiedBaseValue = value;
        this.boostedValue = value;
        this.cardValue = Integer.toString(value);
    }

    public void setBoostedValue(int value) {
        this.boostedValue = value;
    }

    public void increaseBoostedValue(int amount) {
        this.boostedValue = CardUtil.overflowInc(this.boostedValue, amount);
    }

    public void resetToBaseValue() {
        this.setModifiedBaseValue(this.baseValue);
    }

    public String toString() {
        return this.cardValue;
    }
}

