/*
 * Decompiled with CFR 0.152.
 */
package mage;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import mage.ConditionalMana;
import mage.abilities.condition.Condition;
import mage.constants.ColoredManaSymbol;
import mage.constants.ManaType;
import mage.filter.FilterMana;
import mage.util.CardUtil;
import mage.util.Copyable;
import org.apache.log4j.Logger;

public class Mana
implements Comparable<Mana>,
Serializable,
Copyable<Mana> {
    private static final Logger logger = Logger.getLogger(Mana.class);
    protected int white;
    protected int blue;
    protected int black;
    protected int red;
    protected int green;
    protected int generic;
    protected int colorless;
    protected int any;
    protected boolean flag;
    private static final Map<String, String> colorLetterMap = new HashMap<String, String>();

    public Mana() {
        this.white = 0;
        this.blue = 0;
        this.black = 0;
        this.red = 0;
        this.green = 0;
        this.generic = 0;
        this.colorless = 0;
        this.any = 0;
        this.flag = false;
    }

    public Mana(int white, int blue, int black, int red, int green, int generic, int any, int colorless) {
        this.white = Mana.notNegative(white, "White");
        this.blue = Mana.notNegative(blue, "Blue");
        this.black = Mana.notNegative(black, "Black");
        this.red = Mana.notNegative(red, "Red");
        this.green = Mana.notNegative(green, "Green");
        this.generic = Mana.notNegative(generic, "Generic");
        this.colorless = Mana.notNegative(colorless, "Colorless");
        this.any = Mana.notNegative(any, "Any");
        this.flag = false;
    }

    protected Mana(Mana mana) {
        Objects.requireNonNull(mana, "The passed in mana can not be null");
        this.white = mana.white;
        this.blue = mana.blue;
        this.black = mana.black;
        this.red = mana.red;
        this.green = mana.green;
        this.generic = mana.generic;
        this.colorless = mana.colorless;
        this.any = mana.any;
        this.flag = mana.flag;
    }

    public Mana(ColoredManaSymbol color) {
        this(color, 1);
    }

    public Mana(ColoredManaSymbol color, int amount) {
        this();
        Objects.requireNonNull(color, "The passed in ColoredManaSymbol can not be null");
        switch (color) {
            case W: {
                this.white = CardUtil.overflowInc(this.white, amount);
                break;
            }
            case U: {
                this.blue = CardUtil.overflowInc(this.blue, amount);
                break;
            }
            case B: {
                this.black = CardUtil.overflowInc(this.black, amount);
                break;
            }
            case R: {
                this.red = CardUtil.overflowInc(this.red, amount);
                break;
            }
            case G: {
                this.green = CardUtil.overflowInc(this.green, amount);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mana color: " + (Object)((Object)color));
            }
        }
    }

    public Mana(ManaType manaType) {
        this();
        Objects.requireNonNull(manaType, "The passed in ManaType can not be null");
        switch (manaType) {
            case WHITE: {
                this.white = CardUtil.overflowInc(this.white, 1);
                break;
            }
            case BLUE: {
                this.blue = CardUtil.overflowInc(this.blue, 1);
                break;
            }
            case BLACK: {
                this.black = CardUtil.overflowInc(this.black, 1);
                break;
            }
            case RED: {
                this.red = CardUtil.overflowInc(this.red, 1);
                break;
            }
            case GREEN: {
                this.green = CardUtil.overflowInc(this.green, 1);
                break;
            }
            case COLORLESS: {
                this.colorless = CardUtil.overflowInc(this.colorless, 1);
                break;
            }
            case GENERIC: {
                this.generic = CardUtil.overflowInc(this.generic, 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown manaType: " + (Object)((Object)manaType));
            }
        }
    }

    public Mana(ManaType manaType, int num) {
        this();
        Objects.requireNonNull(manaType, "The passed in ManaType can not be null");
        switch (manaType) {
            case WHITE: {
                this.white = CardUtil.overflowInc(this.white, num);
                break;
            }
            case BLUE: {
                this.blue = CardUtil.overflowInc(this.blue, num);
                break;
            }
            case BLACK: {
                this.black = CardUtil.overflowInc(this.black, num);
                break;
            }
            case RED: {
                this.red = CardUtil.overflowInc(this.red, num);
                break;
            }
            case GREEN: {
                this.green = CardUtil.overflowInc(this.green, num);
                break;
            }
            case COLORLESS: {
                this.colorless = CardUtil.overflowInc(this.colorless, num);
                break;
            }
            case GENERIC: {
                this.generic = CardUtil.overflowInc(this.generic, num);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown manaType: " + (Object)((Object)manaType));
            }
        }
    }

    public static Mana WhiteMana(int num) {
        return new Mana(Mana.notNegative(num, "White"), 0, 0, 0, 0, 0, 0, 0);
    }

    public static Mana BlueMana(int num) {
        return new Mana(0, Mana.notNegative(num, "Blue"), 0, 0, 0, 0, 0, 0);
    }

    public static Mana BlackMana(int num) {
        return new Mana(0, 0, Mana.notNegative(num, "Black"), 0, 0, 0, 0, 0);
    }

    public static Mana RedMana(int num) {
        return new Mana(0, 0, 0, Mana.notNegative(num, "Red"), 0, 0, 0, 0);
    }

    public static Mana GreenMana(int num) {
        return new Mana(0, 0, 0, 0, Mana.notNegative(num, "Green"), 0, 0, 0);
    }

    public static Mana GenericMana(int num) {
        return new Mana(0, 0, 0, 0, 0, Mana.notNegative(num, "Generic"), 0, 0);
    }

    public static Mana ColorlessMana(int num) {
        return new Mana(0, 0, 0, 0, 0, 0, 0, Mana.notNegative(num, "Colorless"));
    }

    public static Mana AnyMana(int num) {
        return new Mana(0, 0, 0, 0, 0, 0, Mana.notNegative(num, "Any"), 0);
    }

    public void add(Mana mana) {
        this.white = CardUtil.overflowInc(this.white, mana.white);
        this.blue = CardUtil.overflowInc(this.blue, mana.blue);
        this.black = CardUtil.overflowInc(this.black, mana.black);
        this.red = CardUtil.overflowInc(this.red, mana.red);
        this.green = CardUtil.overflowInc(this.green, mana.green);
        this.generic = CardUtil.overflowInc(this.generic, mana.generic);
        this.colorless = CardUtil.overflowInc(this.colorless, mana.colorless);
        this.any = CardUtil.overflowInc(this.any, mana.any);
    }

    public void increase(ManaType manaType) {
        this.increaseOrDecrease(manaType, true);
    }

    public void decrease(ManaType manaType) {
        this.increaseOrDecrease(manaType, false);
    }

    private void increaseOrDecrease(ManaType manaType, boolean increase) {
        BiFunction<Integer, Integer, Integer> overflowIncOrDec = increase ? CardUtil::overflowInc : CardUtil::overflowDec;
        switch (manaType) {
            case WHITE: {
                this.white = overflowIncOrDec.apply(this.white, 1);
                break;
            }
            case BLUE: {
                this.blue = overflowIncOrDec.apply(this.blue, 1);
                break;
            }
            case BLACK: {
                this.black = overflowIncOrDec.apply(this.black, 1);
                break;
            }
            case RED: {
                this.red = overflowIncOrDec.apply(this.red, 1);
                break;
            }
            case GREEN: {
                this.green = overflowIncOrDec.apply(this.green, 1);
                break;
            }
            case COLORLESS: {
                this.colorless = overflowIncOrDec.apply(this.colorless, 1);
                break;
            }
            case GENERIC: {
                this.generic = overflowIncOrDec.apply(this.generic, 1);
            }
        }
    }

    public void increaseWhite() {
        this.white = CardUtil.overflowInc(this.white, 1);
    }

    public void increaseBlue() {
        this.blue = CardUtil.overflowInc(this.blue, 1);
    }

    public void increaseBlack() {
        this.black = CardUtil.overflowInc(this.black, 1);
    }

    public void increaseRed() {
        this.red = CardUtil.overflowInc(this.red, 1);
    }

    public void increaseGreen() {
        this.green = CardUtil.overflowInc(this.green, 1);
    }

    public void increaseGeneric() {
        this.generic = CardUtil.overflowInc(this.generic, 1);
    }

    public void increaseColorless() {
        this.colorless = CardUtil.overflowInc(this.colorless, 1);
    }

    public void increaseAny() {
        this.any = CardUtil.overflowInc(this.any, 1);
    }

    public void decreaseAny() {
        this.any = CardUtil.overflowDec(this.any, 1);
    }

    public void subtract(Mana mana) {
        this.white = CardUtil.overflowDec(this.white, mana.white);
        this.blue = CardUtil.overflowDec(this.blue, mana.blue);
        this.black = CardUtil.overflowDec(this.black, mana.black);
        this.red = CardUtil.overflowDec(this.red, mana.red);
        this.green = CardUtil.overflowDec(this.green, mana.green);
        this.generic = CardUtil.overflowDec(this.generic, mana.generic);
        this.colorless = CardUtil.overflowDec(this.colorless, mana.colorless);
        this.any = CardUtil.overflowDec(this.any, mana.any);
    }

    public boolean isValid() {
        return this.white >= 0 && this.blue >= 0 && this.black >= 0 && this.red >= 0 && this.green >= 0 && this.generic >= 0 && this.colorless >= 0 && this.any >= 0;
    }

    public void subtractCost(Mana mana) throws ArithmeticException {
        this.subtract(mana);
        while (this.generic < 0) {
            int oldColorless = this.generic;
            if (this.white > 0) {
                this.white = CardUtil.overflowDec(this.white, 1);
                this.generic = CardUtil.overflowInc(this.generic, 1);
                continue;
            }
            if (this.blue > 0) {
                this.blue = CardUtil.overflowDec(this.blue, 1);
                this.generic = CardUtil.overflowInc(this.generic, 1);
                continue;
            }
            if (this.black > 0) {
                this.black = CardUtil.overflowDec(this.black, 1);
                this.generic = CardUtil.overflowInc(this.generic, 1);
                continue;
            }
            if (this.red > 0) {
                this.red = CardUtil.overflowDec(this.red, 1);
                this.generic = CardUtil.overflowInc(this.generic, 1);
                continue;
            }
            if (this.green > 0) {
                this.green = CardUtil.overflowDec(this.green, 1);
                this.generic = CardUtil.overflowInc(this.generic, 1);
                continue;
            }
            if (this.colorless > 0) {
                this.colorless = CardUtil.overflowDec(this.colorless, 1);
                this.generic = CardUtil.overflowInc(this.generic, 1);
                continue;
            }
            if (this.any > 0) {
                this.any = CardUtil.overflowDec(this.any, 1);
                this.generic = CardUtil.overflowInc(this.generic, 1);
                continue;
            }
            if (oldColorless != this.generic) continue;
            throw new ArithmeticException("Not enough mana to pay colorless");
        }
    }

    public int count() {
        int sum = this.countColored();
        sum = CardUtil.overflowInc(sum, this.generic);
        sum = CardUtil.overflowInc(sum, this.colorless);
        return sum;
    }

    public int countColored() {
        int sum = CardUtil.overflowInc(this.white, this.blue);
        sum = CardUtil.overflowInc(sum, this.black);
        sum = CardUtil.overflowInc(sum, this.red);
        sum = CardUtil.overflowInc(sum, this.green);
        sum = CardUtil.overflowInc(sum, this.any);
        return sum;
    }

    public int count(FilterMana filter) {
        if (filter == null) {
            return this.count();
        }
        int count = 0;
        if (filter.isWhite()) {
            count = CardUtil.overflowInc(count, this.white);
        }
        if (filter.isBlue()) {
            count = CardUtil.overflowInc(count, this.blue);
        }
        if (filter.isBlack()) {
            count = CardUtil.overflowInc(count, this.black);
        }
        if (filter.isRed()) {
            count = CardUtil.overflowInc(count, this.red);
        }
        if (filter.isGreen()) {
            count = CardUtil.overflowInc(count, this.green);
        }
        if (filter.isGeneric()) {
            count = CardUtil.overflowInc(count, this.generic);
        }
        if (filter.isColorless()) {
            count = CardUtil.overflowInc(count, this.colorless);
        }
        return count;
    }

    public void clear() {
        this.white = 0;
        this.blue = 0;
        this.black = 0;
        this.red = 0;
        this.green = 0;
        this.generic = 0;
        this.colorless = 0;
        this.any = 0;
    }

    private String getColorsInOrder() {
        StringBuilder sb = new StringBuilder();
        if (this.white > 0) {
            sb.append("W");
        }
        if (this.blue > 0) {
            sb.append("U");
        }
        if (this.black > 0) {
            sb.append("B");
        }
        if (this.red > 0) {
            sb.append("R");
        }
        if (this.green > 0) {
            sb.append("G");
        }
        String manaString = sb.toString();
        return colorLetterMap.getOrDefault(manaString, manaString);
    }

    private int colorCharToAmount(char color) {
        switch (color) {
            case 'W': {
                return this.white;
            }
            case 'U': {
                return this.blue;
            }
            case 'B': {
                return this.black;
            }
            case 'R': {
                return this.red;
            }
            case 'G': {
                return this.green;
            }
        }
        return 0;
    }

    public String toString() {
        StringBuilder sbMana = new StringBuilder();
        if (this.generic > 0) {
            sbMana.append('{').append(this.generic).append('}');
        }
        if (this.colorless < 20) {
            for (int i = 0; i < this.colorless; ++i) {
                sbMana.append("{C}");
            }
        } else {
            sbMana.append(this.colorless).append("{C}");
        }
        String colorsInOrder = this.getColorsInOrder();
        for (char c : colorsInOrder.toCharArray()) {
            int amount = this.colorCharToAmount(c);
            if (amount < 20) {
                for (int i = 0; i < amount; ++i) {
                    sbMana.append('{').append(c).append('}');
                }
                continue;
            }
            sbMana.append(amount).append('{').append(c).append('}');
        }
        if (this.any < 20) {
            for (int i = 0; i < this.any; ++i) {
                sbMana.append("{Any}");
            }
        } else {
            sbMana.append(this.any).append("{Any}");
        }
        return sbMana.toString();
    }

    @Override
    public Mana copy() {
        return new Mana(this);
    }

    public boolean enough(Mana avail) {
        Mana compare = avail.copy();
        compare.subtract(this);
        if (compare.colorless < 0) {
            return false;
        }
        if (compare.white < 0) {
            compare.any = CardUtil.overflowInc(compare.any, compare.white);
            if (compare.any < 0) {
                return false;
            }
            compare.white = 0;
        }
        if (compare.blue < 0) {
            compare.any = CardUtil.overflowInc(compare.any, compare.blue);
            if (compare.any < 0) {
                return false;
            }
            compare.blue = 0;
        }
        if (compare.black < 0) {
            compare.any = CardUtil.overflowInc(compare.any, compare.black);
            if (compare.any < 0) {
                return false;
            }
            compare.black = 0;
        }
        if (compare.red < 0) {
            compare.any = CardUtil.overflowInc(compare.any, compare.red);
            if (compare.any < 0) {
                return false;
            }
            compare.red = 0;
        }
        if (compare.green < 0) {
            compare.any = CardUtil.overflowInc(compare.any, compare.green);
            if (compare.any < 0) {
                return false;
            }
            compare.green = 0;
        }
        if (compare.generic < 0) {
            compare.generic = CardUtil.overflowInc(compare.generic, compare.white);
            compare.generic = CardUtil.overflowInc(compare.generic, compare.blue);
            compare.generic = CardUtil.overflowInc(compare.generic, compare.black);
            compare.generic = CardUtil.overflowInc(compare.generic, compare.red);
            compare.generic = CardUtil.overflowInc(compare.generic, compare.green);
            compare.generic = CardUtil.overflowInc(compare.generic, compare.colorless);
            compare.generic = CardUtil.overflowInc(compare.generic, compare.any);
            return compare.generic >= 0;
        }
        return true;
    }

    public Mana needed(Mana avail) {
        int diff;
        Mana compare = avail.copy();
        compare.subtract(this);
        if (compare.white < 0 && compare.any > 0) {
            diff = Math.min(compare.any, Math.abs(compare.white));
            compare.any = CardUtil.overflowDec(compare.any, diff);
            compare.white = CardUtil.overflowInc(compare.white, diff);
        }
        if (compare.blue < 0 && compare.any > 0) {
            diff = Math.min(compare.any, Math.abs(compare.blue));
            compare.any = CardUtil.overflowDec(compare.any, diff);
            compare.blue = CardUtil.overflowInc(compare.blue, diff);
        }
        if (compare.black < 0 && compare.any > 0) {
            diff = Math.min(compare.any, Math.abs(compare.black));
            compare.any = CardUtil.overflowDec(compare.any, diff);
            compare.black = CardUtil.overflowInc(compare.black, diff);
        }
        if (compare.red < 0 && compare.any > 0) {
            diff = Math.min(compare.any, Math.abs(compare.red));
            compare.any = CardUtil.overflowDec(compare.any, diff);
            compare.red = CardUtil.overflowInc(compare.red, diff);
        }
        if (compare.green < 0 && compare.any > 0) {
            diff = Math.min(compare.any, Math.abs(compare.green));
            compare.any = CardUtil.overflowDec(compare.any, diff);
            compare.green = CardUtil.overflowInc(compare.green, diff);
        }
        if (compare.generic < 0) {
            int remaining = 0;
            remaining = CardUtil.overflowInc(remaining, Math.max(0, compare.white));
            remaining = CardUtil.overflowInc(remaining, Math.max(0, compare.blue));
            remaining = CardUtil.overflowInc(remaining, Math.max(0, compare.black));
            remaining = CardUtil.overflowInc(remaining, Math.max(0, compare.red));
            remaining = CardUtil.overflowInc(remaining, Math.max(0, compare.green));
            remaining = CardUtil.overflowInc(remaining, Math.max(0, compare.colorless));
            if ((remaining = CardUtil.overflowInc(remaining, Math.max(0, compare.any))) > 0) {
                int diff2 = Math.min(remaining, Math.abs(compare.generic));
                compare.generic = CardUtil.overflowInc(compare.generic, diff2);
            }
        }
        Mana needed = new Mana();
        if (compare.white < 0) {
            needed.white = CardUtil.overflowDec(needed.white, compare.white);
        }
        if (compare.blue < 0) {
            needed.blue = CardUtil.overflowDec(needed.blue, compare.blue);
        }
        if (compare.black < 0) {
            needed.black = CardUtil.overflowDec(needed.black, compare.black);
        }
        if (compare.red < 0) {
            needed.red = CardUtil.overflowDec(needed.red, compare.red);
        }
        if (compare.green < 0) {
            needed.green = CardUtil.overflowDec(needed.green, compare.green);
        }
        if (compare.colorless < 0) {
            needed.colorless = CardUtil.overflowDec(needed.colorless, compare.colorless);
        }
        if (compare.generic < 0) {
            needed.generic = CardUtil.overflowDec(needed.generic, compare.generic);
        }
        return needed;
    }

    public int getWhite() {
        return this.white;
    }

    public void setWhite(int white) {
        this.white = Mana.notNegative(white, "White");
    }

    public int getBlue() {
        return this.blue;
    }

    public void setBlue(int blue) {
        this.blue = Mana.notNegative(blue, "Blue");
    }

    public int getBlack() {
        return this.black;
    }

    public void setBlack(int black) {
        this.black = Mana.notNegative(black, "Black");
    }

    public int getRed() {
        return this.red;
    }

    public void setRed(int red) {
        this.red = Mana.notNegative(red, "Red");
    }

    public int getGreen() {
        return this.green;
    }

    public void setGreen(int green) {
        this.green = Mana.notNegative(green, "Green");
    }

    public int getGeneric() {
        return this.generic;
    }

    public void setGeneric(int generic) {
        this.generic = Mana.notNegative(generic, "Generic");
    }

    public int getColorless() {
        return this.colorless;
    }

    public void setColorless(int colorless) {
        this.colorless = Mana.notNegative(colorless, "Colorless");
    }

    public int getAny() {
        return this.any;
    }

    public void setAny(int any) {
        this.any = Mana.notNegative(any, "Any");
    }

    @Override
    public int compareTo(Mana o) {
        return Integer.compare(this.count(), o.count());
    }

    public boolean contains(Mana mana) {
        if (mana.white > 0 && this.white > 0) {
            return true;
        }
        if (mana.blue > 0 && this.blue > 0) {
            return true;
        }
        if (mana.black > 0 && this.black > 0) {
            return true;
        }
        if (mana.red > 0 && this.red > 0) {
            return true;
        }
        if (mana.green > 0 && this.green > 0) {
            return true;
        }
        if (mana.colorless > 0 && this.colorless > 0) {
            return true;
        }
        return mana.generic > 0 && this.count() > 0;
    }

    public boolean containsAny(Mana mana) {
        return this.containsAny(mana, false);
    }

    public boolean containsAny(Mana mana, boolean includeColorless) {
        if (mana.white > 0 && this.white > 0) {
            return true;
        }
        if (mana.blue > 0 && this.blue > 0) {
            return true;
        }
        if (mana.black > 0 && this.black > 0) {
            return true;
        }
        if (mana.red > 0 && this.red > 0) {
            return true;
        }
        if (mana.green > 0 && this.green > 0) {
            return true;
        }
        if (mana.colorless > 0 && this.colorless > 0 && includeColorless) {
            return true;
        }
        return mana.any > 0 && this.count() > 0;
    }

    public int getColor(ColoredManaSymbol color) {
        switch (color) {
            case W: {
                return this.white;
            }
            case U: {
                return this.blue;
            }
            case B: {
                return this.black;
            }
            case R: {
                return this.red;
            }
            case G: {
                return this.green;
            }
        }
        return 0;
    }

    public int get(ManaType manaType) {
        switch (manaType) {
            case WHITE: {
                return this.white;
            }
            case BLUE: {
                return this.blue;
            }
            case BLACK: {
                return this.black;
            }
            case RED: {
                return this.red;
            }
            case GREEN: {
                return this.green;
            }
            case COLORLESS: {
                return CardUtil.overflowInc(this.generic, this.colorless);
            }
        }
        return 0;
    }

    public void set(ManaType manaType, int amount) {
        switch (manaType) {
            case WHITE: {
                this.setWhite(Mana.notNegative(amount, "white"));
                break;
            }
            case BLUE: {
                this.setBlue(Mana.notNegative(amount, "blue"));
                break;
            }
            case BLACK: {
                this.setBlack(Mana.notNegative(amount, "black"));
                break;
            }
            case RED: {
                this.setRed(Mana.notNegative(amount, "red"));
                break;
            }
            case GREEN: {
                this.setGreen(Mana.notNegative(amount, "green"));
                break;
            }
            case COLORLESS: {
                this.setColorless(Mana.notNegative(amount, "colorless"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown color: " + (Object)((Object)manaType));
            }
        }
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public boolean getFlag() {
        return this.flag;
    }

    public void setToMana(Mana mana) {
        this.any = mana.any;
        this.white = mana.white;
        this.blue = mana.blue;
        this.black = mana.black;
        this.red = mana.red;
        this.green = mana.green;
        this.colorless = mana.colorless;
        this.generic = mana.generic;
    }

    public boolean equalManaValue(Mana mana) {
        return this.any == mana.any && this.white == mana.white && this.blue == mana.blue && this.black == mana.black && this.red == mana.red && this.green == mana.green && this.colorless == mana.colorless && this.generic == mana.generic;
    }

    public boolean includesMana(Mana manaPart) {
        int diff;
        if (!this.isValid() || !manaPart.isValid()) {
            throw new IllegalArgumentException("Wrong code usage: found negative values in mana calculations: main " + this + ", part " + manaPart);
        }
        if (this.count() < manaPart.count()) {
            return false;
        }
        if (manaPart.count() == 0) {
            return true;
        }
        Mana pool = this.copy();
        Mana cost = manaPart.copy();
        pool.subtract(cost);
        cost.white = Math.max(0, -1 * pool.white);
        pool.white = Math.max(0, pool.white);
        cost.blue = Math.max(0, -1 * pool.blue);
        pool.blue = Math.max(0, pool.blue);
        cost.black = Math.max(0, -1 * pool.black);
        pool.black = Math.max(0, pool.black);
        cost.red = Math.max(0, -1 * pool.red);
        pool.red = Math.max(0, pool.red);
        cost.green = Math.max(0, -1 * pool.green);
        pool.green = Math.max(0, pool.green);
        cost.generic = Math.max(0, -1 * pool.generic);
        pool.generic = Math.max(0, pool.generic);
        cost.colorless = Math.max(0, -1 * pool.colorless);
        pool.colorless = Math.max(0, pool.colorless);
        cost.any = Math.max(0, -1 * pool.any);
        pool.any = Math.max(0, pool.any);
        if (cost.count() > pool.count()) {
            throw new IllegalArgumentException("Wrong mana calculation: " + cost + " - " + pool);
        }
        if (cost.any > 0 || cost.colorless > 0) {
            return false;
        }
        if (pool.any > 0 && cost.white > 0) {
            diff = Math.min(pool.any, cost.white);
            pool.any -= diff;
            cost.white -= diff;
        }
        if (pool.any > 0 && cost.blue > 0) {
            diff = Math.min(pool.any, cost.blue);
            pool.any -= diff;
            cost.blue -= diff;
        }
        if (pool.any > 0 && cost.black > 0) {
            diff = Math.min(pool.any, cost.black);
            pool.any -= diff;
            cost.black -= diff;
        }
        if (pool.any > 0 && cost.red > 0) {
            diff = Math.min(pool.any, cost.red);
            pool.any -= diff;
            cost.red -= diff;
        }
        if (pool.any > 0 && cost.green > 0) {
            diff = Math.min(pool.any, cost.green);
            pool.any -= diff;
            cost.green -= diff;
        }
        if (cost.countColored() > 0) {
            return false;
        }
        int leftPool = pool.count();
        if (leftPool > 0 && cost.generic > 0) {
            int diff2 = Math.min(leftPool, cost.generic);
            cost.generic -= diff2;
        }
        return cost.count() == 0;
    }

    public boolean isMoreValuableThan(Mana that) {
        return this == Mana.getMoreValuableMana(this, that);
    }

    public static Mana getMoreValuableMana(Mana mana1, Mana mana2) {
        Mana lessMana;
        Mana moreMana;
        List<Condition> conditions2;
        List<Condition> conditions1;
        if (mana1.equals(mana2)) {
            return null;
        }
        boolean mana1IsConditional = mana1 instanceof ConditionalMana;
        boolean mana2IsConditional = mana2 instanceof ConditionalMana;
        if (mana1IsConditional != mana2IsConditional) {
            return null;
        }
        if (mana1IsConditional && !Objects.equals(conditions1 = ((ConditionalMana)mana1).getConditions(), conditions2 = ((ConditionalMana)mana2).getConditions())) {
            return null;
        }
        if (mana2.any > mana1.any || mana2.colorless > mana1.colorless || mana2.countColored() > mana1.countColored() || mana2.countColored() == mana1.countColored() && mana2.colorless == mana1.colorless && mana2.count() > mana1.count()) {
            moreMana = mana2;
            lessMana = mana1;
        } else {
            moreMana = mana1;
            lessMana = mana2;
        }
        if (lessMana.any > moreMana.any) {
            return null;
        }
        if (lessMana.colorless > moreMana.colorless) {
            return null;
        }
        int anyDiff = CardUtil.overflowDec(moreMana.any, lessMana.any);
        int whiteDiff = CardUtil.overflowDec(lessMana.white, moreMana.white);
        if (whiteDiff > 0 && (anyDiff = CardUtil.overflowDec(anyDiff, whiteDiff)) < 0) {
            return null;
        }
        int redDiff = CardUtil.overflowDec(lessMana.red, moreMana.red);
        if (redDiff > 0 && (anyDiff = CardUtil.overflowDec(anyDiff, redDiff)) < 0) {
            return null;
        }
        int greenDiff = CardUtil.overflowDec(lessMana.green, moreMana.green);
        if (greenDiff > 0 && (anyDiff = CardUtil.overflowDec(anyDiff, greenDiff)) < 0) {
            return null;
        }
        int blueDiff = CardUtil.overflowDec(lessMana.blue, moreMana.blue);
        if (blueDiff > 0 && (anyDiff = CardUtil.overflowDec(anyDiff, blueDiff)) < 0) {
            return null;
        }
        int blackDiff = CardUtil.overflowDec(lessMana.black, moreMana.black);
        if (blackDiff > 0 && (anyDiff = CardUtil.overflowDec(anyDiff, blackDiff)) < 0) {
            return null;
        }
        return moreMana;
    }

    public int getDifferentColors() {
        int count = 0;
        if (this.white > 0) {
            ++count;
        }
        if (this.blue > 0) {
            ++count;
        }
        if (this.black > 0) {
            ++count;
        }
        if (this.red > 0) {
            ++count;
        }
        if (this.green > 0) {
            ++count;
        }
        return count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mana mana = (Mana)o;
        return this.flag == mana.flag && this.white == mana.white && this.blue == mana.blue && this.black == mana.black && this.red == mana.red && this.green == mana.green && this.generic == mana.generic && this.colorless == mana.colorless && this.any == mana.any;
    }

    public int hashCode() {
        long result = 1L;
        result = 31L * result + (long)this.white;
        result = 31L * result + (long)this.blue;
        result = 31L * result + (long)this.black;
        result = 31L * result + (long)this.red;
        result = 31L * result + (long)this.green;
        result = 31L * result + (long)this.generic;
        result = 31L * result + (long)this.colorless;
        result = 31L * result + (long)this.any;
        result = 31L * result + (long)(this.flag ? 1 : 0);
        return Long.hashCode(result);
    }

    private static int notNegative(int value, String name) {
        if (value < 0) {
            logger.info((Object)(name + " can not be less than 0. Passed in: " + value + " Defaulting to 0."));
            value = 0;
        }
        return value;
    }

    static {
        colorLetterMap.put("WR", "RW");
        colorLetterMap.put("WG", "GW");
        colorLetterMap.put("UG", "GU");
        colorLetterMap.put("WRG", "RGW");
        colorLetterMap.put("WUG", "GWU");
        colorLetterMap.put("WUR", "URW");
        colorLetterMap.put("URG", "GUR");
        colorLetterMap.put("UBG", "BGU");
        colorLetterMap.put("WBG", "RWB");
        colorLetterMap.put("WBRG", "BRGW");
        colorLetterMap.put("WURG", "RGWU");
        colorLetterMap.put("WUBG", "GWUB");
    }
}

