/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Abilities;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.EvasionAbility;
import mage.abilities.MageSingleton;
import mage.abilities.PlayLandAbility;
import mage.abilities.SpellAbility;
import mage.abilities.StaticAbility;
import mage.abilities.TriggeredAbility;
import mage.abilities.common.ZoneChangeTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.keyword.ProtectionAbility;
import mage.abilities.mana.ActivatedManaAbilityImpl;
import mage.abilities.mana.ManaAbility;
import mage.constants.Zone;
import mage.game.Game;
import mage.util.CardUtil;
import mage.util.ThreadLocalStringBuilder;
import org.apache.log4j.Logger;

public class AbilitiesImpl<T extends Ability>
extends ArrayList<T>
implements Abilities<T> {
    private static final Logger logger = Logger.getLogger(AbilitiesImpl.class);
    private static final ThreadLocalStringBuilder threadLocalBuilder = new ThreadLocalStringBuilder(200);

    public AbilitiesImpl() {
    }

    public AbilitiesImpl(T ... abilities) {
        Collections.addAll(this, abilities);
    }

    public AbilitiesImpl(AbilitiesImpl<T> abilities) {
        this.ensureCapacity(abilities.size());
        for (Ability ability : abilities) {
            this.add(ability.copy());
        }
    }

    @Override
    public AbilitiesImpl<T> copy() {
        return new AbilitiesImpl<T>(this);
    }

    @Override
    public List<String> getRules() {
        return this.getRules(true);
    }

    @Override
    public List<String> getRules(boolean capitalize) {
        ArrayList<String> rules = new ArrayList<String>();
        for (Ability ability : this) {
            String rule;
            if (!ability.getRuleVisible()) continue;
            if (!(ability instanceof SpellAbility) && !(ability instanceof PlayLandAbility)) {
                rule = ability.getRule();
                if (rule == null || rule.length() <= 3) continue;
                if (capitalize) {
                    rule = Character.toUpperCase(rule.charAt(0)) + rule.substring(1);
                }
                if (ability.getRuleAtTheTop()) {
                    rules.add(0, rule);
                    continue;
                }
                rules.add(rule);
                continue;
            }
            if (!(ability instanceof SpellAbility)) continue;
            if (ability.getAdditionalCostsRuleVisible() && !ability.getCosts().isEmpty()) {
                StringBuilder sbRule = threadLocalBuilder.get();
                for (Cost cost : ability.getCosts()) {
                    if (cost.getText() == null || cost.getText().isEmpty()) continue;
                    String costText = cost.getText();
                    if (!cost.getText().startsWith("As an additional cost")) {
                        sbRule.append("As an additional cost to cast this spell, ");
                        if (!costText.isEmpty()) {
                            costText = Character.toLowerCase(costText.charAt(0)) + costText.substring(1);
                        }
                    }
                    sbRule.append(costText).append(".<br>");
                }
                rules.add(sbRule.toString());
            }
            if ((rule = ability.getRule()) != null) {
                if (rule.isEmpty()) continue;
                rule = Character.toUpperCase(rule.charAt(0)) + rule.substring(1);
                if (ability.getRuleAtTheTop()) {
                    rules.add(0, rule);
                    continue;
                }
                rules.add(rule);
                continue;
            }
            String cardName = ((SpellAbility)ability).getCardName();
            logger.fatal((Object)("Error in rule text generation of " + cardName + ": Create a bug report or fix the source code"));
        }
        return rules;
    }

    @Override
    public List<String> getRules(Game game, MageObject object) {
        Abilities<Ability> sourceAbilities = this.getAllAbilities();
        return CardUtil.getCardRulesWithAdditionalInfo(game, object, sourceAbilities, sourceAbilities);
    }

    @Override
    public Abilities<ActivatedAbility> getActivatedAbilities(Zone zone) {
        return this.stream().filter(ActivatedAbility.class::isInstance).filter(ability -> ability.getZone().match(zone)).map(ActivatedAbility.class::cast).collect(Collectors.toCollection(AbilitiesImpl::new));
    }

    @Override
    public Abilities<ActivatedAbility> getPlayableAbilities(Zone zone) {
        return this.stream().filter(ActivatedAbility.class::isInstance).filter(ability -> ability.getZone().match(zone)).map(ActivatedAbility.class::cast).collect(Collectors.toCollection(AbilitiesImpl::new));
    }

    @Override
    public Abilities<ActivatedManaAbilityImpl> getActivatedManaAbilities(Zone zone) {
        return this.stream().filter(ActivatedManaAbilityImpl.class::isInstance).filter(ability -> ability.getZone().match(zone)).map(ActivatedManaAbilityImpl.class::cast).collect(Collectors.toCollection(AbilitiesImpl::new));
    }

    @Override
    public Abilities<ActivatedManaAbilityImpl> getAvailableActivatedManaAbilities(Zone zone, UUID playerId, Game game) {
        return this.stream().filter(ActivatedManaAbilityImpl.class::isInstance).filter(ability -> ability.getZone().match(zone)).map(ActivatedManaAbilityImpl.class::cast).filter(ability -> ability.canActivate(playerId, game).canActivate()).collect(Collectors.toCollection(AbilitiesImpl::new));
    }

    @Override
    public Abilities<EvasionAbility> getEvasionAbilities() {
        return this.stream().filter(EvasionAbility.class::isInstance).map(EvasionAbility.class::cast).collect(Collectors.toCollection(AbilitiesImpl::new));
    }

    @Override
    public Abilities<StaticAbility> getStaticAbilities(Zone zone) {
        return this.stream().filter(StaticAbility.class::isInstance).filter(ability -> ability.getZone().match(zone)).map(StaticAbility.class::cast).collect(Collectors.toCollection(AbilitiesImpl::new));
    }

    @Override
    public Abilities<TriggeredAbility> getTriggeredAbilities(Zone zone) {
        AbilitiesImpl<TriggeredAbility> zonedAbilities = new AbilitiesImpl<TriggeredAbility>();
        for (Ability ability : this) {
            ZoneChangeTriggeredAbility zcAbility;
            if (ability.isTriggeredAbility() && ability.getZone().match(zone)) {
                zonedAbilities.add((TriggeredAbility)ability);
                continue;
            }
            if (!(ability instanceof ZoneChangeTriggeredAbility) || (zcAbility = (ZoneChangeTriggeredAbility)ability).getToZone() == null || !zcAbility.getToZone().match(zone)) continue;
            zonedAbilities.add((ZoneChangeTriggeredAbility)ability);
        }
        return zonedAbilities;
    }

    @Override
    public boolean hasPoolDependantAbilities() {
        return this.stream().filter(Ability::isManaAbility).map(ManaAbility.class::cast).anyMatch(ManaAbility::isPoolDependant);
    }

    @Override
    public Abilities<ProtectionAbility> getProtectionAbilities() {
        return this.stream().filter(ProtectionAbility.class::isInstance).map(ProtectionAbility.class::cast).collect(Collectors.toCollection(AbilitiesImpl::new));
    }

    @Override
    public Abilities<Ability> getAllAbilities() {
        return this.stream().collect(Collectors.toCollection(AbilitiesImpl::new));
    }

    @Override
    public void setControllerId(UUID controllerId) {
        for (Ability ability : this) {
            ability.setControllerId(controllerId);
        }
    }

    @Override
    public void setSourceId(UUID sourceId) {
        for (Ability ability : this) {
            ability.setSourceId(sourceId);
        }
    }

    @Override
    public void newId() {
        for (Ability ability : this) {
            ability.newId();
        }
    }

    @Override
    public void newOriginalId() {
        for (Ability ability : this) {
            ability.newOriginalId();
        }
    }

    @Override
    public boolean contains(T ability) {
        for (Ability test : this) {
            if (ability.getId().equals(test.getId())) {
                return true;
            }
            if (ability.getOriginalId().equals(test.getOriginalId())) {
                return true;
            }
            if (!(ability instanceof MageSingleton) || !(test instanceof MageSingleton) || !ability.getRule().equals(test.getRule())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsRule(T ability) {
        return this.stream().map(Ability::getRule).anyMatch(ability.getRule()::equals);
    }

    @Override
    public boolean containsAll(Abilities<T> abilities) {
        if (this.size() < abilities.size()) {
            return false;
        }
        for (Ability ability : abilities) {
            if (this.contains((T)ability)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(UUID abilityId) {
        if (abilityId == null) {
            return false;
        }
        for (Ability ability : this) {
            if (ability == null || !abilityId.equals(ability.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsClass(Class classObject) {
        return this.stream().map(Object::getClass).anyMatch(classObject::equals);
    }

    @Override
    public Optional<T> get(UUID abilityId) {
        return this.stream().filter(ability -> ability.getId().equals(abilityId)).findFirst();
    }

    @Override
    public int getOutcomeTotal() {
        return this.stream().mapToInt(ability -> ability.getEffects().getOutcomeScore((Ability)ability)).sum();
    }

    @Override
    public String getValue() {
        ArrayList<String> abilities = new ArrayList<String>();
        for (Ability ability : this) {
            if (ability.toString() == null) continue;
            abilities.add(ability.toString());
        }
        Collections.sort(abilities);
        StringBuilder sb = threadLocalBuilder.get();
        for (String s : abilities) {
            sb.append(s);
        }
        return sb.toString();
    }
}

