/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities;

import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.PayLoyaltyCost;
import mage.abilities.costs.common.PayVariableLoyaltyCost;
import mage.abilities.effects.Effect;
import mage.constants.TimingRule;
import mage.constants.Zone;

public class LoyaltyAbility
extends ActivatedAbilityImpl {
    public LoyaltyAbility(Effect effect, int loyalty) {
        super(Zone.BATTLEFIELD, effect, new PayLoyaltyCost(loyalty));
        this.timing = TimingRule.SORCERY;
    }

    public LoyaltyAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect, new PayVariableLoyaltyCost());
        this.timing = TimingRule.SORCERY;
    }

    protected LoyaltyAbility(LoyaltyAbility ability) {
        super(ability);
    }

    @Override
    public LoyaltyAbility copy() {
        return new LoyaltyAbility(this);
    }

    public void increaseLoyaltyCost(int amount) {
        int staticCount = 0;
        for (Cost cost : this.getCosts()) {
            if (cost instanceof PayLoyaltyCost) {
                PayLoyaltyCost staticCost = (PayLoyaltyCost)cost;
                staticCost.setAmount(staticCost.getAmount() + amount);
                ++staticCount;
                continue;
            }
            if (!(cost instanceof PayVariableLoyaltyCost)) continue;
            PayVariableLoyaltyCost xCost = (PayVariableLoyaltyCost)cost;
            xCost.setCostModification(xCost.getCostModification() + amount);
        }
        if (staticCount > 1) {
            throw new IllegalArgumentException(String.format("Loyalty ability must have only 1 static cost, but has %d: %s", staticCount, this.getRule()));
        }
    }
}

