/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities;

import java.io.Serializable;
import java.util.UUID;
import mage.abilities.costs.Cost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.Effects;
import mage.target.Target;
import mage.target.Targets;

public class Mode
implements Serializable {
    protected UUID id;
    protected final Targets targets;
    protected final Effects effects;
    protected String flavorWord;
    protected Cost cost = null;
    protected int pawPrintValue = 0;
    protected String modeTag;

    public Mode(Effect effect) {
        this.id = UUID.randomUUID();
        this.targets = new Targets();
        this.effects = new Effects(new Effect[0]);
        if (effect != null) {
            this.effects.add(effect);
        }
    }

    protected Mode(Mode mode) {
        this.id = mode.id;
        this.targets = mode.targets.copy();
        this.effects = mode.effects.copy();
        this.flavorWord = mode.flavorWord;
        this.modeTag = mode.modeTag;
        this.cost = mode.cost != null ? mode.cost.copy() : null;
        this.pawPrintValue = mode.pawPrintValue;
    }

    public UUID setRandomId() {
        this.id = UUID.randomUUID();
        return this.id;
    }

    public Mode copy() {
        return new Mode(this);
    }

    public UUID getId() {
        return this.id;
    }

    public Targets getTargets() {
        return this.targets;
    }

    public Mode addTarget(Target target) {
        return this.addTarget(target, false);
    }

    public Mode addTarget(Target target, Boolean addChooseHintFromEffect) {
        this.targets.add(target);
        if (addChooseHintFromEffect.booleanValue()) {
            target.withChooseHint(this.getEffects().getText(this));
        }
        return this;
    }

    public Effects getEffects() {
        return this.effects;
    }

    public Mode addEffect(Effect effect) {
        this.effects.add(effect);
        return this;
    }

    public Mode setModeTag(String tag) {
        this.modeTag = tag;
        return this;
    }

    public String getModeTag() {
        return this.modeTag == null ? "" : this.modeTag;
    }

    public String getFlavorWord() {
        return this.flavorWord;
    }

    public Mode withFlavorWord(String flavorWord) {
        this.flavorWord = flavorWord;
        return this;
    }

    public Mode withCost(Cost cost) {
        this.cost = cost;
        return this;
    }

    public Cost getCost() {
        return this.cost;
    }

    public Mode withPawPrintValue(int pawPrintValue) {
        this.pawPrintValue = pawPrintValue;
        return this;
    }

    public int getPawPrintValue() {
        return this.pawPrintValue;
    }

    public String toString() {
        return String.format("%s", this.getEffects().getText(this));
    }
}

