/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

public interface TriggeredAbility
extends Ability {
    public void trigger(Game var1, UUID var2, GameEvent var3);

    public boolean checkEventType(GameEvent var1, Game var2);

    public boolean checkTrigger(GameEvent var1, Game var2);

    public boolean checkTriggeredLimit(Game var1);

    public boolean checkUsedAlready(Game var1);

    public TriggeredAbility setTriggersLimitEachTurn(int var1);

    public TriggeredAbility setTriggersLimitEachGame(int var1);

    public int getRemainingTriggersLimitEachTurn(Game var1);

    public int getRemainingTriggersLimitEachGame(Game var1);

    public TriggeredAbility setDoOnlyOnceEachTurn(boolean var1);

    public TriggeredAbility withRuleTextReplacement(boolean var1);

    public TriggeredAbility withInterveningIf(Condition var1);

    public boolean checkInterveningIfClause(Game var1);

    public TriggeredAbility withTriggerCondition(Condition var1);

    public Condition getTriggerCondition();

    public boolean checkTriggerCondition(Game var1);

    public boolean isOptional();

    public boolean isLeavesTheBattlefieldTrigger();

    public void setLeavesTheBattlefieldTrigger(boolean var1);

    @Override
    public TriggeredAbility copy();

    public void setTriggerEvent(GameEvent var1);

    public GameEvent getTriggerEvent();

    public TriggeredAbility setTriggerPhrase(String var1);

    public String getTriggerPhrase();

    public static String makeDidThisTurnString(Ability ability, Game game) {
        return CardUtil.getCardZoneString("lastTurnUsed" + ability.getOriginalId(), ability.getSourceId(), game);
    }

    public static void setDidThisTurn(Ability ability, Game game) {
        game.getState().setValue(TriggeredAbility.makeDidThisTurnString(ability, game), game.getTurnNum());
    }

    public static void clearDidThisTurn(Ability ability, Game game) {
        game.getState().removeValue(TriggeredAbility.makeDidThisTurnString(ability, game));
    }

    public static boolean checkDidThisTurn(Ability ability, Game game) {
        return Optional.ofNullable(TriggeredAbility.makeDidThisTurnString(ability, game)).map(game.getState()::getValue).filter(Integer.class::isInstance).map(Integer.class::cast).filter(x -> x.intValue() == game.getTurnNum()).isPresent();
    }
}

