/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities;

import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.AbilityImpl;
import mage.abilities.TriggeredAbility;
import mage.abilities.condition.Condition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroySourceEffect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.abilities.effects.common.ExileSourceEffect;
import mage.abilities.effects.common.FlipSourceEffect;
import mage.abilities.effects.common.ReturnToHandSourceEffect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.abilities.effects.common.ShuffleIntoLibrarySourceEffect;
import mage.constants.AbilityType;
import mage.constants.AbilityWord;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.PermanentToken;
import mage.players.Player;
import mage.util.CardUtil;

public abstract class TriggeredAbilityImpl
extends AbilityImpl
implements TriggeredAbility {
    private boolean optional;
    private Condition interveningIfCondition;
    private Condition triggerCondition;
    private boolean leavesTheBattlefieldTrigger;
    private int triggerLimitEachTurn = Integer.MAX_VALUE;
    private int triggerLimitEachGame = Integer.MAX_VALUE;
    private boolean doOnlyOnceEachTurn = false;
    private boolean replaceRuleText = false;
    private GameEvent triggerEvent = null;
    private String triggerPhrase = null;

    protected TriggeredAbilityImpl(Zone zone, Effect effect) {
        this(zone, effect, false);
    }

    protected TriggeredAbilityImpl(Zone zone, Effect effect, boolean optional) {
        super(AbilityType.TRIGGERED_NONMANA, zone);
        this.setLeavesTheBattlefieldTrigger(false);
        if (effect != null) {
            this.addEffect(effect);
        }
        this.optional = optional;
        if (effect instanceof DoIfCostPaid && this.optional && ((DoIfCostPaid)effect).isOptional()) {
            throw new IllegalArgumentException("DoIfCostPaid effect must have only one optional settings, but it have two (trigger + DoIfCostPaid): " + this.getClass().getSimpleName());
        }
    }

    protected TriggeredAbilityImpl(TriggeredAbilityImpl ability) {
        super(ability);
        this.optional = ability.optional;
        this.interveningIfCondition = ability.interveningIfCondition;
        this.triggerCondition = ability.triggerCondition;
        this.leavesTheBattlefieldTrigger = ability.leavesTheBattlefieldTrigger;
        this.triggerLimitEachTurn = ability.triggerLimitEachTurn;
        this.triggerLimitEachGame = ability.triggerLimitEachGame;
        this.doOnlyOnceEachTurn = ability.doOnlyOnceEachTurn;
        this.replaceRuleText = ability.replaceRuleText;
        this.triggerEvent = ability.triggerEvent;
        this.triggerPhrase = ability.triggerPhrase;
    }

    @Override
    public void trigger(Game game, UUID controllerId, GameEvent triggeringEvent) {
        if (this.checkInterveningIfClause(game) && this.checkTriggerCondition(game)) {
            this.updateTurnCount(game);
            this.updateGameCount(game);
            game.addTriggeredAbility(this, triggeringEvent);
        }
    }

    private String getKeyLastTurnTriggered(Game game) {
        return CardUtil.getCardZoneString("lastTurnTriggered|" + this.getOriginalId(), this.getSourceId(), game);
    }

    private String getKeyLastTurnTriggeredCount(Game game) {
        return CardUtil.getCardZoneString("lastTurnTriggeredCount|" + this.getOriginalId(), this.getSourceId(), game);
    }

    private String getKeyGameTriggeredCount(Game game) {
        return CardUtil.getCardZoneString("gameTriggeredCount|" + this.getOriginalId(), this.getSourceId(), game);
    }

    private void updateTurnCount(Game game) {
        if (this.triggerLimitEachTurn == Integer.MAX_VALUE) {
            return;
        }
        String keyLastTurnTriggered = this.getKeyLastTurnTriggered(game);
        String keyLastTurnTriggeredCount = this.getKeyLastTurnTriggeredCount(game);
        Integer lastTurn = (Integer)game.getState().getValue(keyLastTurnTriggered);
        int currentTurn = game.getTurnNum();
        if (lastTurn != null && lastTurn == currentTurn) {
            int lastCount = Optional.ofNullable((Integer)game.getState().getValue(keyLastTurnTriggeredCount)).orElse(0);
            game.getState().setValue(keyLastTurnTriggeredCount, lastCount + 1);
        } else {
            game.getState().setValue(keyLastTurnTriggered, currentTurn);
            game.getState().setValue(keyLastTurnTriggeredCount, 1);
        }
    }

    private void updateGameCount(Game game) {
        if (this.triggerLimitEachGame == Integer.MAX_VALUE) {
            return;
        }
        String keyGameTriggeredCount = this.getKeyGameTriggeredCount(game);
        int lastCount = Optional.ofNullable((Integer)game.getState().getValue(keyGameTriggeredCount)).orElse(0);
        game.getState().setValue(keyGameTriggeredCount, lastCount + 1);
    }

    @Override
    public TriggeredAbilityImpl setTriggerPhrase(String triggerPhrase) {
        this.triggerPhrase = triggerPhrase;
        return this;
    }

    @Override
    public String getTriggerPhrase() {
        return this.triggerPhrase;
    }

    @Override
    public void setTriggerEvent(GameEvent triggerEvent) {
        this.triggerEvent = triggerEvent;
    }

    @Override
    public GameEvent getTriggerEvent() {
        return this.triggerEvent;
    }

    @Override
    public boolean checkTriggeredLimit(Game game) {
        return this.getRemainingTriggersLimitEachGame(game) > 0 && this.getRemainingTriggersLimitEachTurn(game) > 0;
    }

    @Override
    public boolean checkUsedAlready(Game game) {
        return this.doOnlyOnceEachTurn && TriggeredAbility.checkDidThisTurn(this, game);
    }

    @Override
    public TriggeredAbility setTriggersLimitEachTurn(int limit) {
        this.triggerLimitEachTurn = limit;
        return this;
    }

    @Override
    public TriggeredAbility setTriggersLimitEachGame(int limit) {
        this.triggerLimitEachGame = limit;
        return this;
    }

    @Override
    public int getRemainingTriggersLimitEachTurn(Game game) {
        if (this.triggerLimitEachTurn == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        String keyLastTurnTriggered = this.getKeyLastTurnTriggered(game);
        Integer lastTurn = (Integer)game.getState().getValue(keyLastTurnTriggered);
        int currentTurn = game.getTurnNum();
        if (lastTurn != null && lastTurn == currentTurn) {
            String keyLastTurnTriggeredCount = this.getKeyLastTurnTriggeredCount(game);
            int count = Optional.ofNullable((Integer)game.getState().getValue(keyLastTurnTriggeredCount)).orElse(0);
            return Math.max(0, this.triggerLimitEachTurn - count);
        }
        return this.triggerLimitEachTurn;
    }

    @Override
    public int getRemainingTriggersLimitEachGame(Game game) {
        if (this.triggerLimitEachGame == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        String keyGameTriggeredCount = this.getKeyGameTriggeredCount(game);
        int count = Optional.ofNullable((Integer)game.getState().getValue(keyGameTriggeredCount)).orElse(0);
        return Math.max(0, this.triggerLimitEachGame - count);
    }

    @Override
    public TriggeredAbility setDoOnlyOnceEachTurn(boolean doOnlyOnce) {
        this.doOnlyOnceEachTurn = doOnlyOnce;
        if (CardUtil.castStream(this.getAllEffects(), DoIfCostPaid.class).noneMatch(DoIfCostPaid::isOptional)) {
            this.optional = true;
        }
        return this;
    }

    @Override
    public TriggeredAbility withRuleTextReplacement(boolean replaceRuleText) {
        this.replaceRuleText = replaceRuleText;
        return this;
    }

    @Override
    public TriggeredAbility withInterveningIf(Condition interveningIfCondition) {
        this.interveningIfCondition = interveningIfCondition;
        this.replaceRuleText = false;
        return this;
    }

    @Override
    public boolean checkInterveningIfClause(Game game) {
        return this.interveningIfCondition == null || this.interveningIfCondition.apply(game, this);
    }

    @Override
    public TriggeredAbility withTriggerCondition(Condition condition) {
        this.triggerCondition = condition;
        if (this.triggerPhrase != null && !condition.toString().isEmpty()) {
            this.setTriggerPhrase(this.triggerPhrase.substring(0, this.triggerPhrase.length() - 2) + ' ' + (condition.toString().startsWith("during") ? "" : "while ") + condition + ", ");
        }
        return this;
    }

    @Override
    public Condition getTriggerCondition() {
        return this.triggerCondition;
    }

    @Override
    public boolean checkTriggerCondition(Game game) {
        return this.triggerCondition == null || this.triggerCondition.apply(game, this);
    }

    @Override
    public boolean resolve(Game game) {
        if (!this.checkInterveningIfClause(game)) {
            return false;
        }
        if (this.isOptional()) {
            MageObject object = game.getObject(this.getSourceId());
            Player player = game.getPlayer(this.getControllerId());
            if (player == null || object == null || this.doOnlyOnceEachTurn && this.checkUsedAlready(game) || !player.chooseUse(this.getEffects().getOutcome(this), this.getRule(object.getLogName()), this, game)) {
                return false;
            }
            if (this.doOnlyOnceEachTurn) {
                TriggeredAbility.setDidThisTurn(this, game);
            }
        }
        return super.resolve(game);
    }

    @Override
    public String getGameLogMessage(Game game) {
        MageObject object = game.getObject(this.sourceId);
        StringBuilder sb = new StringBuilder();
        if (object != null) {
            sb.append("Ability triggers: ").append(object.getLogName()).append(" - ").append(this.getRule(object.getLogName()));
        } else {
            sb.append("Ability triggers: ").append(this.getRule());
        }
        String targetText = this.getTargetDescriptionForLog(this.getTargets(), game);
        if (!targetText.isEmpty()) {
            sb.append(" - ").append(targetText);
        }
        return sb.toString();
    }

    @Override
    public String getRule() {
        String superRule;
        String conditionText;
        StringBuilder sb = new StringBuilder();
        sb.append(this.triggerPhrase == null ? "" : this.triggerPhrase);
        if (this.interveningIfCondition != null && !(conditionText = this.interveningIfCondition.toString()).isEmpty()) {
            if (this.replaceRuleText && this.triggerPhrase != null && this.triggerPhrase.contains("{this}") && (conditionText = conditionText.replace("{this}", "it")).startsWith("it is ")) {
                conditionText = conditionText.replace("it is ", "it's ");
            }
            if (!conditionText.startsWith("if ")) {
                sb.append("if ");
            }
            sb.append(conditionText).append(", ");
        }
        if (!(superRule = super.getRule(true)).isEmpty()) {
            String ruleLow = superRule.toLowerCase(Locale.ENGLISH);
            if (this.isOptional()) {
                if (ruleLow.startsWith("you ")) {
                    if (!ruleLow.startsWith("you may")) {
                        StringBuilder newRule = new StringBuilder(superRule);
                        newRule.insert(4, "may ");
                        superRule = newRule.toString();
                    }
                } else if (!ruleLow.startsWith("{this}") && (this.getTargets().isEmpty() || TriggeredAbilityImpl.startsWithVerb(ruleLow))) {
                    sb.append("you may ");
                } else if (!ruleLow.startsWith("its controller may")) {
                    sb.append("you may have ");
                    superRule = superRule.replaceFirst(" (become|block|deal|discard|gain|get|lose|mill|sacrifice)s? ", " $1 ");
                }
            }
            if (this.replaceRuleText && this.triggerPhrase != null) {
                superRule = superRule.replaceFirst("^((?:you may )?sacrifice |(put|remove) [^ ]+ [^ ]+ counters? (on|from) |return |transform |untap |regenerate |attach |exile )?\\{this\\}", "$1it");
            }
            sb.append(superRule);
            if (this.triggerLimitEachTurn != Integer.MAX_VALUE) {
                sb.append(" This ability triggers only ");
                switch (this.triggerLimitEachTurn) {
                    case 1: {
                        sb.append("once");
                        break;
                    }
                    case 2: {
                        sb.append("twice");
                        break;
                    }
                    default: {
                        sb.append(CardUtil.numberToText(this.triggerLimitEachTurn)).append(" times");
                    }
                }
                sb.append(" each turn.");
            }
            if (this.triggerLimitEachGame != Integer.MAX_VALUE) {
                sb.append(" This ability triggers only ");
                switch (this.triggerLimitEachGame) {
                    case 1: {
                        sb.append("once.");
                        break;
                    }
                    case 2: {
                        sb.append("twice.");
                        break;
                    }
                    default: {
                        sb.append(CardUtil.numberToText(this.triggerLimitEachGame)).append(" times.");
                    }
                }
            }
            if (this.doOnlyOnceEachTurn) {
                sb.append(" Do this only once each turn.");
            }
        }
        return this.addRulePrefix(sb.toString());
    }

    private static boolean startsWithVerb(String ruleLow) {
        return ruleLow.startsWith("attach") || ruleLow.startsWith("cast") || ruleLow.startsWith("change") || ruleLow.startsWith("counter") || ruleLow.startsWith("create") || ruleLow.startsWith("destroy") || ruleLow.startsWith("distribute") || ruleLow.startsWith("sacrifice") || ruleLow.startsWith("exchange") || ruleLow.startsWith("exile") || ruleLow.startsWith("gain") || ruleLow.startsWith("goad") || ruleLow.startsWith("have") || ruleLow.startsWith("move") || ruleLow.startsWith("prevent") || ruleLow.startsWith("put") || ruleLow.startsWith("remove") || ruleLow.startsWith("return") || ruleLow.startsWith("shuffle") || ruleLow.startsWith("turn") || ruleLow.startsWith("tap") || ruleLow.startsWith("untap");
    }

    protected final String getWhen() {
        return !this.optional && this.getAllEffects().stream().anyMatch(effect -> effect instanceof SacrificeSourceEffect || effect instanceof ReturnToHandSourceEffect || effect instanceof ShuffleIntoLibrarySourceEffect || effect instanceof ExileSourceEffect || effect instanceof FlipSourceEffect || effect instanceof DestroySourceEffect) ? "When " : "Whenever ";
    }

    @Override
    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        UUID affectedSourceId = TriggeredAbilityImpl.getRealSourceObjectId(this, sourceObject);
        MageObject affectedSourceObject = sourceObject;
        if (event != null) {
            switch (event.getType()) {
                case ZONE_CHANGE: {
                    ZoneChangeEvent zce = (ZoneChangeEvent)event;
                    Set<UUID> eventTargets = CardUtil.getEventTargets(event);
                    if (eventTargets.contains(this.getSourceId()) && !zce.getToZone().isPublicZone() && zce.getFromZone().match(Zone.GRAVEYARD) && !CardUtil.cardHadAbility(this, game.getLastKnownInformationCard(this.getSourceId(), zce.getFromZone()), this.getSourceId(), game)) {
                        return false;
                    }
                    if (!this.isLeavesTheBattlefieldTrigger() || !game.checkShortLivingLKI(affectedSourceId, Zone.BATTLEFIELD)) break;
                    affectedSourceObject = game.getLastKnownInformation(affectedSourceId, Zone.BATTLEFIELD);
                    break;
                }
                case DESTROYED_PERMANENT: 
                case EXPLOITED_CREATURE: 
                case SACRIFICED_PERMANENT: {
                    if (!this.isLeavesTheBattlefieldTrigger() || !game.checkShortLivingLKI(affectedSourceId, Zone.BATTLEFIELD)) break;
                    affectedSourceObject = game.getPermanentOrLKIBattlefield(affectedSourceId);
                }
            }
        }
        return super.isInUseableZone(game, affectedSourceObject, event);
    }

    @Override
    public boolean isLeavesTheBattlefieldTrigger() {
        return this.leavesTheBattlefieldTrigger;
    }

    @Override
    public final void setLeavesTheBattlefieldTrigger(boolean leavesTheBattlefieldTrigger) {
        this.leavesTheBattlefieldTrigger = leavesTheBattlefieldTrigger;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public TriggeredAbilityImpl setAbilityWord(AbilityWord abilityWord) {
        super.setAbilityWord(abilityWord);
        return this;
    }

    public static boolean isInUseableZoneDiesTrigger(TriggeredAbility sourceAbility, MageObject sourceObject, GameEvent event, Game game) {
        Zone after;
        if (!sourceAbility.isLeavesTheBattlefieldTrigger()) {
            throw new IllegalArgumentException("Wrong code usage: all dies triggers must use setLeavesTheBattlefieldTrigger(true) and override isInUseableZone - " + sourceAbility.getSourceObject(game) + " - " + sourceAbility);
        }
        if (event instanceof BatchEvent) {
            throw new IllegalArgumentException("Wrong code usage: batch events unsupported here, possible miss of override isInUseableZone - " + sourceAbility.getSourceObject(game) + " - " + sourceAbility);
        }
        UUID affectedSourceId = TriggeredAbilityImpl.getRealSourceObjectId(sourceAbility, sourceObject);
        MageObject affectedObject = null;
        if (game.getState().getZone(affectedSourceId) == Zone.BATTLEFIELD) {
            affectedObject = game.getPermanent(affectedSourceId);
        } else if (game.checkShortLivingLKI(affectedSourceId, Zone.BATTLEFIELD)) {
            affectedObject = game.getLastKnownInformation(affectedSourceId, Zone.BATTLEFIELD);
        }
        if (affectedObject == null && ((affectedObject = game.getObject(sourceAbility)) == null || affectedObject.isPermanent(game))) {
            return false;
        }
        if (!sourceAbility.hasSourceObjectAbility(game, affectedObject, event)) {
            return false;
        }
        return !affectedSourceId.equals(event.getTargetId()) || affectedObject instanceof PermanentToken || affectedObject.getZoneChangeCounter(game) + 1 != game.getState().getZoneChangeCounter(affectedSourceId) || Zone.GRAVEYARD.match(after = game.getState().getZone(affectedSourceId));
    }
}

