/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.abilityword;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.AbilityWord;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

public class ConstellationAbility
extends TriggeredAbilityImpl {
    private final boolean thisOr;

    public ConstellationAbility(Effect effect) {
        this(effect, false);
    }

    public ConstellationAbility(Effect effect, boolean optional) {
        this(effect, optional, true);
    }

    public ConstellationAbility(Effect effect, boolean optional, boolean thisOr) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.thisOr = thisOr;
        this.setAbilityWord(AbilityWord.CONSTELLATION);
        this.setTriggerPhrase("Whenever " + (thisOr ? "{this} or another" : "an") + " enchantment you control enters, ");
    }

    protected ConstellationAbility(ConstellationAbility ability) {
        super(ability);
        this.thisOr = ability.thisOr;
    }

    @Override
    public ConstellationAbility copy() {
        return new ConstellationAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getPlayerId().equals(this.getControllerId())) {
            return false;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        return permanent != null && (this.thisOr && permanent.getId().equals(this.getSourceId()) || permanent.isEnchantment(game));
    }
}

