/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.abilityword;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.abilityword.KinshipBaseEffect;
import mage.abilities.effects.Effect;
import mage.constants.AbilityWord;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

public class KinshipAbility
extends TriggeredAbilityImpl {
    public KinshipAbility(Effect kinshipEffect) {
        super(Zone.BATTLEFIELD, new KinshipBaseEffect(kinshipEffect), true);
        this.setAbilityWord(AbilityWord.KINSHIP);
        this.setTriggerPhrase("At the beginning of your upkeep, ");
    }

    protected KinshipAbility(KinshipAbility ability) {
        super(ability);
    }

    public void addKinshipEffect(Effect kinshipEffect) {
        for (Effect effect : this.getEffects()) {
            if (!(effect instanceof KinshipBaseEffect)) continue;
            ((KinshipBaseEffect)effect).addEffect(kinshipEffect);
            break;
        }
    }

    @Override
    public KinshipAbility copy() {
        return new KinshipAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UPKEEP_STEP_PRE;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getPlayerId().equals(this.controllerId);
    }
}

