/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.common.AnimateDeadDelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

class AnimateDeadPutOntoBattlefieldEffect
extends OneShotEffect {
    private final boolean becomesAura;
    private final boolean tapped;

    public AnimateDeadPutOntoBattlefieldEffect(boolean becomesAura, boolean tapped) {
        super(Outcome.PutCreatureInPlay);
        this.becomesAura = becomesAura;
        this.tapped = tapped;
        StringBuilder sb = new StringBuilder(becomesAura || tapped ? "put " : "return ");
        sb.append(becomesAura ? "target creature card from a graveyard" : "enchanted creature card");
        sb.append(becomesAura || tapped ? " onto" : " to");
        sb.append(" the battlefield ");
        if (tapped) {
            sb.append("tapped ");
        }
        sb.append("under your control and attach {this} to it. When {this} leaves the battlefield, that creature's controller sacrifices it");
        this.staticText = sb.toString();
    }

    private AnimateDeadPutOntoBattlefieldEffect(AnimateDeadPutOntoBattlefieldEffect effect) {
        super(effect);
        this.becomesAura = effect.becomesAura;
        this.tapped = effect.tapped;
    }

    @Override
    public AnimateDeadPutOntoBattlefieldEffect copy() {
        return new AnimateDeadPutOntoBattlefieldEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent enchantment = source.getSourcePermanentIfItStillExists(game);
        if (player == null || enchantment == null) {
            return false;
        }
        Card card = game.getCard(this.becomesAura ? this.getTargetPointer().getFirst(game, source) : enchantment.getAttachedTo());
        if (card == null || game.getState().getZone(card.getId()) != Zone.GRAVEYARD) {
            return true;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game, this.tapped, false, false, null);
        game.processAction();
        Permanent creature = CardUtil.getPermanentFromCardPutToBattlefield(card, game);
        if (creature == null) {
            return true;
        }
        creature.addAttachment(enchantment.getId(), source, game);
        game.addDelayedTriggeredAbility(new AnimateDeadDelayedTriggeredAbility(new FixedTarget(creature, game)), source);
        return true;
    }
}

