/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.common.CantPayLifeEffect;
import mage.abilities.common.CantSacrificeEffect;
import mage.abilities.common.SimpleStaticAbility;
import mage.filter.FilterPermanent;

public class CantPayLifeOrSacrificeAbility
extends SimpleStaticAbility {
    private final String rule;

    public CantPayLifeOrSacrificeAbility(FilterPermanent sacrificeFilter) {
        this(false, sacrificeFilter);
    }

    public CantPayLifeOrSacrificeAbility(boolean onlyNonManaAbilities, FilterPermanent sacrificeFilter) {
        super(new CantPayLifeEffect(onlyNonManaAbilities));
        if (sacrificeFilter != null) {
            this.addEffect(new CantSacrificeEffect(onlyNonManaAbilities, sacrificeFilter));
        }
        this.rule = this.makeRule(onlyNonManaAbilities, sacrificeFilter);
    }

    private CantPayLifeOrSacrificeAbility(CantPayLifeOrSacrificeAbility effect) {
        super(effect);
        this.rule = effect.rule;
    }

    @Override
    public CantPayLifeOrSacrificeAbility copy() {
        return new CantPayLifeOrSacrificeAbility(this);
    }

    String makeRule(boolean nonManaAbilities, FilterPermanent sacrificeFilter) {
        StringBuilder sb = new StringBuilder("Players can't pay life");
        if (sacrificeFilter != null) {
            sb.append(" or sacrifice ").append(sacrificeFilter.getMessage());
        }
        sb.append(" to cast spells or activate abilities");
        if (nonManaAbilities) {
            sb.append(" that aren't mana abilities");
        }
        sb.append(".");
        return sb.toString();
    }

    @Override
    public String getRule() {
        return this.rule;
    }
}

