/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.common.SolveEffect;
import mage.abilities.condition.CompoundCondition;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SolvedSourceCondition;
import mage.abilities.triggers.BeginningOfEndStepTriggeredAbility;
import mage.constants.TargetController;
import mage.util.CardUtil;

class CaseSolveAbility
extends BeginningOfEndStepTriggeredAbility {
    CaseSolveAbility(Condition condition) {
        super(TargetController.YOU, new SolveEffect(), false, new CompoundCondition(condition, SolvedSourceCondition.UNSOLVED));
        this.withFlavorWord("To solve");
        this.setTriggerPhrase(CardUtil.getTextWithFirstCharUpperCase(CaseSolveAbility.trimIf(condition.toString())));
    }

    private CaseSolveAbility(CaseSolveAbility ability) {
        super(ability);
    }

    @Override
    public CaseSolveAbility copy() {
        return new CaseSolveAbility(this);
    }

    @Override
    public String getRule() {
        return super.getRule() + ". <i>(If unsolved, solve at the beginning of your end step.)</i>";
    }

    private static String trimIf(String text) {
        if (text.startsWith("if ")) {
            return text.substring(3);
        }
        return text;
    }
}

