/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

public class DealsCombatDamageToAPlayerOrBattleTriggeredAbility
extends TriggeredAbilityImpl {
    public DealsCombatDamageToAPlayerOrBattleTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.setTriggerPhrase("Whenever {this} deals combat damage to a player or battle, ");
    }

    protected DealsCombatDamageToAPlayerOrBattleTriggeredAbility(DealsCombatDamageToAPlayerOrBattleTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public DealsCombatDamageToAPlayerOrBattleTriggeredAbility copy() {
        return new DealsCombatDamageToAPlayerOrBattleTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER || event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        if (!event.getSourceId().equals(this.getSourceId()) || !((DamagedEvent)event).isCombatDamage()) {
            return false;
        }
        if (!(event.getType() != GameEvent.EventType.DAMAGED_PERMANENT || (permanent = game.getPermanent(event.getTargetId())) != null && permanent.isBattle(game))) {
            return false;
        }
        this.getAllEffects().setValue("damage", event.getAmount());
        return true;
    }
}

