/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.SetTargetPointer;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

public class DealsDamageToThisAllTriggeredAbility
extends TriggeredAbilityImpl {
    private final boolean combatOnly;
    private final FilterPermanent filterPermanent;
    private final SetTargetPointer setTargetPointer;

    public DealsDamageToThisAllTriggeredAbility(Effect effect, boolean optional, FilterPermanent filterPermanent, SetTargetPointer setTargetPointer, boolean combatOnly) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.setTargetPointer = setTargetPointer;
        this.filterPermanent = filterPermanent;
        this.combatOnly = combatOnly;
        this.setTriggerPhrase("Whenever " + CardUtil.addArticle(filterPermanent.getMessage()) + " deals " + (combatOnly ? "combat " : "") + "damage to {this}, ");
    }

    protected DealsDamageToThisAllTriggeredAbility(DealsDamageToThisAllTriggeredAbility ability) {
        super(ability);
        this.combatOnly = ability.combatOnly;
        this.filterPermanent = ability.filterPermanent;
        this.setTargetPointer = ability.setTargetPointer;
    }

    @Override
    public DealsDamageToThisAllTriggeredAbility copy() {
        return new DealsDamageToThisAllTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (this.combatOnly && !((DamagedEvent)event).isCombatDamage()) {
            return false;
        }
        if (!event.getTargetId().equals(this.sourceId)) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        if (!this.filterPermanent.match(permanent, this.getControllerId(), (Ability)this, game)) {
            return false;
        }
        int damageAmount = event.getAmount();
        if (damageAmount < 1) {
            return false;
        }
        this.getEffects().setValue("damage", damageAmount);
        this.getEffects().setValue("sourceId", event.getSourceId());
        switch (this.setTargetPointer) {
            case PLAYER: {
                this.getEffects().setTargetPointer(new FixedTarget(permanent.getControllerId()));
                break;
            }
            case PERMANENT: {
                this.getEffects().setTargetPointer(new FixedTarget(permanent, game));
            }
        }
        return true;
    }
}

