/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.MageObject;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.constants.SetTargetPointer;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

public class DiesAttachedTriggeredAbility
extends TriggeredAbilityImpl {
    private final String attachedDescription;
    private final boolean diesRuleText;
    protected SetTargetPointer setTargetPointer;
    private final boolean rememberSource;

    public DiesAttachedTriggeredAbility(Effect effect, String attachedDescription) {
        this(effect, attachedDescription, false);
    }

    public DiesAttachedTriggeredAbility(Effect effect, String attachedDescription, boolean optional) {
        this(effect, attachedDescription, optional, true);
    }

    public DiesAttachedTriggeredAbility(Effect effect, String attachedDescription, boolean optional, boolean diesRuleText) {
        this(effect, attachedDescription, optional, diesRuleText, SetTargetPointer.NONE);
    }

    public DiesAttachedTriggeredAbility(Effect effect, String attachedDescription, boolean optional, boolean diesRuleText, SetTargetPointer setTargetPointer) {
        this(effect, attachedDescription, optional, diesRuleText, setTargetPointer, false);
    }

    public DiesAttachedTriggeredAbility(Effect effect, String attachedDescription, boolean optional, boolean diesRuleText, SetTargetPointer setTargetPointer, boolean rememberSource) {
        super(Zone.ALL, effect, optional);
        this.attachedDescription = attachedDescription;
        this.diesRuleText = diesRuleText;
        this.setTargetPointer = setTargetPointer;
        this.rememberSource = rememberSource;
        this.setTriggerPhrase(this.generateTriggerPhrase());
        this.setLeavesTheBattlefieldTrigger(true);
    }

    protected DiesAttachedTriggeredAbility(DiesAttachedTriggeredAbility ability) {
        super(ability);
        this.attachedDescription = ability.attachedDescription;
        this.diesRuleText = ability.diesRuleText;
        this.setTargetPointer = ability.setTargetPointer;
        this.rememberSource = ability.rememberSource;
    }

    @Override
    public DiesAttachedTriggeredAbility copy() {
        return new DiesAttachedTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent attachedTo;
        Permanent attachment;
        if (!((ZoneChangeEvent)event).isDiesEvent()) {
            return false;
        }
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        boolean triggered = false;
        if (zEvent.getTarget() != null && zEvent.getTarget().getAttachments() != null && zEvent.getTarget().getAttachments().contains(this.getSourceId())) {
            triggered = true;
        } else {
            Permanent attachedTo2;
            attachment = this.getSourcePermanentOrLKI(game);
            Card attachmentCard = game.getCard(this.getSourceId());
            if (attachment != null && zEvent.getTargetId() != null && attachment.getAttachedTo() != null && zEvent.getTargetId().equals(attachment.getAttachedTo()) && (attachedTo2 = game.getPermanentOrLKIBattlefield(attachment.getAttachedTo())) != null && game.getState().getZone(attachedTo2.getId()) == Zone.GRAVEYARD && attachmentCard != null && attachment.getAttachedToZoneChangeCounter() == attachedTo2.getZoneChangeCounter(game) && attachment.getZoneChangeCounter(game) == attachmentCard.getZoneChangeCounter(game)) {
                triggered = true;
            }
        }
        if (!triggered) {
            return false;
        }
        if (zEvent.getTarget() == null) {
            return true;
        }
        this.getEffects().setValue("attachedTo", zEvent.getTarget());
        this.getEffects().setValue("zcc", zEvent.getTarget().getZoneChangeCounter(game) + 1);
        if (this.setTargetPointer == SetTargetPointer.ATTACHED_TO_CONTROLLER && (attachment = game.getPermanentOrLKIBattlefield(this.getSourceId())) != null && attachment.getAttachedTo() != null && (attachedTo = (Permanent)game.getLastKnownInformation(attachment.getAttachedTo(), Zone.BATTLEFIELD, attachment.getAttachedToZoneChangeCounter())) != null) {
            this.getEffects().setTargetPointer(new FixedTarget(attachedTo.getControllerId()));
        }
        if (this.setTargetPointer == SetTargetPointer.CARD || this.setTargetPointer == SetTargetPointer.PERMANENT) {
            attachment = game.getPermanentOrLKIBattlefield(this.getSourceId());
            if (this.rememberSource) {
                if (attachment != null) {
                    this.getEffects().setTargetPointer(new FixedTarget(attachment.getId()));
                }
            } else if (attachment != null && attachment.getAttachedTo() != null && (attachedTo = (Permanent)game.getLastKnownInformation(attachment.getAttachedTo(), Zone.BATTLEFIELD, attachment.getAttachedToZoneChangeCounter())) != null) {
                this.getEffects().setTargetPointer(new FixedTarget(attachedTo.getId()));
            }
        }
        return true;
    }

    private String generateTriggerPhrase() {
        StringBuilder sb = new StringBuilder();
        if (this.attachedDescription.startsWith("equipped")) {
            sb.append("Whenever ");
        } else {
            sb.append("When ");
        }
        sb.append(this.attachedDescription);
        if (this.diesRuleText) {
            sb.append(" dies, ");
        } else {
            sb.append(" is put into a graveyard, ");
        }
        return sb.toString();
    }

    @Override
    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger(this, sourceObject, event, game);
    }
}

